/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.client.renderer;

import de.markusbordihn.scraptechworkshop.block.entity.HoloCubeBlockEntity;
import de.markusbordihn.scraptechworkshop.block.hololog.HoloCubeBlock;
import de.markusbordihn.scraptechworkshop.client.hololog.HolologPlayer;
import de.markusbordihn.scraptechworkshop.data.hololog.HolologData;
import de.markusbordihn.scraptechworkshop.data.hololog.HolologParser;
import de.markusbordihn.scraptechworkshop.data.hololog.HolologStatus;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_7923;
import net.minecraft.class_811;
import net.minecraft.class_827;
import net.minecraft.class_897;
import net.minecraft.class_898;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HoloCubeBlockEntityRenderer<T extends HoloCubeBlockEntity>
implements class_827<T> {
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");
    private static final double HOLOGRAM_CENTER_X = 0.5;
    private static final double HOLOGRAM_CENTER_Z = 0.5;
    private static final double HOLOGRAM_Y_OFFSET_ITEM = 0.7;
    private static final double HOLOGRAM_Y_OFFSET_BLOCK = 0.8;
    private static final double HOLOGRAM_Y_OFFSET_DEFAULT = 0.5;
    private static final float BLOCK_SCALE_MULTIPLIER = 0.6f;
    private static final float ENTITY_SCALE_MULTIPLIER = 0.8f;
    private static final float ENTITY_HEAD_BOB_SPEED = 0.1f;
    private static final float ENTITY_HEAD_BOB_AMOUNT = 3.0f;
    private static final int RENDER_DISTANCE = 32;
    private final Map<class_2960, class_1297> entityCache = new HashMap<class_2960, class_1297>();

    public HoloCubeBlockEntityRenderer(class_5614.class_5615 context) {
    }

    public void render(T blockEntity, float partialTicks, class_4587 poseStack, class_4597 buffer, int combinedLight, int combinedOverlay) {
        if (blockEntity.method_11010().method_11654(HoloCubeBlock.STATUS) != HolologStatus.PLAYING) {
            return;
        }
        class_2960 holologId = ((HoloCubeBlockEntity)((Object)blockEntity)).getHolologId();
        if (holologId == null) {
            return;
        }
        Optional<HolologData> holologData = HolologParser.getHololog(HolologParser.getLocalizedId(holologId));
        if (holologData.isEmpty()) {
            return;
        }
        HolologData.HolologDisplayEntity displayEntity = this.getDisplayEntity(holologData.get());
        if (displayEntity == null) {
            displayEntity = HolologData.HolologDisplayEntity.DEFAULT_VILLAGER;
        }
        try {
            switch (displayEntity.type()) {
                case ENTITY: {
                    this.renderEntity(blockEntity, displayEntity, poseStack, buffer, combinedLight);
                    break;
                }
                case BLOCK: {
                    this.renderBlock(blockEntity, displayEntity, poseStack, buffer, combinedLight, combinedOverlay);
                    break;
                }
                case ITEM: {
                    this.renderItem(blockEntity, displayEntity, poseStack, buffer, combinedLight, combinedOverlay);
                }
            }
        }
        catch (Exception e) {
            log.error("Failed to render hologram display {} for block entity at {}: {}", (Object)displayEntity.id(), (Object)blockEntity.method_11016(), (Object)e.getMessage());
        }
    }

    private HolologData.HolologDisplayEntity getDisplayEntity(HolologData hololog) {
        HolologData.HolologLine line;
        int currentLine = HolologPlayer.getCurrentLine(hololog.id());
        int displayLineIndex = Math.max(0, currentLine - 1);
        if (currentLine > 0 && displayLineIndex < hololog.lines().size() && (line = hololog.lines().get(displayLineIndex)).displayEntity() != null) {
            return line.displayEntity();
        }
        return hololog.displayEntity();
    }

    private void renderEntity(T blockEntity, HolologData.HolologDisplayEntity displayEntity, class_4587 poseStack, class_4597 buffer, int combinedLight) {
        class_1297 entity = this.getOrCreateEntity(blockEntity.method_10997(), displayEntity.id());
        if (entity == null) {
            return;
        }
        class_898 dispatcher = class_310.method_1551().method_1561();
        class_897 renderer = dispatcher.method_3953(entity);
        class_1937 level = blockEntity.method_10997();
        if (level != null) {
            entity.field_6012 = (int)level.method_8510();
        }
        poseStack.method_22903();
        this.prepareHologramPose(blockEntity, displayEntity, poseStack);
        renderer.method_3936(entity, 0.0f, 0.0f, poseStack, buffer, combinedLight);
        poseStack.method_22909();
    }

    private void renderBlock(T blockEntity, HolologData.HolologDisplayEntity displayEntity, class_4587 poseStack, class_4597 buffer, int combinedLight, int combinedOverlay) {
        poseStack.method_22903();
        this.prepareHologramPose(blockEntity, displayEntity, poseStack);
        class_310.method_1551().method_1541().method_3353(((class_2248)class_7923.field_41175.method_10223(displayEntity.id())).method_9564(), poseStack, buffer, combinedLight, combinedOverlay);
        poseStack.method_22909();
    }

    private void renderItem(T blockEntity, HolologData.HolologDisplayEntity displayEntity, class_4587 poseStack, class_4597 buffer, int combinedLight, int combinedOverlay) {
        poseStack.method_22903();
        this.prepareHologramPose(blockEntity, displayEntity, poseStack);
        class_310.method_1551().method_1480().method_23178(new class_1799((class_1935)class_7923.field_41178.method_10223(displayEntity.id())), class_811.field_4318, combinedLight, combinedOverlay, poseStack, buffer, blockEntity.method_10997(), 0);
        poseStack.method_22909();
    }

    private class_1297 getOrCreateEntity(class_1937 level, class_2960 entityId) {
        class_1297 cached;
        if (level == null) {
            return null;
        }
        if (this.entityCache.containsKey(entityId) && (cached = this.entityCache.get(entityId)) != null && !cached.method_31481()) {
            return cached;
        }
        Optional entityType = class_7923.field_41177.method_17966(entityId);
        if (entityType.isEmpty()) {
            log.warn("Entity type not found: {}", (Object)entityId);
            return null;
        }
        class_1297 entity = ((class_1299)entityType.get()).method_5883(level);
        if (entity != null) {
            entity.method_5648(false);
            this.entityCache.put(entityId, entity);
        }
        return entity;
    }

    private void prepareHologramPose(T blockEntity, HolologData.HolologDisplayEntity displayEntity, class_4587 poseStack) {
        double yOffset;
        double d = displayEntity.type() == HolologData.DisplayType.ITEM ? 0.7 : (yOffset = displayEntity.type() == HolologData.DisplayType.BLOCK ? 0.8 : 0.5);
        if (displayEntity.type() == HolologData.DisplayType.BLOCK) {
            poseStack.method_22904(0.5, yOffset, 0.5);
            float scale = displayEntity.scale() * 0.6f;
            poseStack.method_22905(scale, scale, scale);
            class_1937 level = blockEntity.method_10997();
            if (level != null && displayEntity.rotationSpeed() > 0.0f) {
                float time = level.method_8510();
                float rotationSpeed = displayEntity.rotationSpeed();
                poseStack.method_22907(class_7833.field_40716.rotationDegrees(time * rotationSpeed));
            }
            poseStack.method_22904(-0.5, -0.5, -0.5);
        } else {
            poseStack.method_22904(0.5, yOffset, 0.5);
        }
        if (displayEntity.type() == HolologData.DisplayType.ENTITY) {
            class_310 minecraft = class_310.method_1551();
            if (minecraft.field_1724 != null) {
                class_243 blockCenter = class_243.method_24953((class_2382)blockEntity.method_11016()).method_1031(0.0, yOffset, 0.0);
                class_243 playerPos = minecraft.field_1724.method_33571();
                class_243 lookDir = playerPos.method_1020(blockCenter).method_1029();
                float yaw = (float)Math.toDegrees(Math.atan2(lookDir.field_1352, lookDir.field_1350));
                poseStack.method_22907(class_7833.field_40716.rotationDegrees(yaw));
                class_1937 level = blockEntity.method_10997();
                if (level != null) {
                    float time = (float)level.method_8510() + (float)minecraft.method_47600() / 1.0E9f;
                    float headBob = (float)Math.sin(time * 0.1f) * 3.0f;
                    poseStack.method_22907(class_7833.field_40714.rotationDegrees(headBob));
                }
            }
            float scale = displayEntity.scale() * 0.8f;
            poseStack.method_22905(scale, scale, scale);
        } else if (displayEntity.type() == HolologData.DisplayType.ITEM) {
            class_1937 level = blockEntity.method_10997();
            if (level != null && displayEntity.rotationSpeed() > 0.0f) {
                float time = level.method_8510();
                float rotationSpeed = displayEntity.rotationSpeed();
                poseStack.method_22907(class_7833.field_40716.rotationDegrees(time * rotationSpeed));
            }
            float scale = displayEntity.scale();
            poseStack.method_22905(scale, scale, scale);
        }
    }

    public int method_33893() {
        return 32;
    }
}

