/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.data.hololog;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.markusbordihn.scraptechworkshop.data.hololog.HolologData;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HolologParser {
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");
    private static final Gson GSON = new Gson();
    private static final Map<class_2960, HolologData> CACHE = new HashMap<class_2960, HolologData>();

    private HolologParser() {
    }

    public static class_2960 getLocalizedId(class_2960 id) {
        try {
            class_2960 englishId;
            String[] parts = id.method_12832().split("/", 2);
            if (parts.length < 2) {
                return id;
            }
            String languageCode = class_310.method_1551().method_1526().method_4669().split("_")[0];
            class_2960 localizedId = new class_2960(id.method_12836(), parts[0] + "/" + languageCode + "/" + parts[1]);
            if (HolologParser.holologExists(localizedId)) {
                return localizedId;
            }
            if (!languageCode.equals("en") && HolologParser.holologExists(englishId = new class_2960(id.method_12836(), parts[0] + "/en/" + parts[1]))) {
                log.debug("Using English fallback hololog: {}", (Object)englishId);
                return englishId;
            }
            log.debug("Using original hololog path: {}", (Object)id);
            return id;
        }
        catch (Exception e) {
            log.debug("Cannot access client (server-side?), using original path: {}", (Object)id);
            return id;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean holologExists(class_2960 id) {
        boolean bl;
        if (CACHE.containsKey(id)) {
            return true;
        }
        class_310 minecraft = class_310.method_1551();
        class_3300 resourceManager = minecraft.method_1478();
        class_2960 resourcePath = new class_2960(id.method_12836(), id.method_12832() + ".json");
        Optional resource = resourceManager.method_14486(resourcePath);
        if (!resource.isEmpty()) return resource.isPresent();
        String classpathPath = "/assets/" + id.method_12836() + "/" + id.method_12832() + ".json";
        InputStream stream = HolologParser.class.getResourceAsStream(classpathPath);
        try {
            boolean bl2 = bl = stream != null;
            if (stream == null) return bl;
        }
        catch (Throwable throwable) {
            try {
                if (stream == null) throw throwable;
                try {
                    stream.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return false;
            }
        }
        stream.close();
        return bl;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static Optional<HolologData> getHololog(class_2960 id) {
        block15: {
            if (CACHE.containsKey(id)) {
                return Optional.of(CACHE.get(id));
            }
            try {
                class_310 minecraft = class_310.method_1551();
                class_3300 resourceManager = minecraft.method_1478();
                Optional resource = resourceManager.method_14486(new class_2960(id.method_12836(), id.method_12832() + ".json"));
                InputStream stream = null;
                if (resource.isPresent()) {
                    stream = ((class_3298)resource.get()).method_14482();
                    log.debug("Loaded hololog from ResourceManager: {}", (Object)id);
                } else {
                    String classpathPath = "/assets/" + id.method_12836() + "/" + id.method_12832() + ".json";
                    stream = HolologParser.class.getResourceAsStream(classpathPath);
                    if (stream != null) {
                        log.debug("Loaded hololog from classpath: {}", (Object)classpathPath);
                    } else {
                        log.error("Hololog not found: {}", (Object)id);
                    }
                }
                if (stream == null) break block15;
                try {
                    Optional<HolologData> optional;
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
                        JsonObject json = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                        Optional<HolologData> data = HolologParser.parseHolologJson(json);
                        data.ifPresent(hololog -> {
                            CACHE.put(id, (HolologData)hololog);
                            log.debug("Cached hololog: {}", (Object)id);
                        });
                        optional = data;
                    }
                    return optional;
                }
                finally {
                    stream.close();
                }
            }
            catch (Exception e) {
                log.error("Failed to load hololog {}: {}", (Object)id, (Object)e.getMessage(), (Object)e);
            }
        }
        return Optional.empty();
    }

    private static Optional<HolologData> parseHolologJson(JsonObject json) {
        if (json == null) {
            log.warn("Empty or invalid JSON");
            return Optional.empty();
        }
        class_2960 id = new class_2960(json.get("id").getAsString());
        String title = json.get("title").getAsString();
        String subtitle = json.has("subtitle") ? json.get("subtitle").getAsString() : "";
        String titleColor = json.has("titleColor") ? json.get("titleColor").getAsString() : "#FFFFFF";
        String subtitleColor = json.has("subtitleColor") ? json.get("subtitleColor").getAsString() : "#AAAAAA";
        int lineDelayTicks = json.has("lineDelayTicks") ? json.get("lineDelayTicks").getAsInt() : 40;
        int charDelayTicks = json.has("charDelayTicks") ? json.get("charDelayTicks").getAsInt() : 1;
        class_2960 voiceOver = null;
        if (json.has("voiceOver")) {
            voiceOver = new class_2960(json.get("voiceOver").getAsString());
        }
        HolologData.HolologDisplayEntity displayEntity = null;
        if (json.has("displayEntity")) {
            displayEntity = HolologParser.parseDisplayEntity(json.getAsJsonObject("displayEntity"));
        }
        HolologData.HolologEffects start = json.has("start") ? HolologParser.parseEffects(json.getAsJsonObject("start")) : HolologData.HolologEffects.EMPTY;
        ArrayList<HolologData.HolologLine> lines = new ArrayList<HolologData.HolologLine>();
        if (json.has("lines")) {
            JsonArray linesArray = json.getAsJsonArray("lines");
            for (JsonElement lineElement : linesArray) {
                JsonObject lineObj = lineElement.getAsJsonObject();
                String text = lineObj.get("text").getAsString();
                HolologData.HolologDisplayEntity lineDisplayEntity = null;
                if (lineObj.has("displayEntity")) {
                    lineDisplayEntity = HolologParser.parseDisplayEntity(lineObj.getAsJsonObject("displayEntity"));
                }
                HolologData.HolologEffects effects = lineObj.has("sfx") || lineObj.has("fx") ? HolologParser.parseEffects(lineObj) : HolologData.HolologEffects.EMPTY;
                lines.add(new HolologData.HolologLine(text, lineDisplayEntity, effects));
            }
        }
        HolologData.HolologEffects end = json.has("end") ? HolologParser.parseEffects(json.getAsJsonObject("end")) : HolologData.HolologEffects.EMPTY;
        return Optional.of(new HolologData(id, title, subtitle, titleColor, subtitleColor, lineDelayTicks, charDelayTicks, voiceOver, displayEntity, start, lines, end));
    }

    private static HolologData.HolologDisplayEntity parseDisplayEntity(JsonObject json) {
        HolologData.DisplayType type;
        try {
            type = HolologData.DisplayType.valueOf(json.has("type") ? json.get("type").getAsString().toUpperCase() : "ENTITY");
        }
        catch (IllegalArgumentException e) {
            log.warn("Invalid display type '{}', defaulting to ENTITY", (Object)(json.has("type") ? json.get("type").getAsString() : "null"));
            type = HolologData.DisplayType.ENTITY;
        }
        class_2960 id = new class_2960(json.get("id").getAsString());
        float scale = json.has("scale") ? json.get("scale").getAsFloat() : 0.5f;
        float rotationSpeed = json.has("rotationSpeed") ? json.get("rotationSpeed").getAsFloat() : 1.0f;
        return new HolologData.HolologDisplayEntity(type, id, scale, rotationSpeed);
    }

    private static HolologData.HolologEffects parseEffects(JsonObject json) {
        ArrayList<HolologData.HolologSound> sounds = new ArrayList<HolologData.HolologSound>();
        if (json.has("sfx")) {
            JsonArray sfxArray = json.getAsJsonArray("sfx");
            for (JsonElement sfxElement : sfxArray) {
                JsonObject sfxObj = sfxElement.getAsJsonObject();
                class_2960 id = new class_2960(sfxObj.get("id").getAsString());
                float volume = sfxObj.has("volume") ? sfxObj.get("volume").getAsFloat() : 1.0f;
                float pitch = sfxObj.has("pitch") ? sfxObj.get("pitch").getAsFloat() : 1.0f;
                sounds.add(new HolologData.HolologSound(id, volume, pitch));
            }
        }
        ArrayList<HolologData.HolologParticle> particles = new ArrayList<HolologData.HolologParticle>();
        if (json.has("fx")) {
            JsonArray fxArray = json.getAsJsonArray("fx");
            for (JsonElement fxElement : fxArray) {
                JsonObject fxObj = fxElement.getAsJsonObject();
                class_2960 id = new class_2960(fxObj.get("id").getAsString());
                int count = fxObj.has("count") ? fxObj.get("count").getAsInt() : 5;
                String color = fxObj.has("color") ? fxObj.get("color").getAsString() : null;
                float scale = fxObj.has("scale") ? fxObj.get("scale").getAsFloat() : 1.0f;
                particles.add(new HolologData.HolologParticle(id, count, color, scale));
            }
        }
        return new HolologData.HolologEffects(sounds, particles);
    }

    public static void clearCache() {
        CACHE.clear();
    }
}

