/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.item.tool.multitool;

import de.markusbordihn.scraptechworkshop.Constants;
import de.markusbordihn.scraptechworkshop.config.MultitoolConfig;
import de.markusbordihn.scraptechworkshop.data.energy.EnergyData;
import de.markusbordihn.scraptechworkshop.data.multitool.DisplayMode;
import de.markusbordihn.scraptechworkshop.data.multitool.ScrapMultitoolData;
import de.markusbordihn.scraptechworkshop.data.multitool.ToolMode;
import de.markusbordihn.scraptechworkshop.energy.EnergyManager;
import de.markusbordihn.scraptechworkshop.item.ModItems;
import de.markusbordihn.scraptechworkshop.item.component.EnergyCellItem;
import de.markusbordihn.scraptechworkshop.item.multitool.ToolModeDetector;
import de.markusbordihn.scraptechworkshop.menu.ScrapMultitoolMenuProvider;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1766;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1832;
import net.minecraft.class_1834;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3908;
import net.minecraft.class_5250;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScrapMultitoolItem
extends class_1766 {
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");

    public ScrapMultitoolItem(class_1792.class_1793 properties) {
        super(4.0f, -2.4f, (class_1832)class_1834.field_8923, class_3481.field_33715, properties.method_7895(MultitoolConfig.energyMax).method_7894(class_1814.field_8903));
    }

    public static class_1799 createWithBattery() {
        class_1799 battery = new class_1799((class_1935)ModItems.SLIGHTLY_DAMAGED_ENERGY_CELL.get());
        class_1792 class_17922 = battery.method_7909();
        if (class_17922 instanceof EnergyCellItem) {
            EnergyCellItem energyCell = (EnergyCellItem)class_17922;
            energyCell.setEnergy(battery, 2500);
        }
        class_1799 multitool = new class_1799((class_1935)ModItems.SCRAP_MULTITOOL.get());
        ScrapMultitoolData data = ScrapMultitoolData.createDefault().withBattery(battery);
        data.saveToItemStack(multitool);
        class_1792 class_17923 = multitool.method_7909();
        if (class_17923 instanceof ScrapMultitoolItem) {
            ScrapMultitoolItem multitoolItem = (ScrapMultitoolItem)class_17923;
            multitoolItem.syncEnergyWithBattery(multitool);
        }
        DisplayMode displayMode = new DisplayMode(multitool);
        displayMode.updateModel(ToolMode.fromId(data.activeMode()), data.getBatteryLevel());
        return multitool;
    }

    public void method_7843(class_1799 itemStack, class_1937 level, class_1657 player) {
        super.method_7843(itemStack, level, player);
        ScrapMultitoolData data = ScrapMultitoolData.fromItemStack(itemStack);
        if (!data.hasBattery()) {
            class_1799 battery = new class_1799((class_1935)ModItems.SLIGHTLY_DAMAGED_ENERGY_CELL.get());
            class_1792 class_17922 = battery.method_7909();
            if (class_17922 instanceof EnergyCellItem) {
                EnergyCellItem energyCell = (EnergyCellItem)class_17922;
                energyCell.setEnergy(battery, 2500);
            }
            data = data.withBattery(battery);
            data.saveToItemStack(itemStack);
            this.syncEnergyWithBattery(itemStack);
            DisplayMode displayMode = new DisplayMode(itemStack);
            displayMode.updateModel(ToolMode.fromId(data.activeMode()), data.getBatteryLevel());
        }
    }

    public float method_7865(class_1799 itemStack, class_2680 state) {
        boolean isEffective;
        ToolModeDetector detector = new ToolModeDetector(itemStack);
        detector.updateToolMode(null, state);
        if (!this.hasEnergyFromBattery(itemStack, MultitoolConfig.energyPerBlock)) {
            return 1.0f;
        }
        ToolMode mode = detector.getToolModeForBlock(state);
        if (mode != ToolMode.NONE) {
            return this.getPoweredSpeed(mode);
        }
        ScrapMultitoolData data = ScrapMultitoolData.fromItemStack(itemStack);
        ToolMode activeToolMode = ToolMode.fromId(data.activeMode());
        switch (activeToolMode) {
            case PICKAXE: {
                boolean bl = state.method_26164(class_3481.field_33715);
                break;
            }
            case AXE: {
                boolean bl = state.method_26164(class_3481.field_33713);
                break;
            }
            case SHOVEL: {
                boolean bl = state.method_26164(class_3481.field_33716);
                break;
            }
            case HOE: {
                boolean bl = state.method_26164(class_3481.field_33714);
                break;
            }
            default: {
                boolean bl = isEffective = state.method_26164(class_3481.field_33715);
            }
        }
        if (isEffective) {
            return this.getPoweredSpeed(activeToolMode);
        }
        return super.method_7865(itemStack, state);
    }

    public boolean method_7873(class_1799 itemStack, class_1309 target, class_1309 attacker) {
        if (attacker instanceof class_1657) {
            class_1657 player = (class_1657)attacker;
            ScrapMultitoolData data = ScrapMultitoolData.fromItemStack(itemStack);
            if (!ToolMode.SWORD.getId().equals(data.activeMode())) {
                ScrapMultitoolData newData = data.withActiveMode(ToolMode.SWORD.getId());
                newData.saveToItemStack(itemStack);
                DisplayMode displayMode = new DisplayMode(itemStack);
                displayMode.updateModel(ToolMode.SWORD, newData.getBatteryLevel());
            }
        }
        ScrapMultitoolData data = ScrapMultitoolData.fromItemStack(itemStack);
        return this.consumeEnergyFromBattery(itemStack, data, MultitoolConfig.energyPerAttack);
    }

    public boolean method_7879(class_1799 itemStack, class_1937 level, class_2680 state, class_2338 pos, class_1309 entity) {
        ScrapMultitoolData data;
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            ToolModeDetector detector = new ToolModeDetector(itemStack);
            detector.updateToolMode(player, state);
        }
        if (this.consumeEnergyFromBattery(itemStack, data = ScrapMultitoolData.fromItemStack(itemStack), MultitoolConfig.energyPerBlock)) {
            if (entity instanceof class_1657) {
                class_1657 player = (class_1657)entity;
                ToolModeDetector detector = new ToolModeDetector(itemStack);
                detector.updateToolMode(player, state);
            }
            return true;
        }
        return false;
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (player.method_5715() && !level.field_9236) {
            this.openMultitoolScreen(player, itemStack, hand);
            return class_1271.method_29237((Object)itemStack, (boolean)level.field_9236);
        }
        if (!level.field_9236) {
            ToolModeDetector detector = new ToolModeDetector(itemStack);
            class_2680 targetBlock = detector.getTargetBlock(level, player);
            detector.updateToolMode(player, targetBlock);
        }
        ScrapMultitoolData data = ScrapMultitoolData.fromItemStack(itemStack);
        if (!level.field_9236 && this.hasEnergyFromBattery(itemStack, MultitoolConfig.energyPerUse)) {
            class_243 playerPos = player.method_19538().method_1031(0.0, 1.0, 0.0);
            class_243 lookDirection = player.method_5720();
            class_243 particlePos = playerPos.method_1019(lookDirection.method_1021(1.5));
            if (level instanceof class_3218) {
                class_3218 serverLevel = (class_3218)level;
                serverLevel.method_14199((class_2394)class_2398.field_29644, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, 5, 0.1, 0.1, 0.1, 0.02);
            }
            level.method_8396(null, player.method_24515(), class_3417.field_14891, class_3419.field_15248, 0.5f, 1.2f);
            this.consumeEnergyFromBattery(itemStack, data, MultitoolConfig.energyPerUse);
        }
        return class_1271.method_22430((Object)itemStack);
    }

    public class_1269 method_7884(class_1838 context) {
        if (context.method_8036() != null && context.method_8036().method_5715()) {
            return class_1269.field_5811;
        }
        return super.method_7884(context);
    }

    private float getPoweredSpeed(ToolMode mode) {
        return switch (mode) {
            case ToolMode.PICKAXE -> 6.0f;
            case ToolMode.AXE -> 6.0f;
            case ToolMode.SHOVEL -> 6.0f;
            case ToolMode.HOE -> 4.0f;
            case ToolMode.SWORD -> 6.0f;
            default -> 6.0f;
        };
    }

    private void openMultitoolScreen(class_1657 player, class_1799 stack, class_1268 hand) {
        if (Constants.IS_FABRIC) {
            try {
                log.warn("Fabric screen opening not yet implemented");
            }
            catch (Exception e) {
                log.error("Failed to open multitool screen", (Throwable)e);
            }
        } else {
            player.method_17355((class_3908)new ScrapMultitoolMenuProvider(stack, hand));
        }
    }

    public boolean method_31567(class_1799 itemStack) {
        return true;
    }

    public int method_31571(class_1799 itemStack) {
        EnergyData energyData = EnergyManager.getEnergyData(itemStack, MultitoolConfig.energyMax);
        float energyRatio = energyData.getPercentage();
        return energyRatio > 0.6f ? 65280 : (energyRatio > 0.3f ? 0xFFFF00 : 0xFF0000);
    }

    public void method_7851(class_1799 itemStack, class_1937 level, List<class_2561> tooltipComponents, class_1836 isAdvanced) {
        tooltipComponents.add((class_2561)class_2561.method_43471((String)"item.scrap_tech_workshop.scrap_multitool.description"));
        EnergyData energyData = EnergyManager.getEnergyData(itemStack, MultitoolConfig.energyMax);
        int displayEnergy = energyData.getDisplayEnergy();
        tooltipComponents.add((class_2561)class_2561.method_43470((String)("Energy: " + displayEnergy + "%")).method_27694(style -> style.method_36139(this.method_31571(itemStack))));
        ScrapMultitoolData data = ScrapMultitoolData.fromItemStack(itemStack);
        if (data.hasBattery()) {
            tooltipComponents.add((class_2561)class_2561.method_43470((String)"Battery: Installed").method_27694(style -> style.method_36139(65280)));
        }
        String mode = data.activeMode();
        ToolMode activeMode = ToolMode.fromId(mode);
        class_5250 modeComponent = switch (activeMode) {
            case ToolMode.AXE -> class_2561.method_43470((String)"Mode: Axe (Auto-detected)").method_27694(style -> style.method_36139(0xFF8800));
            case ToolMode.PICKAXE -> class_2561.method_43470((String)"Mode: Pickaxe (Auto-detected)").method_27694(style -> style.method_36139(0x888888));
            case ToolMode.SHOVEL -> class_2561.method_43470((String)"Mode: Shovel (Auto-detected)").method_27694(style -> style.method_36139(0xBB8844));
            case ToolMode.HOE -> class_2561.method_43470((String)"Mode: Hoe (Auto-detected)").method_27694(style -> style.method_36139(43520));
            case ToolMode.SWORD -> class_2561.method_43470((String)"Mode: Sword (Combat)").method_27694(style -> style.method_36139(0xFF0000));
            default -> class_2561.method_43470((String)"Mode: Normal").method_27694(style -> style.method_36139(0xAAAAAA));
        };
        tooltipComponents.add((class_2561)modeComponent);
        tooltipComponents.add((class_2561)class_2561.method_43470((String)"Shift + Right-click to configure").method_27694(style -> style.method_10978(Boolean.valueOf(true))));
        super.method_7851(itemStack, level, tooltipComponents, isAdvanced);
    }

    public boolean method_7878(class_1799 toRepair, class_1799 repair) {
        return false;
    }

    public boolean method_7870(class_1799 itemStack) {
        return false;
    }

    public void syncEnergyWithBattery(class_1799 itemStack) {
        ScrapMultitoolData data = ScrapMultitoolData.fromItemStack(itemStack);
        if (data.hasBattery()) {
            class_1799 battery = data.battery();
            class_1792 class_17922 = battery.method_7909();
            if (class_17922 instanceof EnergyCellItem) {
                EnergyCellItem batteryItem = (EnergyCellItem)class_17922;
                int batteryEnergy = batteryItem.getEnergy(battery);
                if (batteryEnergy <= 1) {
                    class_1799 emptyBattery = batteryItem.createEmptyBattery();
                    ScrapMultitoolData updatedData = data.withBattery(emptyBattery);
                    updatedData.saveToItemStack(itemStack);
                    EnergyManager.setEnergy(itemStack, MultitoolConfig.energyMax, 0);
                    return;
                }
                float energyRatio = (float)batteryEnergy / 5000.0f;
                int multitoolEnergy = Math.round((float)MultitoolConfig.energyMax * energyRatio);
                EnergyManager.setEnergy(itemStack, MultitoolConfig.energyMax, multitoolEnergy);
            } else {
                EnergyManager.setEnergy(itemStack, MultitoolConfig.energyMax, 0);
            }
        } else {
            EnergyManager.setEnergy(itemStack, MultitoolConfig.energyMax, 0);
        }
    }

    private boolean consumeEnergyFromBattery(class_1799 itemStack, ScrapMultitoolData data, int amount) {
        if (!data.hasBattery()) {
            return false;
        }
        class_1799 battery = data.battery();
        if (!(battery.method_7909() instanceof EnergyCellItem)) {
            return false;
        }
        int batteryEnergy = ((EnergyCellItem)battery.method_7909()).getEnergy(battery);
        if (batteryEnergy < amount) {
            return false;
        }
        EnergyManager.consumeWithBatteryBackup(itemStack, MultitoolConfig.energyMax, amount, battery);
        ScrapMultitoolData updatedData = data.withBattery(battery);
        updatedData.saveToItemStack(itemStack);
        this.syncEnergyWithBattery(itemStack);
        return true;
    }

    private boolean hasEnergyFromBattery(class_1799 itemStack, int amount) {
        ScrapMultitoolData data = ScrapMultitoolData.fromItemStack(itemStack);
        if (!data.hasBattery()) {
            return false;
        }
        class_1799 battery = data.battery();
        class_1792 class_17922 = battery.method_7909();
        if (!(class_17922 instanceof EnergyCellItem)) {
            return false;
        }
        EnergyCellItem batteryItem = (EnergyCellItem)class_17922;
        return batteryItem.getEnergy(battery) >= amount;
    }
}

