/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.block.entity.collectorstation;

import de.markusbordihn.scraptechworkshop.block.collectorstation.CollectorStationBlock;
import de.markusbordihn.scraptechworkshop.block.entity.AbstractWorkshopBlockEntity;
import de.markusbordihn.scraptechworkshop.block.entity.collectorstation.CollectorStationContainer;
import de.markusbordihn.scraptechworkshop.config.CollectorStationConfig;
import de.markusbordihn.scraptechworkshop.data.collectorstation.CollectorStationStatus;
import de.markusbordihn.scraptechworkshop.item.component.EnergyCellItem;
import de.markusbordihn.scraptechworkshop.item.upgrade.ChargeUpgradeItem;
import de.markusbordihn.scraptechworkshop.item.upgrade.SpeedUpgradeItem;
import de.markusbordihn.scraptechworkshop.loot.ScrapLootGenerator;
import de.markusbordihn.scraptechworkshop.menu.CollectorStationMenu;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3913;
import net.minecraft.class_5321;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CollectorStationBlockEntity
extends AbstractWorkshopBlockEntity {
    public static final int BATTERY_SLOT = 0;
    public static final int FIRST_STORAGE_SLOT = 1;
    public static final int LAST_STORAGE_SLOT = 24;
    public static final int STORAGE_SLOTS = 24;
    public static final int FIRST_UPGRADE_SLOT = 25;
    public static final int LAST_UPGRADE_SLOT = 28;
    public static final int UPGRADE_SLOTS = 4;
    public static final int TOTAL_SLOTS = 29;
    private static final Logger log = LogManager.getLogger();
    private static final int ENERGY_CONSUMPTION_INTERVAL = 20;
    private static final int ITEM_ADDITION_INTERVAL = 10;
    private static final int ENERGY_CONSUMPTION_AMOUNT = 5;
    private static final float SOUND_VOLUME = 0.5f;
    private static final float SOUND_PITCH = 1.0f;
    private static final String TRANSLATION_KEY = "container.scrap_tech_workshop.collector_station";
    private static final String STATE_TIMER_TAG = "StateTimer";
    private static final String ENERGY_TAG = "Energy";
    private static final String BIOME_TAG = "Biome";
    private static final int DATA_STATUS = 0;
    private static final int DATA_STATE_TIMER = 1;
    private static final int DATA_ENERGY = 2;
    private static final int DATA_POWERED = 3;
    private static final int DATA_COUNT = 4;
    public static class_2591<CollectorStationBlockEntity> TYPE;
    private final CollectorStationContainer container;
    private int stateTimer = 0;
    private int currentEnergy = 0;
    private final class_3913 containerData = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> CollectorStationBlockEntity.this.getStatus().ordinal();
                case 1 -> CollectorStationBlockEntity.this.stateTimer;
                case 2 -> CollectorStationBlockEntity.this.currentEnergy;
                case 3 -> {
                    if (CollectorStationBlockEntity.this.getStatus().isPowered()) {
                        yield 1;
                    }
                    yield 0;
                }
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    CollectorStationBlockEntity.this.setStatus(CollectorStationStatus.values()[value]);
                    break;
                }
                case 1: {
                    CollectorStationBlockEntity.this.stateTimer = value;
                    break;
                }
                case 2: {
                    CollectorStationBlockEntity.this.currentEnergy = value;
                    break;
                }
            }
        }

        public int method_17389() {
            return 4;
        }
    };
    private String cachedBiome = "";
    private List<class_1799> pendingItems = new ArrayList<class_1799>();
    private int processingIndex = 0;

    public CollectorStationBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(TYPE, blockPos, blockState);
        this.container = new CollectorStationContainer(this);
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 blockState, CollectorStationBlockEntity blockEntity) {
        if (level.field_9236) {
            blockEntity.clientTick(level, blockPos, blockState);
        } else {
            blockEntity.serverTick(level, blockPos, blockState);
        }
    }

    @Override
    protected class_2371<class_1799> getItems() {
        return this.container.getItems();
    }

    protected int getTotalSlots() {
        return 29;
    }

    @Override
    protected class_1278 getContainerDelegate() {
        return this.container;
    }

    private void clientTick(class_1937 level, class_2338 blockPos, class_2680 blockState) {
    }

    private void serverTick(class_1937 level, class_2338 blockPos, class_2680 blockState) {
        CollectorStationStatus currentStatus = this.getStatus();
        if (currentStatus == CollectorStationStatus.NO_POWER || currentStatus == CollectorStationStatus.CHARGING) {
            class_1792 class_17922;
            class_1799 battery = this.getBattery();
            if (battery.method_7960() || !((class_17922 = battery.method_7909()) instanceof EnergyCellItem)) {
                if (currentStatus != CollectorStationStatus.NO_POWER) {
                    this.setStatus(CollectorStationStatus.NO_POWER);
                    this.stateTimer = 0;
                }
                return;
            }
            EnergyCellItem batteryItem = (EnergyCellItem)class_17922;
            this.currentEnergy = batteryItem.getEnergy(battery);
            if (this.currentEnergy < CollectorStationConfig.energyPerCycle) {
                if (currentStatus != CollectorStationStatus.NO_POWER) {
                    this.setStatus(CollectorStationStatus.NO_POWER);
                    this.stateTimer = 0;
                }
                return;
            }
        }
        if (level.method_8510() % (long)CollectorStationConfig.checkInterval != 0L) {
            return;
        }
        switch (this.getStatus()) {
            case NO_POWER: {
                this.setStatus(CollectorStationStatus.CHARGING);
                this.stateTimer = 0;
                log.debug("[CollectorStation@{}] Status changed: NO_POWER -> CHARGING", (Object)blockPos);
                this.playSound(level, blockPos, class_3417.field_14891, 0.3f, 1.2f);
                break;
            }
            case CHARGING: {
                class_1792 class_17923;
                class_1799 battery;
                int chargeMultiplier = this.getChargeMultiplierBonus();
                this.stateTimer += CollectorStationConfig.checkInterval * chargeMultiplier;
                if (this.stateTimer == CollectorStationConfig.checkInterval * chargeMultiplier) {
                    this.playSound(level, blockPos, class_3417.field_15045, 0.5f, 1.5f);
                }
                if (this.stateTimer % 20 == 0 && this.currentEnergy > 0 && !(battery = this.getBattery()).method_7960() && (class_17923 = battery.method_7909()) instanceof EnergyCellItem) {
                    EnergyCellItem batteryItem = (EnergyCellItem)class_17923;
                    int energyToConsume = Math.min(5, this.currentEnergy);
                    batteryItem.consumeEnergy(battery, energyToConsume);
                    this.currentEnergy = batteryItem.getEnergy(battery);
                    if (this.currentEnergy <= 1) {
                        this.setBattery(batteryItem.createEmptyBattery());
                        log.debug("[CollectorStation@{}] Battery drained, replaced with empty battery", (Object)blockPos);
                    }
                }
                if (this.stateTimer < CollectorStationConfig.chargingTime) break;
                if (this.hasSpaceInStorage()) {
                    this.setStatus(CollectorStationStatus.COLLECTING);
                    this.stateTimer = 0;
                    this.cachedBiome = ((class_5321)level.method_23753(blockPos).method_40230().get()).method_29177().toString();
                    log.debug("[CollectorStation@{}] Status changed: CHARGING -> COLLECTING (Biome: {})", (Object)blockPos, (Object)this.cachedBiome);
                    this.playSound(level, blockPos, class_3417.field_15134, 0.5f, 0.8f);
                    break;
                }
                this.setStatus(CollectorStationStatus.NO_STORAGE);
                this.stateTimer = 0;
                log.debug("[CollectorStation@{}] Status changed: CHARGING -> NO_STORAGE (storage full)", (Object)blockPos);
                this.playSound(level, blockPos, class_3417.field_14819, 0.5f, 0.7f);
                break;
            }
            case NO_STORAGE: {
                if (!this.hasSpaceInStorage()) break;
                this.setStatus(CollectorStationStatus.COLLECTING);
                this.stateTimer = 0;
                this.cachedBiome = ((class_5321)level.method_23753(blockPos).method_40230().get()).method_29177().toString();
                log.debug("[CollectorStation@{}] Status changed: NO_STORAGE -> COLLECTING (Biome: {})", (Object)blockPos, (Object)this.cachedBiome);
                this.playSound(level, blockPos, class_3417.field_15134, 0.5f, 0.8f);
                break;
            }
            case COLLECTING: {
                int speedMultiplier = this.getSpeedMultiplierBonus();
                this.stateTimer += CollectorStationConfig.checkInterval * speedMultiplier;
                if (this.stateTimer < CollectorStationConfig.collectingTime) break;
                this.setStatus(CollectorStationStatus.RETURNING);
                this.stateTimer = 0;
                log.debug("[CollectorStation@{}] Status changed: COLLECTING -> RETURNING (collected for {} ticks)", (Object)blockPos, (Object)CollectorStationConfig.collectingTime);
                this.playSound(level, blockPos, class_3417.field_15228, 0.5f, 0.9f);
                break;
            }
            case RETURNING: {
                this.stateTimer += CollectorStationConfig.checkInterval;
                if (this.stateTimer < CollectorStationConfig.returningTime) break;
                this.setStatus(CollectorStationStatus.PROCESSING);
                this.stateTimer = 0;
                this.processingIndex = 0;
                log.debug("[CollectorStation@{}] Status changed: RETURNING -> PROCESSING", (Object)blockPos);
                this.playSound(level, blockPos, class_3417.field_14833, 0.3f, 1.5f);
                this.pendingItems = ScrapLootGenerator.generateScrapForBiome(level, blockPos, this.cachedBiome);
                log.debug("[CollectorStation@{}] Generated {} scrap items to process", (Object)blockPos, (Object)this.pendingItems.size());
                break;
            }
            case PROCESSING: {
                this.stateTimer += CollectorStationConfig.checkInterval;
                if (this.stateTimer % 10 == 0 && this.processingIndex < this.pendingItems.size()) {
                    class_1799 scrap = this.pendingItems.get(this.processingIndex);
                    if (!scrap.method_7960()) {
                        this.addSingleScrapItem(scrap, blockPos);
                        this.playSound(level, blockPos, class_3417.field_15197, 0.3f, 1.2f);
                    }
                    ++this.processingIndex;
                }
                if (this.stateTimer < CollectorStationConfig.processingTime || this.processingIndex < this.pendingItems.size()) break;
                this.setStatus(CollectorStationStatus.CHARGING);
                this.stateTimer = 0;
                this.pendingItems.clear();
                this.processingIndex = 0;
                log.debug("[CollectorStation@{}] Status changed: PROCESSING -> CHARGING (cycle complete)", (Object)blockPos);
                this.playSound(level, blockPos, class_3417.field_19344, 0.4f, 1.0f);
            }
        }
        this.method_5431();
    }

    private boolean hasSpaceInStorage() {
        for (int i = 1; i <= 24; ++i) {
            class_1799 stack = this.container.method_5438(i);
            if (!stack.method_7960() && stack.method_7947() >= stack.method_7914()) continue;
            return true;
        }
        return false;
    }

    private int getSpeedMultiplierBonus() {
        int totalMultiplier = 1;
        for (int i = 25; i <= 28; ++i) {
            class_1792 class_17922;
            class_1799 stack = this.container.method_5438(i);
            if (stack.method_7960() || !((class_17922 = stack.method_7909()) instanceof SpeedUpgradeItem)) continue;
            SpeedUpgradeItem speedUpgrade = (SpeedUpgradeItem)class_17922;
            totalMultiplier += speedUpgrade.getSpeedMultiplier() - 1;
        }
        return totalMultiplier;
    }

    private int getChargeMultiplierBonus() {
        int totalMultiplier = 1;
        for (int i = 25; i <= 28; ++i) {
            class_1792 class_17922;
            class_1799 stack = this.container.method_5438(i);
            if (stack.method_7960() || !((class_17922 = stack.method_7909()) instanceof ChargeUpgradeItem)) continue;
            ChargeUpgradeItem chargeUpgrade = (ChargeUpgradeItem)class_17922;
            totalMultiplier += chargeUpgrade.getChargeMultiplier() - 1;
        }
        return totalMultiplier;
    }

    private void addSingleScrapItem(class_1799 scrap, class_2338 blockPos) {
        if (scrap.method_7960()) {
            return;
        }
        for (int i = 1; i <= 24; ++i) {
            class_1799 slotStack = this.container.method_5438(i);
            if (slotStack.method_7960()) {
                this.container.method_5447(i, scrap.method_7972());
                log.debug("[CollectorStation@{}] Added {} x{} to slot {}", (Object)blockPos, (Object)scrap.method_7909(), (Object)scrap.method_7947(), (Object)i);
                return;
            }
            if (!class_1799.method_31577((class_1799)slotStack, (class_1799)scrap) || slotStack.method_7947() + scrap.method_7947() > slotStack.method_7914()) continue;
            slotStack.method_7933(scrap.method_7947());
            log.debug("[CollectorStation@{}] Stacked {} x{} into slot {} (total: {})", (Object)blockPos, (Object)scrap.method_7909(), (Object)scrap.method_7947(), (Object)i, (Object)slotStack.method_7947());
            return;
        }
        log.warn("[CollectorStation@{}] No space for {} x{}", (Object)blockPos, (Object)scrap.method_7909(), (Object)scrap.method_7947());
    }

    private void playSound(class_1937 level, class_2338 blockPos, class_3414 sound, float volume, float pitch) {
        if (level != null && !level.field_9236) {
            level.method_8396(null, blockPos, sound, class_3419.field_15245, volume, pitch);
        }
    }

    public class_1799 getBattery() {
        return this.container.method_5438(0);
    }

    public void setBattery(class_1799 battery) {
        this.container.method_5447(0, battery);
    }

    public CollectorStationContainer getContainer() {
        return this.container;
    }

    public class_3913 getContainerData() {
        return this.containerData;
    }

    public CollectorStationStatus getStatus() {
        class_1937 currentLevel = this.method_10997();
        if (currentLevel != null && this.method_11010().method_28498(CollectorStationBlock.STATE)) {
            return (CollectorStationStatus)((Object)this.method_11010().method_11654(CollectorStationBlock.STATE));
        }
        return CollectorStationStatus.NO_POWER;
    }

    private void setStatus(CollectorStationStatus newStatus) {
        class_2680 currentState;
        class_1937 currentLevel = this.method_10997();
        if (currentLevel != null && this.method_11010().method_28498(CollectorStationBlock.STATE) && (currentState = this.method_11010()).method_11654(CollectorStationBlock.STATE) != newStatus) {
            currentLevel.method_8652(this.field_11867, (class_2680)currentState.method_11657(CollectorStationBlock.STATE, (Comparable)((Object)newStatus)), 3);
        }
    }

    public int getStateTimer() {
        return this.stateTimer;
    }

    @Override
    public void method_11014(class_2487 compoundTag) {
        super.method_11014(compoundTag);
        this.stateTimer = compoundTag.method_10550(STATE_TIMER_TAG);
        this.currentEnergy = compoundTag.method_10550(ENERGY_TAG);
        this.cachedBiome = compoundTag.method_10558(BIOME_TAG);
    }

    @Override
    protected void method_11007(class_2487 compoundTag) {
        super.method_11007(compoundTag);
        compoundTag.method_10569(STATE_TIMER_TAG, this.stateTimer);
        compoundTag.method_10569(ENERGY_TAG, this.currentEnergy);
        compoundTag.method_10582(BIOME_TAG, this.cachedBiome);
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)TRANSLATION_KEY);
    }

    public class_1703 createMenu(int windowId, class_1661 playerInventory, class_1657 player) {
        return new CollectorStationMenu(windowId, playerInventory, this, this.containerData);
    }
}

