/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.drop;

import de.markusbordihn.scraptechworkshop.config.ScrapDropConfig;
import de.markusbordihn.scraptechworkshop.data.scrap.ScrapDropData;
import de.markusbordihn.scraptechworkshop.data.scrap.ScrapSoundType;
import de.markusbordihn.scraptechworkshop.data.scrap.ScrapType;
import de.markusbordihn.scraptechworkshop.item.ModItems;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;

public class ScrapDropHandler {
    private static final Random RANDOM = new Random();
    private static final Map<class_2248, ScrapType> BLOCK_SCRAP_TYPES = ScrapDropHandler.createBlockScrapTypeMap();

    private static Map<class_2248, ScrapType> createBlockScrapTypeMap() {
        HashMap<class_2248, ScrapType> typeMap = new HashMap<class_2248, ScrapType>();
        typeMap.put(class_2246.field_10115, ScrapType.METAL);
        typeMap.put(class_2246.field_28888, ScrapType.METAL);
        typeMap.put(class_2246.field_10508, ScrapType.METAL);
        typeMap.put(class_2246.field_10474, ScrapType.METAL);
        typeMap.put(class_2246.field_10340, ScrapType.METAL);
        typeMap.put(class_2246.field_10535, ScrapType.GOLD);
        typeMap.put(class_2246.field_10105, ScrapType.GOLD);
        typeMap.put(class_2246.field_10414, ScrapType.GOLD);
        typeMap.put(class_2246.field_29026, ScrapType.GOLD);
        typeMap.put(class_2246.field_10205, ScrapType.GOLD);
        typeMap.put(class_2246.field_10571, ScrapType.GOLD);
        typeMap.put(class_2246.field_29027, ScrapType.IRON);
        typeMap.put(class_2246.field_10085, ScrapType.IRON);
        typeMap.put(class_2246.field_10212, ScrapType.IRON);
        typeMap.put(class_2246.field_33508, ScrapType.IRON);
        typeMap.put(class_2246.field_27119, ScrapType.COPPER);
        typeMap.put(class_2246.field_27120, ScrapType.COPPER);
        typeMap.put(class_2246.field_29221, ScrapType.COPPER);
        typeMap.put(class_2246.field_27118, ScrapType.COPPER);
        typeMap.put(class_2246.field_27116, ScrapType.COPPER);
        typeMap.put(class_2246.field_33509, ScrapType.COPPER);
        typeMap.put(class_2246.field_27117, ScrapType.COPPER);
        typeMap.put(class_2246.field_22108, ScrapType.ALLOY);
        typeMap.put(class_2246.field_10471, ScrapType.ALLOY);
        typeMap.put(class_2246.field_10286, ScrapType.ALLOY);
        typeMap.put(class_2246.field_10505, ScrapType.ALLOY);
        typeMap.put(class_2246.field_10462, ScrapType.ALLOY);
        typeMap.put(class_2246.field_10092, ScrapType.INSULATION);
        typeMap.put(class_2246.field_10258, ScrapType.INSULATION);
        typeMap.put(class_2246.field_10562, ScrapType.INSULATION);
        typeMap.put(class_2246.field_10107, ScrapType.INSULATION);
        typeMap.put(class_2246.field_10210, ScrapType.INSULATION);
        typeMap.put(class_2246.field_10585, ScrapType.INSULATION);
        typeMap.put(class_2246.field_10242, ScrapType.INSULATION);
        typeMap.put(class_2246.field_10542, ScrapType.INSULATION);
        typeMap.put(class_2246.field_10421, ScrapType.INSULATION);
        typeMap.put(class_2246.field_10434, ScrapType.INSULATION);
        typeMap.put(class_2246.field_10038, ScrapType.INSULATION);
        typeMap.put(class_2246.field_10172, ScrapType.INSULATION);
        typeMap.put(class_2246.field_10308, ScrapType.INSULATION);
        typeMap.put(class_2246.field_10206, ScrapType.INSULATION);
        typeMap.put(class_2246.field_10011, ScrapType.INSULATION);
        typeMap.put(class_2246.field_10439, ScrapType.INSULATION);
        typeMap.put(class_2246.field_10367, ScrapType.INSULATION);
        typeMap.put(class_2246.field_10058, ScrapType.INSULATION);
        typeMap.put(class_2246.field_10458, ScrapType.INSULATION);
        typeMap.put(class_2246.field_10611, ScrapType.INSULATION);
        typeMap.put(class_2246.field_10184, ScrapType.INSULATION);
        typeMap.put(class_2246.field_10015, ScrapType.INSULATION);
        typeMap.put(class_2246.field_10325, ScrapType.INSULATION);
        typeMap.put(class_2246.field_10143, ScrapType.INSULATION);
        typeMap.put(class_2246.field_10014, ScrapType.INSULATION);
        typeMap.put(class_2246.field_10444, ScrapType.INSULATION);
        typeMap.put(class_2246.field_10349, ScrapType.INSULATION);
        typeMap.put(class_2246.field_10590, ScrapType.INSULATION);
        typeMap.put(class_2246.field_10235, ScrapType.INSULATION);
        typeMap.put(class_2246.field_10570, ScrapType.INSULATION);
        typeMap.put(class_2246.field_10409, ScrapType.INSULATION);
        typeMap.put(class_2246.field_10123, ScrapType.INSULATION);
        typeMap.put(class_2246.field_10526, ScrapType.INSULATION);
        typeMap.put(class_2246.field_10328, ScrapType.INSULATION);
        typeMap.put(class_2246.field_10626, ScrapType.INSULATION);
        typeMap.put(class_2246.field_10415, ScrapType.INSULATION);
        return typeMap;
    }

    public static void handleBlockBreak(class_3218 serverLevel, class_2338 blockPos, class_2248 brokenBlock) {
        ScrapType scrapType = BLOCK_SCRAP_TYPES.get(brokenBlock);
        if (scrapType == null) {
            return;
        }
        ScrapDropData dropData = ScrapDropHandler.getScrapDropDataForType(scrapType);
        if (dropData == null || !dropData.isEnabled()) {
            return;
        }
        float dropChance = dropData.dropChance() / 100.0f;
        if (RANDOM.nextFloat() < dropChance) {
            class_1799 scrapStack = new class_1799((class_1935)dropData.scrapItem(), 1);
            class_1542 itemEntity = new class_1542((class_1937)serverLevel, (double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264() + 0.5, (double)blockPos.method_10260() + 0.5, scrapStack);
            serverLevel.method_8649((class_1297)itemEntity);
            ScrapDropHandler.playDropSound(serverLevel, blockPos, scrapType);
        }
    }

    private static void playDropSound(class_3218 level, class_2338 pos, ScrapType scrapType) {
        if (!ScrapDropConfig.enableDropSounds || ScrapDropConfig.dropSoundVolume <= 0.0f) {
            return;
        }
        class_3414 soundEvent = ScrapSoundType.forScrapType(scrapType).getSoundEvent();
        level.method_8396(null, pos, soundEvent, class_3419.field_15245, Math.min(1.0f, ScrapDropConfig.dropSoundVolume), 0.8f + RANDOM.nextFloat() * 0.4f);
    }

    private static ScrapDropData getScrapDropDataForType(ScrapType scrapType) {
        return switch (scrapType) {
            default -> throw new IncompatibleClassChangeError();
            case ScrapType.BIO -> new ScrapDropData(ModItems.BIO_SCRAP.get(), ScrapDropConfig.bioScrapDropChance);
            case ScrapType.CERAMIC -> new ScrapDropData(ModItems.CERAMIC_SCRAP.get(), ScrapDropConfig.ceramicScrapDropChance);
            case ScrapType.COPPER -> new ScrapDropData(ModItems.COPPER_SCRAP.get(), ScrapDropConfig.copperScrapDropChance);
            case ScrapType.CRYSTAL -> new ScrapDropData(ModItems.CRYSTAL_SCRAP.get(), ScrapDropConfig.crystalScrapDropChance);
            case ScrapType.FASTENER -> new ScrapDropData(ModItems.FASTENER_SCRAP.get(), ScrapDropConfig.fastenerScrapDropChance);
            case ScrapType.FIBER -> new ScrapDropData(ModItems.FIBER_SCRAP.get(), ScrapDropConfig.fiberScrapDropChance);
            case ScrapType.GLASS -> new ScrapDropData(ModItems.GLASS_SCRAP.get(), ScrapDropConfig.glassScrapDropChance);
            case ScrapType.GOLD -> new ScrapDropData(ModItems.GOLD_SCRAP.get(), ScrapDropConfig.goldScrapDropChance);
            case ScrapType.IRON -> new ScrapDropData(ModItems.IRON_SCRAP.get(), ScrapDropConfig.ironScrapDropChance);
            case ScrapType.LUMINOUS -> new ScrapDropData(ModItems.LUMINOUS_SCRAP.get(), ScrapDropConfig.luminousScrapDropChance);
            case ScrapType.METAL -> new ScrapDropData(ModItems.METAL_SCRAP.get(), ScrapDropConfig.metalScrapDropChance);
            case ScrapType.MINERAL -> new ScrapDropData(ModItems.MINERAL_SCRAP.get(), ScrapDropConfig.mineralScrapDropChance);
            case ScrapType.PLASTIC -> new ScrapDropData(ModItems.PLASTIC_SCRAP.get(), ScrapDropConfig.plasticScrapDropChance);
            case ScrapType.RUBBER -> new ScrapDropData(ModItems.RUBBER_SCRAP.get(), ScrapDropConfig.rubberScrapDropChance);
            case ScrapType.TECH -> new ScrapDropData(ModItems.TECH_SCRAP.get(), ScrapDropConfig.techScrapDropChance);
            case ScrapType.WOOD -> new ScrapDropData(ModItems.WOOD_SCRAP.get(), ScrapDropConfig.woodScrapDropChance);
            case ScrapType.CIRCUIT -> new ScrapDropData(ModItems.CIRCUIT_SCRAP.get(), ScrapDropConfig.techScrapDropChance);
            case ScrapType.COIL -> new ScrapDropData(ModItems.COIL_SCRAP.get(), ScrapDropConfig.techScrapDropChance);
            case ScrapType.CAPACITOR -> new ScrapDropData(ModItems.CAPACITOR_SCRAP.get(), ScrapDropConfig.techScrapDropChance);
            case ScrapType.ENERGY_CELL -> new ScrapDropData(ModItems.ENERGY_CELL_SCRAP.get(), ScrapDropConfig.techScrapDropChance);
            case ScrapType.ALLOY -> new ScrapDropData(ModItems.ALLOY_SCRAP.get(), ScrapDropConfig.metalScrapDropChance);
            case ScrapType.INSULATION -> new ScrapDropData(ModItems.INSULATION_SCRAP.get(), ScrapDropConfig.plasticScrapDropChance);
        };
    }
}

