/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.block.entity.recycler;

import de.markusbordihn.scraptechworkshop.item.component.EnergyCellItem;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class RecyclerContainer
implements WorldlyContainer {
    private final NonNullList<ItemStack> items;
    private final Runnable onChanged;

    public RecyclerContainer(int totalSlots, Runnable onChanged) {
        this.items = NonNullList.m_122780_((int)totalSlots, (Object)ItemStack.f_41583_);
        this.onChanged = onChanged;
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        for (ItemStack item : this.items) {
            if (item.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int slot) {
        return slot >= 0 && slot < this.items.size() ? (ItemStack)this.items.get(slot) : ItemStack.f_41583_;
    }

    public ItemStack m_7407_(int slot, int amount) {
        ItemStack result = ContainerHelper.m_18969_(this.items, (int)slot, (int)amount);
        if (!result.m_41619_()) {
            this.onChanged.run();
        }
        return result;
    }

    public ItemStack m_8016_(int slot) {
        return ContainerHelper.m_18966_(this.items, (int)slot);
    }

    public void m_6836_(int slot, ItemStack itemStack) {
        if (slot >= 0 && slot < this.items.size()) {
            this.items.set(slot, (Object)itemStack);
            if (!itemStack.m_41619_() && itemStack.m_41613_() > this.m_6893_()) {
                itemStack.m_41764_(this.m_6893_());
            }
            this.onChanged.run();
        }
    }

    public boolean m_6542_(Player player) {
        return true;
    }

    public boolean m_7013_(int slot, ItemStack itemStack) {
        if (slot == 12) {
            return itemStack.m_41720_() instanceof EnergyCellItem;
        }
        return slot == 0;
    }

    public void m_6211_() {
        this.items.clear();
        this.onChanged.run();
    }

    public void m_6596_() {
        this.onChanged.run();
    }

    public int[] m_7071_(Direction direction) {
        if (direction == Direction.UP) {
            return new int[]{0};
        }
        if (direction == Direction.DOWN) {
            return new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
        }
        return new int[0];
    }

    public boolean m_7155_(int slot, ItemStack itemStack, Direction direction) {
        return slot == 0 && direction == Direction.UP;
    }

    public boolean m_7157_(int slot, ItemStack itemStack, Direction direction) {
        return slot >= 1 && slot <= 9;
    }
}

