/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.client.renderer.blockentity.collectorstation;

import de.markusbordihn.scraptechworkshop.block.entity.collectorstation.CollectorStationBlockEntity;
import de.markusbordihn.scraptechworkshop.client.renderer.blockentity.collectorstation.RobotStatusHandler;
import de.markusbordihn.scraptechworkshop.config.CollectorStationConfig;
import de.markusbordihn.scraptechworkshop.data.robot.RobotRenderInfo;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;

public class ChargingStatusHandler
implements RobotStatusHandler {
    private static final float ROBOT_CHARGING_Y = 0.35f;
    private static final float ROBOT_HOVER_AMPLITUDE = 0.03f;
    private static final float ROBOT_HOVER_SPEED = 0.15f;
    private static final float CHARGING_THRESHOLD = 0.95f;

    @Override
    public RobotRenderInfo calculateRenderInfo(CollectorStationBlockEntity blockEntity, Level level, BlockPos blockPos, Direction facing, float stationCenterX, float stationCenterZ, float animationTime, float partialTick) {
        int chargingTime;
        float yaw = -facing.m_122435_();
        int stateTimer = blockEntity.getStateTimer();
        float chargeProgress = Math.min(1.0f, (float)stateTimer / (float)(chargingTime = CollectorStationConfig.chargingTime));
        if (chargeProgress >= 0.95f) {
            float descentProgress = (chargeProgress - 0.95f) / 0.050000012f;
            descentProgress = this.smoothStep(descentProgress);
            float targetY = 0.0f;
            float currentY = Mth.m_14179_((float)descentProgress, (float)0.35f, (float)targetY);
            return new RobotRenderInfo(stationCenterX, currentY, stationCenterZ, yaw);
        }
        float hoverOffset = Mth.m_14031_((float)(animationTime * 0.15f)) * 0.03f;
        return new RobotRenderInfo(stationCenterX, 0.35f + hoverOffset, stationCenterZ, yaw);
    }

    private float smoothStep(float t) {
        return t * t * (3.0f - 2.0f * t);
    }

    @Override
    public void spawnParticles(Level level, BlockPos blockPos, RobotRenderInfo renderInfo, float partialTick) {
        if (level.m_213780_().m_188501_() < 0.3f) {
            double x = (double)blockPos.m_123341_() + 0.5 + (level.m_213780_().m_188500_() - 0.5) * 0.3;
            double y = (double)((float)blockPos.m_123342_() + 0.35f) + 0.2;
            double z = (double)blockPos.m_123343_() + 0.5 + (level.m_213780_().m_188500_() - 0.5) * 0.3;
            level.m_7106_((ParticleOptions)ParticleTypes.f_175830_, x, y, z, 0.0, 0.02, 0.0);
        }
    }
}

