/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.client.renderer.hololog;

import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.scraptechworkshop.client.renderer.hololog.HoloLogPlaybackBase;
import de.markusbordihn.scraptechworkshop.client.renderer.hololog.HoloLogPlayerEffects;
import de.markusbordihn.scraptechworkshop.data.hololog.HoloLogData;
import de.markusbordihn.scraptechworkshop.data.hololog.HoloLogDisplayEntity;
import de.markusbordihn.scraptechworkshop.data.hololog.HoloLogLine;
import de.markusbordihn.scraptechworkshop.data.hololog.HoloLogPlaybackContext;
import de.markusbordihn.scraptechworkshop.entity.hololog.HoloLogHumanoidEntity;
import de.markusbordihn.scraptechworkshop.registry.entity.HoloLogEntityRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HoloLogScreenPlayer
extends HoloLogPlaybackBase {
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");
    private static final int CHECKS_PER_SECOND = 10;
    private static final float CHECK_INTERVAL = 0.1f;
    private final List<String> displayedLines = new ArrayList<String>();
    private final float ticksPerCheck;
    private int currentCharIndex = 0;
    private float elapsedTimeSinceLastChar = 0.0f;
    private float elapsedTime = 0.0f;
    private float endDelayTimer = 0.0f;
    private boolean waitingForEndDelay = false;
    private int ticksSinceLastCheck = 0;

    public HoloLogScreenPlayer(HoloLogData holoLogData, HoloLogPlaybackContext context, UUID playerId, Runnable onComplete) {
        super(holoLogData, context, playerId, onComplete);
        this.ticksPerCheck = 2.0f;
    }

    @Override
    protected void onPlaybackStart() {
        this.displayedLines.clear();
        this.currentCharIndex = 0;
        this.elapsedTimeSinceLastChar = 0.0f;
        this.elapsedTime = 0.0f;
        this.endDelayTimer = 0.0f;
        this.waitingForEndDelay = false;
        this.ticksSinceLastCheck = 0;
        log.info("[HolologScreenPlayer] Playback started: {} lines", (Object)this.holoLogData.lines().size());
    }

    @Override
    protected void onPlaybackStop() {
        this.displayedLines.clear();
    }

    @Override
    protected int getDisplayLineIndex() {
        HoloLogLine line;
        int lineIndex = -1;
        int i = 0;
        while (i <= this.currentLineIndex && i < this.holoLogData.lines().size() && this.elapsedTime >= (line = this.holoLogData.lines().get(i)).startTime()) {
            lineIndex = i++;
        }
        return lineIndex;
    }

    @Override
    public void tick() {
        if (this.state != HoloLogPlaybackBase.PlaybackState.PLAYING) {
            return;
        }
        ++this.ticksSinceLastCheck;
        if ((float)this.ticksSinceLastCheck >= this.ticksPerCheck) {
            float charDelay;
            int charsToAdd;
            this.elapsedTime += 0.1f;
            this.elapsedTimeSinceLastChar += 0.1f;
            this.ticksSinceLastCheck = 0;
            this.startVoiceOver(this.elapsedTime);
            if (this.currentLineIndex < this.holoLogData.lines().size() && (charsToAdd = (int)(this.elapsedTimeSinceLastChar / (charDelay = this.holoLogData.charDelay()))) > 0) {
                this.elapsedTimeSinceLastChar -= (float)charsToAdd * charDelay;
                while (charsToAdd > 0 && this.currentLineIndex < this.holoLogData.lines().size()) {
                    String lineText;
                    HoloLogLine currentLine = this.holoLogData.lines().get(this.currentLineIndex);
                    String string = lineText = currentLine.text() != null ? currentLine.text() : "";
                    if (this.elapsedTime < currentLine.startTime()) break;
                    if (this.currentCharIndex < lineText.length()) {
                        this.currentCharIndex += charsToAdd;
                        if (this.currentCharIndex > lineText.length()) {
                            charsToAdd = this.currentCharIndex - lineText.length();
                            this.currentCharIndex = lineText.length();
                            continue;
                        }
                        charsToAdd = 0;
                        continue;
                    }
                    HoloLogPlayerEffects.playEffects(currentLine.effects(), this.context, this.context.getEffectPosition());
                    ++this.currentLineIndex;
                    this.currentCharIndex = 0;
                    this.elapsedTimeSinceLastChar = 0.0f;
                    if (lineText.isEmpty()) continue;
                    this.displayedLines.add(lineText);
                }
            }
            if (this.currentLineIndex >= this.holoLogData.lines().size() && !this.waitingForEndDelay) {
                this.waitingForEndDelay = true;
                this.endDelayTimer = 0.0f;
                log.debug("All lines finished, waiting {}s before end effects", (Object)Float.valueOf(this.holoLogData.endDelay()));
            }
            if (this.waitingForEndDelay) {
                this.endDelayTimer += 0.1f;
                if (this.endDelayTimer >= this.holoLogData.endDelay()) {
                    this.completePlayback();
                }
            }
        }
    }

    public List<String> getDisplayedLines() {
        return this.displayedLines;
    }

    public String getCurrentPartialLine() {
        String lineText;
        if (this.currentLineIndex >= this.holoLogData.lines().size()) {
            return "";
        }
        HoloLogLine currentLine = this.holoLogData.lines().get(this.currentLineIndex);
        String string = lineText = currentLine.text() != null ? currentLine.text() : "";
        if (this.currentCharIndex > 0 && this.currentCharIndex <= lineText.length()) {
            return lineText.substring(0, this.currentCharIndex);
        }
        return "";
    }

    public String getTitle() {
        return this.holoLogData.title();
    }

    public String getSubtitle() {
        return this.holoLogData.subtitle();
    }

    @Override
    protected void renderEntity(PoseStack poseStack, ResourceLocation entityId, float partialTick, int lightLevel) {
        Minecraft mc = Minecraft.m_91087_();
        this.renderEntity(poseStack, (MultiBufferSource)mc.m_91269_().m_110104_(), entityId, partialTick, lightLevel);
    }

    @Override
    protected void renderEntity(PoseStack poseStack, MultiBufferSource buffer, ResourceLocation entityId, float partialTick, int lightLevel) {
        EntityType.m_20632_((String)entityId.toString()).ifPresent(entityType -> {
            Entity entity;
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91073_ != null && (entity = entityType.m_20615_((Level)mc.f_91073_)) instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                mc.m_91290_().m_114384_((Entity)livingEntity, 0.0, 0.0, 0.0, 0.0f, partialTick, poseStack, buffer, lightLevel);
                if (buffer instanceof MultiBufferSource.BufferSource) {
                    MultiBufferSource.BufferSource bufferSource = (MultiBufferSource.BufferSource)buffer;
                    bufferSource.m_109911_();
                }
            }
        });
    }

    @Override
    protected void renderHoloEntity(PoseStack poseStack, HoloLogDisplayEntity displayEntity, float partialTick, int lightLevel) {
        Minecraft mc = Minecraft.m_91087_();
        this.renderHoloEntity(poseStack, (MultiBufferSource)mc.m_91269_().m_110104_(), displayEntity, partialTick, lightLevel);
    }

    @Override
    protected void renderHoloEntity(PoseStack poseStack, MultiBufferSource buffer, HoloLogDisplayEntity displayEntity, float partialTick, int lightLevel) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel level = minecraft.f_91073_;
        if (level == null || HoloLogEntityRegistry.HOLO_LOG_HUMANOID_ENTITY_TYPE == null) {
            return;
        }
        HoloLogHumanoidEntity holoEntity = (HoloLogHumanoidEntity)HoloLogEntityRegistry.HOLO_LOG_HUMANOID_ENTITY_TYPE.m_20615_((Level)level);
        if (holoEntity != null) {
            if (displayEntity.texture() != null) {
                holoEntity.setTexture(displayEntity.texture());
            }
            holoEntity.setSlim(displayEntity.slim());
            holoEntity.f_19797_ = (int)level.m_46467_();
            minecraft.m_91290_().m_114384_((Entity)holoEntity, 0.0, 0.0, 0.0, 0.0f, partialTick, poseStack, buffer, lightLevel);
            if (buffer instanceof MultiBufferSource.BufferSource) {
                MultiBufferSource.BufferSource bufferSource = (MultiBufferSource.BufferSource)buffer;
                bufferSource.m_109911_();
            }
        }
    }

    @Override
    protected void renderBlock(PoseStack poseStack, ResourceLocation blockId, int lightLevel) {
        Minecraft mc = Minecraft.m_91087_();
        this.renderBlock(poseStack, (MultiBufferSource)mc.m_91269_().m_110104_(), blockId, lightLevel);
    }

    @Override
    protected void renderBlock(PoseStack poseStack, MultiBufferSource buffer, ResourceLocation blockId, int lightLevel) {
        Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(blockId);
        if (block != null && block != Blocks.f_50016_) {
            Minecraft mc = Minecraft.m_91087_();
            int fullBright = 0xF000F0;
            mc.m_91289_().m_110912_(block.m_49966_(), poseStack, buffer, fullBright, OverlayTexture.f_118083_);
            if (buffer instanceof MultiBufferSource.BufferSource) {
                MultiBufferSource.BufferSource bufferSource = (MultiBufferSource.BufferSource)buffer;
                bufferSource.m_109911_();
            }
        }
    }

    @Override
    protected void renderItem(PoseStack poseStack, ResourceLocation itemId, int lightLevel) {
        Minecraft mc = Minecraft.m_91087_();
        this.renderItem(poseStack, (MultiBufferSource)mc.m_91269_().m_110104_(), itemId, lightLevel);
    }

    @Override
    protected void renderItem(PoseStack poseStack, MultiBufferSource buffer, ResourceLocation itemId, int lightLevel) {
        Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(itemId);
        if (item != null && item != Items.f_41852_) {
            Minecraft mc = Minecraft.m_91087_();
            ItemStack itemStack = new ItemStack((ItemLike)item);
            mc.m_91291_().m_269128_(itemStack, ItemDisplayContext.FIXED, lightLevel, OverlayTexture.f_118083_, poseStack, buffer, (Level)mc.f_91073_, 0);
            if (buffer instanceof MultiBufferSource.BufferSource) {
                MultiBufferSource.BufferSource bufferSource = (MultiBufferSource.BufferSource)buffer;
                bufferSource.m_109911_();
            }
        }
    }
}

