/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.block.entity.floatingscrapcollector;

import de.markusbordihn.scraptechworkshop.block.entity.AbstractWorkshopBlockEntity;
import de.markusbordihn.scraptechworkshop.block.entity.floatingscrapcollector.FloatingScrapCollectorContainer;
import de.markusbordihn.scraptechworkshop.block.floatingscrapcollector.FloatingScrapCollectorBlock;
import de.markusbordihn.scraptechworkshop.data.floatingscrapcollector.FloatingScrapCollectorStatus;
import de.markusbordihn.scraptechworkshop.data.floatingscrapcollector.ScrapFilterType;
import de.markusbordihn.scraptechworkshop.item.ScrapFilterItem;
import de.markusbordihn.scraptechworkshop.menu.FloatingScrapCollectorMenu;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_173;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_3913;
import net.minecraft.class_52;
import net.minecraft.class_8567;

public class FloatingScrapCollectorBlockEntity
extends AbstractWorkshopBlockEntity {
    private static final String TRANSLATION_KEY = "container.scrap_tech_workshop.floating_scrap_collector";
    private static final String PROGRESS_TAG = "Progress";
    private static final String MAX_PROGRESS_TAG = "MaxProgress";
    private static final int DATA_PROGRESS = 0;
    private static final int DATA_MAX_PROGRESS = 1;
    private static final int DATA_COUNT = 2;
    private static final int MIN_COLLECTION_TIME = 2400;
    private static final int MAX_COLLECTION_TIME = 4800;
    public static class_2591<FloatingScrapCollectorBlockEntity> TYPE;
    private final FloatingScrapCollectorContainer container;
    private int progress = 0;
    private int maxProgress = 2400;
    private final class_3913 containerData = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> FloatingScrapCollectorBlockEntity.this.progress;
                case 1 -> FloatingScrapCollectorBlockEntity.this.maxProgress;
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    FloatingScrapCollectorBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    FloatingScrapCollectorBlockEntity.this.maxProgress = value;
                }
            }
        }

        public int method_17389() {
            return 2;
        }
    };

    public FloatingScrapCollectorBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(TYPE, blockPos, blockState);
        this.container = new FloatingScrapCollectorContainer(this);
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 blockState, FloatingScrapCollectorBlockEntity blockEntity) {
        if (!level.field_9236) {
            blockEntity.serverTick(level, blockPos, blockState);
        }
    }

    @Override
    protected class_2371<class_1799> getItems() {
        return this.container.getItems();
    }

    @Override
    protected class_1278 getContainerDelegate() {
        return this.container;
    }

    private void serverTick(class_1937 level, class_2338 blockPos, class_2680 blockState) {
        class_1799 netStack = this.container.method_5438(0);
        FloatingScrapCollectorStatus newStatus = this.determineStatus(netStack);
        if (newStatus == FloatingScrapCollectorStatus.WORKING) {
            ++this.progress;
            if (this.progress >= this.maxProgress) {
                this.collectScrap(level, blockPos, netStack);
                this.progress = 0;
                this.maxProgress = 2400 + level.method_8409().method_43048(2400);
            }
        } else {
            this.progress = 0;
        }
        this.setStatus(blockState, newStatus);
    }

    private FloatingScrapCollectorStatus determineStatus(class_1799 netStack) {
        if (netStack.method_7960() || !(netStack.method_7909() instanceof ScrapFilterItem)) {
            return FloatingScrapCollectorStatus.EMPTY;
        }
        if (ScrapFilterItem.getDurability(netStack) <= 0) {
            return FloatingScrapCollectorStatus.EMPTY;
        }
        if (this.isOutputFull()) {
            return FloatingScrapCollectorStatus.FULL;
        }
        return FloatingScrapCollectorStatus.WORKING;
    }

    private boolean isOutputFull() {
        for (int i = 1; i < 10; ++i) {
            class_1799 stack = this.container.method_5438(i);
            if (!stack.method_7960() && stack.method_7947() >= stack.method_7914()) continue;
            return false;
        }
        return true;
    }

    private void collectScrap(class_1937 level, class_2338 blockPos, class_1799 netStack) {
        class_1792 class_17922 = netStack.method_7909();
        if (!(class_17922 instanceof ScrapFilterItem)) {
            return;
        }
        ScrapFilterItem filterItem = (ScrapFilterItem)class_17922;
        ScrapFilterType filterType = filterItem.getFilterType();
        int waterBlocks = this.countSurroundingWater(level, blockPos);
        float waterQualityBonus = this.getWaterQualityBonus(waterBlocks);
        List<class_1799> loot = this.generateLoot(level, filterType, waterQualityBonus);
        for (class_1799 item : loot) {
            if (!this.addToOutput(item)) break;
        }
        ScrapFilterItem.consumeDurability(netStack, 1);
        if (ScrapFilterItem.getDurability(netStack) <= 0) {
            this.container.method_5447(0, class_1799.field_8037);
        }
        this.method_5431();
    }

    private int countSurroundingWater(class_1937 level, class_2338 pos) {
        int waterCount = 0;
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                class_2338 checkPos = pos.method_10069(x, 0, z);
                class_3610 fluid = level.method_8316(checkPos);
                if (!fluid.method_15767(class_3486.field_15517)) continue;
                ++waterCount;
            }
        }
        class_2338 belowPos = pos.method_10074();
        class_3610 fluidBelow = level.method_8316(belowPos);
        if (fluidBelow.method_15767(class_3486.field_15517)) {
            ++waterCount;
        }
        return waterCount;
    }

    private float getWaterQualityBonus(int waterBlocks) {
        if (waterBlocks >= 9) {
            return 0.75f;
        }
        if (waterBlocks >= 7) {
            return 0.5f;
        }
        if (waterBlocks >= 4) {
            return 0.25f;
        }
        return 0.0f;
    }

    private List<class_1799> generateLoot(class_1937 level, ScrapFilterType filterType, float waterQualityBonus) {
        ObjectArrayList bonusLoot;
        if (!(level instanceof class_3218)) {
            return new ArrayList<class_1799>();
        }
        class_3218 serverLevel = (class_3218)level;
        String lootTablePath = "scrap_tech_workshop:gameplay/floating_scrap_collector/" + filterType.method_15434();
        class_2960 lootTableId = new class_2960(lootTablePath);
        class_52 lootTable = serverLevel.method_8503().method_3857().getLootTable(lootTableId);
        if (lootTable == class_52.field_948) {
            return new ArrayList<class_1799>();
        }
        class_8567 lootParams = new class_8567.class_8568(serverLevel).method_51874(class_181.field_24424, (Object)class_243.method_24953((class_2382)this.field_11867)).method_51874(class_181.field_1229, (Object)new class_1799((class_1935)class_1802.field_8378)).method_51875(class_173.field_1176);
        ObjectArrayList loot = lootTable.method_51878(lootParams);
        if (waterQualityBonus > 0.0f && level.method_8409().method_43057() < waterQualityBonus && !(bonusLoot = lootTable.method_51878(lootParams)).isEmpty()) {
            class_1799 bonusItem = (class_1799)bonusLoot.get(level.method_8409().method_43048(bonusLoot.size()));
            loot.add(bonusItem);
        }
        return loot;
    }

    private boolean addToOutput(class_1799 newItem) {
        if (newItem.method_7960()) {
            return false;
        }
        for (int i = 1; i < 10; ++i) {
            int space;
            class_1799 existing = this.container.method_5438(i);
            if (existing.method_7960()) {
                this.container.method_5447(i, newItem.method_7972());
                return true;
            }
            if (!class_1799.method_31577((class_1799)existing, (class_1799)newItem) || (space = existing.method_7914() - existing.method_7947()) <= 0) continue;
            int amountToAdd = Math.min(space, newItem.method_7947());
            existing.method_7933(amountToAdd);
            newItem.method_7934(amountToAdd);
            if (!newItem.method_7960()) continue;
            return true;
        }
        return newItem.method_7960();
    }

    private void setStatus(class_2680 blockState, FloatingScrapCollectorStatus newStatus) {
        class_1937 currentLevel = this.method_10997();
        if (currentLevel != null && blockState.method_28498(FloatingScrapCollectorBlock.STATUS) && blockState.method_11654(FloatingScrapCollectorBlock.STATUS) != newStatus) {
            currentLevel.method_8652(this.field_11867, (class_2680)blockState.method_11657(FloatingScrapCollectorBlock.STATUS, (Comparable)((Object)newStatus)), 3);
        }
    }

    public FloatingScrapCollectorContainer getContainer() {
        return this.container;
    }

    public class_3913 getContainerData() {
        return this.containerData;
    }

    @Override
    public void method_11014(class_2487 compoundTag) {
        super.method_11014(compoundTag);
        this.progress = compoundTag.method_10550(PROGRESS_TAG);
        this.maxProgress = compoundTag.method_10550(MAX_PROGRESS_TAG);
    }

    @Override
    protected void method_11007(class_2487 compoundTag) {
        super.method_11007(compoundTag);
        compoundTag.method_10569(PROGRESS_TAG, this.progress);
        compoundTag.method_10569(MAX_PROGRESS_TAG, this.maxProgress);
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)TRANSLATION_KEY);
    }

    public class_1703 createMenu(int windowId, class_1661 playerInventory, class_1657 player) {
        return new FloatingScrapCollectorMenu(windowId, playerInventory, this, this.containerData);
    }
}

