/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.markusbordihn.scraptechworkshop.client.renderer.hololog.HoloLogScreenPlayer;
import de.markusbordihn.scraptechworkshop.data.hololog.DisplayType;
import de.markusbordihn.scraptechworkshop.data.hololog.HoloLogData;
import de.markusbordihn.scraptechworkshop.data.hololog.HoloLogDisplayEntity;
import de.markusbordihn.scraptechworkshop.data.hololog.HoloLogDisplayRecipe;
import de.markusbordihn.scraptechworkshop.data.hololog.HoloLogLine;
import de.markusbordihn.scraptechworkshop.data.hololog.HoloLogManager;
import de.markusbordihn.scraptechworkshop.data.hololog.UIContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HoloPadScreen
extends Screen {
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");
    private static final ResourceLocation HOLOPAD_TEXTURE = new ResourceLocation("scrap_tech_workshop", "textures/gui/holo_pad.png");
    private static final int TEXTURE_WIDTH = 512;
    private static final int TEXTURE_HEIGHT = 256;
    private static final int SCREEN_WIDTH = 370;
    private static final int SCREEN_HEIGHT = 250;
    private static final int HOLOGRAM_AREA_X = 16;
    private static final int HOLOGRAM_AREA_Y = 16;
    private static final int HOLOGRAM_AREA_WIDTH = 338;
    private static final int HOLOGRAM_AREA_HEIGHT = 100;
    private static final int HOLOGRAM_AREA_CENTER_Y_OFFSET = 0;
    private static final int HOLOLOG_TITLE_AREA_X = 24;
    private static final int HOLOLOG_TITLE_AREA_Y = 94;
    private static final int TEXT_AREA_X = 12;
    private static final int TEXT_AREA_Y = 118;
    private static final int TEXT_AREA_WIDTH = 338;
    private static final int TEXT_AREA_HEIGHT = 120;
    private static final int TEXT_PADDING = 4;
    private static final int TITLE_SPACING = 2;
    private static final int SUBTITLE_SPACING = 4;
    private static final int LINE_SPACING = 2;
    private static final int SCROLL_BUTTON_WIDTH = 12;
    private static final int SCROLL_BUTTON_HEIGHT = 17;
    private static final int SCROLL_BUTTON_X_OFFSET = 338;
    private static final float HOLOGRAM_SCALE_FACTOR = 35.0f;
    private static final float HOLOGRAM_ITEM_SCALE_MULTIPLIER = 2.5f;
    private static final float HOLOGRAM_BLOCK_SCALE_MULTIPLIER = 2.0f;
    private static final float HOLOGRAM_ENTITY_SCALE_MULTIPLIER = 1.95f;
    private static final int HOLOGRAM_ENTITY_Y_OFFSET = 20;
    private static final float HOLOGRAM_Z_OFFSET = 100.0f;
    private static final int ROTATION_X = 180;
    private static final int MAX_LIGHT_LEVEL = 0xF000F0;
    private static final int COLOR_TITLE_TEXT = 65535;
    private static final int COLOR_SUBTITLE_TEXT = 0xAAAAAA;
    private static final int COLOR_LINE_TEXT = 0xFFFFFF;
    private final ResourceLocation holoLogId;
    private final List<String> wrappedTextLines = new ArrayList<String>();
    private HoloLogData holoLogData;
    private HoloLogScreenPlayer player;
    private int scrollOffset;
    private int leftPos;
    private int topPos;
    private Button replayButton;
    private Button closeButton;
    private boolean playbackCompleted = false;

    public HoloPadScreen(ResourceLocation holoLogId) {
        super((Component)Component.m_237115_((String)"item.scrap_tech_workshop.holo_pad"));
        this.holoLogId = holoLogId;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.leftPos = (this.f_96543_ - 370) / 2;
        this.topPos = (this.f_96544_ - 250) / 2;
        this.addScrollButtons();
        this.addReplayButton();
        this.addCloseButton();
        if (this.player != null) {
            return;
        }
        if (this.holoLogId == null) {
            log.warn("{} No holo log ID provided", (Object)"Scrap Tech Workshop");
            return;
        }
        log.info("{} Opening holo pad screen: {}", (Object)"Scrap Tech Workshop", (Object)this.holoLogId);
        HoloLogManager.loadHoloLog(this.holoLogId).ifPresentOrElse(data -> {
            this.holoLogData = data;
            this.prepareTextLines();
            this.startHoloLogPlayback((HoloLogData)data);
        }, () -> log.error("{} Failed to load hololog: {}", (Object)"Scrap Tech Workshop", (Object)this.holoLogId));
    }

    private void addScrollButtons() {
        int buttonX = this.leftPos + 12 + 338;
        int scrollUpY = this.topPos + 118 + 2;
        int scrollDownY = this.topPos + 118 + 120 - 17 - 2;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"\u25b2"), button -> this.scrollUp()).m_252987_(buttonX, scrollUpY, 12, 17).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"\u25bc"), button -> this.scrollDown()).m_252987_(buttonX, scrollDownY, 12, 17).m_253136_());
    }

    private void addReplayButton() {
        int buttonWidth = 80;
        int buttonHeight = 20;
        int buttonX = this.leftPos + 16 + (338 - buttonWidth) / 2;
        int buttonY = this.topPos + 16 + (100 - buttonHeight) / 2 - 15;
        this.replayButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.scrap_tech_workshop.holo_pad.replay"), button -> this.replayHololog()).m_252987_(buttonX, buttonY, buttonWidth, buttonHeight).m_253136_();
        this.replayButton.f_93624_ = false;
        this.m_142416_((GuiEventListener)this.replayButton);
    }

    private void addCloseButton() {
        int buttonWidth = 80;
        int buttonHeight = 20;
        int buttonX = this.leftPos + 16 + (338 - buttonWidth) / 2;
        int buttonY = this.topPos + 16 + (100 - buttonHeight) / 2 + 10;
        this.closeButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.scrap_tech_workshop.holo_pad.close"), button -> this.m_7379_()).m_252987_(buttonX, buttonY, buttonWidth, buttonHeight).m_253136_();
        this.closeButton.f_93624_ = false;
        this.m_142416_((GuiEventListener)this.closeButton);
    }

    private void scrollUp() {
        this.scrollOffset = Math.max(0, this.scrollOffset - 10);
    }

    private void scrollDown() {
        int maxScroll = Math.max(0, this.calculateTotalTextHeight() - 112);
        this.scrollOffset = Math.min(this.scrollOffset + 10, maxScroll);
    }

    private void startHoloLogPlayback(HoloLogData data) {
        if (this.f_96541_ == null || this.f_96541_.f_91073_ == null) {
            log.error("{} Cannot start playback: minecraft or level is null", (Object)"Scrap Tech Workshop");
            return;
        }
        this.player = new HoloLogScreenPlayer(data, new UIContext((Level)this.f_96541_.f_91073_, Vec3.f_82478_), UUID.randomUUID(), this::onPlaybackComplete);
        this.player.start();
        this.playbackCompleted = false;
        if (this.replayButton != null) {
            this.replayButton.f_93624_ = false;
        }
        if (this.closeButton != null) {
            this.closeButton.f_93624_ = false;
        }
        log.info("{} Started hololog playback for: {}", (Object)"Scrap Tech Workshop", (Object)this.holoLogId);
    }

    private void onPlaybackComplete() {
        this.playbackCompleted = true;
        log.info("{} Hololog playback completed: {}", (Object)"Scrap Tech Workshop", (Object)this.holoLogId);
        if (this.replayButton != null) {
            this.replayButton.f_93624_ = true;
        }
        if (this.closeButton != null) {
            this.closeButton.f_93624_ = true;
        }
    }

    private void replayHololog() {
        log.info("{} Replaying hololog: {}", (Object)"Scrap Tech Workshop", (Object)this.holoLogId);
        this.scrollOffset = 0;
        if (this.holoLogData != null) {
            this.startHoloLogPlayback(this.holoLogData);
        }
    }

    private void prepareTextLines() {
        this.wrappedTextLines.clear();
        if (this.holoLogData == null || this.holoLogData.lines().isEmpty()) {
            return;
        }
        this.holoLogData.lines().stream().map(HoloLogLine::text).filter(text -> text != null && !text.isEmpty()).forEach(this.wrappedTextLines::add);
    }

    public void m_86600_() {
        super.m_86600_();
        if (this.player != null && this.player.isPlaying()) {
            this.player.tick();
            this.autoScrollText();
        }
    }

    private void autoScrollText() {
        int maxScroll;
        int neededScroll;
        int targetScroll;
        int visibleHeight;
        if (this.player == null) {
            return;
        }
        int currentContentHeight = 0;
        if (this.holoLogData != null) {
            if (this.holoLogData.title() != null) {
                Objects.requireNonNull(this.f_96547_);
                currentContentHeight += 9 + 2;
            }
            if (this.holoLogData.subtitle() != null && !this.holoLogData.subtitle().isEmpty()) {
                Objects.requireNonNull(this.f_96547_);
                currentContentHeight += 9 + 4;
            }
        }
        int displayedLines = this.player.getDisplayedLines().size();
        Objects.requireNonNull(this.f_96547_);
        currentContentHeight += displayedLines * (9 + 2);
        String partialLine = this.player.getCurrentPartialLine();
        if (partialLine != null && !partialLine.isEmpty()) {
            Objects.requireNonNull(this.f_96547_);
            currentContentHeight += 9 + 2;
        }
        if (currentContentHeight > (visibleHeight = 112) && this.scrollOffset < (targetScroll = Math.min(neededScroll = currentContentHeight - visibleHeight, maxScroll = Math.max(0, this.calculateTotalTextHeight() - visibleHeight)))) {
            ++this.scrollOffset;
            this.scrollOffset = Math.min(this.scrollOffset, targetScroll);
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.renderDefaultBackground(guiGraphics, this.leftPos, this.topPos);
        if (!this.playbackCompleted) {
            this.renderHologram(guiGraphics, this.leftPos, this.topPos, partialTick);
        }
        this.renderHolologTitleArea(guiGraphics, this.leftPos, this.topPos);
        this.renderText(guiGraphics, this.leftPos, this.topPos);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (delta > 0.0) {
            this.scrollUp();
        } else if (delta < 0.0) {
            this.scrollDown();
        }
        return true;
    }

    public void m_7379_() {
        if (this.player != null) {
            this.player.stop();
            this.player = null;
        }
        super.m_7379_();
    }

    public boolean m_7043_() {
        return false;
    }

    private void renderDefaultBackground(GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.m_280163_(HOLOPAD_TEXTURE, x, y, 0.0f, 0.0f, 370, 250, 512, 256);
    }

    private void renderHologram(GuiGraphics guiGraphics, int x, int y, float partialTick) {
        if (this.player == null) {
            return;
        }
        HoloLogDisplayRecipe displayRecipe = this.player.getCurrentDisplayRecipe();
        if (displayRecipe != null) {
            this.renderRecipe(guiGraphics, x, y, displayRecipe);
            return;
        }
        HoloLogDisplayEntity displayEntity = this.player.getCurrentDisplayEntity();
        if (displayEntity == null) {
            return;
        }
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        int centerX = x + 16 + 169;
        int centerY = y + 16 + 50 + 0;
        if (displayEntity.type() == DisplayType.ITEM) {
            centerY -= 10;
        } else if (displayEntity.type() == DisplayType.ENTITY || displayEntity.type() == DisplayType.HOLO_ENTITY) {
            centerY += 20;
        }
        poseStack.m_252880_((float)centerX, (float)centerY, 100.0f);
        float scale = displayEntity.scale() * 35.0f;
        if (displayEntity.type() == DisplayType.ITEM) {
            scale *= 2.5f;
        } else if (displayEntity.type() == DisplayType.BLOCK) {
            scale *= 2.0f;
        } else if (displayEntity.type() == DisplayType.ENTITY || displayEntity.type() == DisplayType.HOLO_ENTITY) {
            scale *= 1.95f;
        }
        poseStack.m_85841_(scale, scale, scale);
        if (displayEntity.type() == DisplayType.ENTITY || displayEntity.type() == DisplayType.HOLO_ENTITY) {
            poseStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            if (displayEntity.rotationX() != 0.0f) {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(displayEntity.rotationX()));
            }
            if (displayEntity.rotationY() != 0.0f) {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(displayEntity.rotationY()));
            }
            if (displayEntity.rotationZ() != 0.0f) {
                poseStack.m_252781_(Axis.f_252403_.m_252977_(displayEntity.rotationZ()));
            }
        } else if (displayEntity.type() == DisplayType.ITEM) {
            poseStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(0.0f));
            if (displayEntity.rotationSpeed() > 0.0f && this.f_96541_ != null && this.f_96541_.f_91073_ != null) {
                float time = this.f_96541_.f_91073_.m_46467_();
                float rotationSpeed = displayEntity.rotationSpeed();
                poseStack.m_252781_(Axis.f_252436_.m_252977_(time * rotationSpeed));
            }
            if (displayEntity.rotationX() != 0.0f) {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(displayEntity.rotationX()));
            }
            if (displayEntity.rotationY() != 0.0f) {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(displayEntity.rotationY()));
            }
            if (displayEntity.rotationZ() != 0.0f) {
                poseStack.m_252781_(Axis.f_252403_.m_252977_(displayEntity.rotationZ()));
            }
        } else {
            poseStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
            if (displayEntity.rotationSpeed() > 0.0f && this.f_96541_ != null && this.f_96541_.f_91073_ != null) {
                float time = this.f_96541_.f_91073_.m_46467_();
                float rotationSpeed = displayEntity.rotationSpeed();
                poseStack.m_252781_(Axis.f_252436_.m_252977_(time * rotationSpeed));
            }
            if (displayEntity.rotationX() != 0.0f) {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(displayEntity.rotationX()));
            }
            if (displayEntity.rotationY() != 0.0f) {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(displayEntity.rotationY()));
            }
            if (displayEntity.rotationZ() != 0.0f) {
                poseStack.m_252781_(Axis.f_252403_.m_252977_(displayEntity.rotationZ()));
            }
            if (displayEntity.type() == DisplayType.BLOCK) {
                poseStack.m_85837_(-0.5, -0.5, -0.5);
            }
        }
        this.player.renderDisplayEntity(poseStack, partialTick, 0xF000F0);
        poseStack.m_85849_();
    }

    private void renderHolologTitleArea(GuiGraphics guiGraphics, int x, int y) {
        if (this.player == null && this.holoLogData == null) {
            return;
        }
        int titleX = x + 24 + 4;
        int titleY = y + 94 + 2;
        if (this.player != null) {
            String subtitle;
            String title = this.player.getTitle();
            if (title != null && !title.isEmpty()) {
                guiGraphics.m_280056_(this.f_96547_, title, titleX, titleY, 65535, false);
                Objects.requireNonNull(this.f_96547_);
                titleY += 9 + 2;
            }
            if ((subtitle = this.player.getSubtitle()) != null && !subtitle.isEmpty()) {
                guiGraphics.m_280056_(this.f_96547_, subtitle, titleX, titleY, 0xAAAAAA, false);
            }
        } else if (this.holoLogData != null) {
            if (this.holoLogData.title() != null) {
                guiGraphics.m_280056_(this.f_96547_, this.holoLogData.title(), titleX, titleY, 65535, false);
                Objects.requireNonNull(this.f_96547_);
                titleY += 9 + 2;
            }
            if (this.holoLogData.subtitle() != null && !this.holoLogData.subtitle().isEmpty()) {
                guiGraphics.m_280056_(this.f_96547_, this.holoLogData.subtitle(), titleX, titleY, 0xAAAAAA, false);
            }
        }
    }

    private void renderText(GuiGraphics guiGraphics, int x, int y) {
        int textX = x + 12 + 4;
        int textY = y + 118 + 4;
        guiGraphics.m_280588_(x + 12, y + 118, x + 12 + 338, y + 118 + 120);
        int yOffset = textY - this.scrollOffset;
        if (this.player != null) {
            yOffset = this.renderPlayerContent(guiGraphics, textX, yOffset, y);
        } else if (this.holoLogData != null) {
            yOffset = this.renderFallbackContent(guiGraphics, textX, yOffset);
        } else {
            this.renderNoContent(guiGraphics, textX, textY);
        }
        guiGraphics.m_280618_();
    }

    private int renderPlayerContent(GuiGraphics guiGraphics, int textX, int yOffset, int areaY) {
        int maxY = areaY + 118 + 120 - 8;
        for (String line : this.player.getDisplayedLines()) {
            if (yOffset >= areaY + 118 && yOffset < maxY) {
                guiGraphics.m_280056_(this.f_96547_, line, textX, yOffset, 0xFFFFFF, false);
            }
            Objects.requireNonNull(this.f_96547_);
            yOffset += 9 + 2;
        }
        String partialLine = this.player.getCurrentPartialLine();
        if (partialLine != null && !partialLine.isEmpty() && yOffset >= areaY + 118 && yOffset < maxY) {
            guiGraphics.m_280056_(this.f_96547_, partialLine, textX, yOffset, 0xFFFFFF, false);
        }
        return yOffset;
    }

    private int renderFallbackContent(GuiGraphics guiGraphics, int textX, int yOffset) {
        return yOffset;
    }

    private void renderNoContent(GuiGraphics guiGraphics, int textX, int textY) {
        String message = "No hololog content";
        int n = textX + (330 - this.f_96547_.m_92895_(message)) / 2;
        Objects.requireNonNull(this.f_96547_);
        guiGraphics.m_280056_(this.f_96547_, message, n, textY + (112 - 9) / 2, 0xAAAAAA, false);
    }

    private void renderRecipe(GuiGraphics guiGraphics, int x, int y, HoloLogDisplayRecipe displayRecipe) {
        if (this.f_96541_ == null || this.f_96541_.f_91073_ == null) {
            return;
        }
        Optional recipeOpt = this.f_96541_.f_91073_.m_7465_().m_44043_(displayRecipe.recipeId());
        if (recipeOpt.isEmpty()) {
            log.warn("Recipe not found: {}", (Object)displayRecipe.recipeId());
            return;
        }
        Recipe recipe = (Recipe)recipeOpt.get();
        int centerX = x + 16 + 169;
        int centerY = y + 16 + 50 - 15;
        ArrayList inputs = new ArrayList();
        try {
            if (!recipe.m_7527_().isEmpty()) {
                recipe.m_7527_().forEach(ingredient -> {
                    ItemStack[] items = ingredient.m_43908_();
                    if (items.length > 0) {
                        inputs.add(items[0]);
                    }
                });
            }
        }
        catch (Exception e) {
            log.error("Failed to get recipe inputs: {}", (Object)e.getMessage());
        }
        ItemStack output = recipe.m_8043_(this.f_96541_.f_91073_.m_9598_());
        int itemSize = 24;
        int spacing = 12;
        float inputScale = 1.5f * displayRecipe.scale();
        int gridSize = (int)Math.ceil(Math.sqrt(inputs.size()));
        int totalGridWidth = gridSize * itemSize + (gridSize - 1) * 4;
        int totalGridHeight = gridSize * itemSize + (gridSize - 1) * 4;
        int inputStartX = centerX - totalGridWidth - spacing - 10;
        int inputStartY = centerY - totalGridHeight / 2;
        PoseStack poseStack = guiGraphics.m_280168_();
        for (int i = 0; i < inputs.size(); ++i) {
            ItemStack input = (ItemStack)inputs.get(i);
            if (input.m_41619_()) continue;
            int gridX = i % gridSize;
            int gridY = i / gridSize;
            int xPos = inputStartX + gridX * (itemSize + 4);
            int yPos = inputStartY + gridY * (itemSize + 4);
            poseStack.m_85836_();
            poseStack.m_252880_((float)xPos, (float)yPos, 0.0f);
            poseStack.m_85841_(inputScale, inputScale, 1.0f);
            guiGraphics.m_280480_(input, 0, 0);
            guiGraphics.m_280370_(this.f_96547_, input, 0, 0);
            poseStack.m_85849_();
        }
        String arrow = "\u2192";
        float arrowScale = 2.5f;
        poseStack.m_85836_();
        int arrowWidth = (int)((float)this.f_96547_.m_92895_(arrow) * arrowScale);
        Objects.requireNonNull(this.f_96547_);
        int arrowHeight = (int)(9.0f * arrowScale);
        int arrowX = centerX - arrowWidth / 2;
        int arrowY = centerY - arrowHeight / 2;
        poseStack.m_252880_((float)arrowX, (float)arrowY, 0.0f);
        poseStack.m_85841_(arrowScale, arrowScale, 1.0f);
        guiGraphics.m_280056_(this.f_96547_, arrow, 0, 0, 65535, false);
        poseStack.m_85849_();
        if (!output.m_41619_()) {
            int outputX = centerX + spacing + 10;
            int outputY = centerY - itemSize / 2;
            float outputScale = 1.8f * displayRecipe.scale();
            poseStack.m_85836_();
            poseStack.m_252880_((float)outputX, (float)outputY, 0.0f);
            poseStack.m_85841_(outputScale, outputScale, 1.0f);
            guiGraphics.m_280480_(output, 0, 0);
            guiGraphics.m_280370_(this.f_96547_, output, 0, 0);
            poseStack.m_85849_();
        }
    }

    private int calculateTotalTextHeight() {
        int n = this.wrappedTextLines.size();
        Objects.requireNonNull(this.f_96547_);
        return n * (9 + 2);
    }
}

