/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.data.hololog;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.markusbordihn.scraptechworkshop.data.hololog.HoloLogParticle;
import de.markusbordihn.scraptechworkshop.data.hololog.HoloLogSound;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;

public record HoloLogEffects(List<HoloLogSound> sfx, List<HoloLogParticle> fx) {
    public static final HoloLogEffects EMPTY = new HoloLogEffects(List.of(), List.of());
    private static final String FIELD_PLAY_SOUND = "playSound";
    private static final String FIELD_SHOW_PARTICLE = "showParticle";
    private static final String FIELD_ID = "id";
    private static final String FIELD_VOLUME = "volume";
    private static final String FIELD_PITCH = "pitch";
    private static final String FIELD_COUNT = "count";
    private static final String FIELD_COLOR = "color";
    private static final String FIELD_SCALE = "scale";
    private static final float DEFAULT_VOLUME = 1.0f;
    private static final float DEFAULT_PITCH = 1.0f;
    private static final int DEFAULT_PARTICLE_COUNT = 5;
    private static final float DEFAULT_PARTICLE_SCALE = 1.0f;

    public static HoloLogEffects fromJson(JsonObject json) {
        ArrayList<HoloLogSound> sounds = new ArrayList<HoloLogSound>();
        if (json.has(FIELD_PLAY_SOUND)) {
            JsonArray soundArray = json.getAsJsonArray(FIELD_PLAY_SOUND);
            for (JsonElement soundElement : soundArray) {
                JsonObject soundObj = soundElement.getAsJsonObject();
                ResourceLocation id = new ResourceLocation(soundObj.get(FIELD_ID).getAsString());
                float volume = soundObj.has(FIELD_VOLUME) ? soundObj.get(FIELD_VOLUME).getAsFloat() : 1.0f;
                float pitch = soundObj.has(FIELD_PITCH) ? soundObj.get(FIELD_PITCH).getAsFloat() : 1.0f;
                sounds.add(new HoloLogSound(id, volume, pitch));
            }
        }
        ArrayList<HoloLogParticle> particles = new ArrayList<HoloLogParticle>();
        if (json.has(FIELD_SHOW_PARTICLE)) {
            JsonArray particleArray = json.getAsJsonArray(FIELD_SHOW_PARTICLE);
            for (JsonElement particleElement : particleArray) {
                JsonObject particleObj = particleElement.getAsJsonObject();
                ResourceLocation id = new ResourceLocation(particleObj.get(FIELD_ID).getAsString());
                int count = particleObj.has(FIELD_COUNT) ? particleObj.get(FIELD_COUNT).getAsInt() : 5;
                String color = particleObj.has(FIELD_COLOR) ? particleObj.get(FIELD_COLOR).getAsString() : null;
                float scale = particleObj.has(FIELD_SCALE) ? particleObj.get(FIELD_SCALE).getAsFloat() : 1.0f;
                particles.add(new HoloLogParticle(id, count, color, scale));
            }
        }
        return new HoloLogEffects(sounds, particles);
    }
}

