/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.loot;

import de.markusbordihn.scraptechworkshop.config.ScrapFishingConfig;
import de.markusbordihn.scraptechworkshop.item.ModItems;
import de.markusbordihn.scraptechworkshop.loot.WeightedLootTable;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;

public final class ScrapFishingLootTables {
    private static WeightedLootTable<Item> vanillaRodTable;
    private static WeightedLootTable<Item> scrapRodTable;
    private static WeightedLootTable<Item> magnetRodTable;

    private ScrapFishingLootTables() {
    }

    public static Item getVanillaRodLoot(RandomSource random) {
        if (vanillaRodTable == null) {
            ScrapFishingLootTables.initialize();
        }
        return vanillaRodTable.generate(random);
    }

    public static Item getScrapRodLoot(RandomSource random) {
        if (scrapRodTable == null) {
            ScrapFishingLootTables.initialize();
        }
        return scrapRodTable.generate(random);
    }

    public static Item getMagnetRodLoot(RandomSource random) {
        if (magnetRodTable == null) {
            ScrapFishingLootTables.initialize();
        }
        return magnetRodTable.generate(random);
    }

    public static void reset() {
        vanillaRodTable = null;
        scrapRodTable = null;
        magnetRodTable = null;
    }

    private static void initialize() {
        vanillaRodTable = ScrapFishingLootTables.createVanillaRodTable();
        scrapRodTable = ScrapFishingLootTables.createScrapRodTable();
        magnetRodTable = ScrapFishingLootTables.createMagnetRodTable();
    }

    private static WeightedLootTable<Item> createVanillaRodTable() {
        return new WeightedLootTable<Item>(new WeightedLootTable.Entry<Item>(ModItems.PLASTIC_SCRAP.get(), ScrapFishingConfig.vanillaPlasticWeight), new WeightedLootTable.Entry<Item>(ModItems.RUBBER_SCRAP.get(), ScrapFishingConfig.vanillaRubberWeight), new WeightedLootTable.Entry<Item>(ModItems.FASTENER_SCRAP.get(), ScrapFishingConfig.vanillaFastenerWeight), new WeightedLootTable.Entry<Item>(ModItems.METAL_SCRAP.get(), ScrapFishingConfig.vanillaMetalWeight), new WeightedLootTable.Entry<Item>(ModItems.IRON_SCRAP.get(), ScrapFishingConfig.vanillaIronWeight), new WeightedLootTable.Entry<Item>(ModItems.CIRCUIT_SCRAP.get(), ScrapFishingConfig.vanillaCircuitWeight), new WeightedLootTable.Entry<Item>(ModItems.GLASS_SCRAP.get(), ScrapFishingConfig.vanillaGlassWeight));
    }

    private static WeightedLootTable<Item> createScrapRodTable() {
        return new WeightedLootTable<Item>(new WeightedLootTable.Entry<Item>(ModItems.METAL_SCRAP.get(), ScrapFishingConfig.scrapRodMetalWeight), new WeightedLootTable.Entry<Item>(ModItems.IRON_SCRAP.get(), ScrapFishingConfig.scrapRodIronWeight), new WeightedLootTable.Entry<Item>(ModItems.COPPER_SCRAP.get(), ScrapFishingConfig.scrapRodCopperWeight), new WeightedLootTable.Entry<Item>(ModItems.CIRCUIT_SCRAP.get(), ScrapFishingConfig.scrapRodCircuitWeight), new WeightedLootTable.Entry<Item>(ModItems.CAPACITOR_SCRAP.get(), ScrapFishingConfig.scrapRodCapacitorWeight), new WeightedLootTable.Entry<Item>(ModItems.PLASTIC_SCRAP.get(), ScrapFishingConfig.scrapRodPlasticWeight), new WeightedLootTable.Entry<Item>(ModItems.RUBBER_SCRAP.get(), ScrapFishingConfig.scrapRodRubberWeight), new WeightedLootTable.Entry<Item>(ModItems.GLASS_SCRAP.get(), ScrapFishingConfig.scrapRodGlassWeight));
    }

    private static WeightedLootTable<Item> createMagnetRodTable() {
        return new WeightedLootTable<Item>(new WeightedLootTable.Entry<Item>(ModItems.CIRCUIT_SCRAP.get(), ScrapFishingConfig.magnetRodCircuitWeight), new WeightedLootTable.Entry<Item>(ModItems.CAPACITOR_SCRAP.get(), ScrapFishingConfig.magnetRodCapacitorWeight), new WeightedLootTable.Entry<Item>(ModItems.COIL_SCRAP.get(), ScrapFishingConfig.magnetRodCoilWeight), new WeightedLootTable.Entry<Item>(ModItems.METAL_SCRAP.get(), ScrapFishingConfig.magnetRodMetalWeight), new WeightedLootTable.Entry<Item>(ModItems.IRON_SCRAP.get(), ScrapFishingConfig.magnetRodIronWeight), new WeightedLootTable.Entry<Item>(ModItems.COPPER_SCRAP.get(), ScrapFishingConfig.magnetRodCopperWeight), new WeightedLootTable.Entry<Item>(ModItems.ALLOY_SCRAP.get(), ScrapFishingConfig.magnetRodAlloyWeight), new WeightedLootTable.Entry<Item>(ModItems.PLASTIC_SCRAP.get(), ScrapFishingConfig.magnetRodPlasticWeight));
    }
}

