/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.menu;

import de.markusbordihn.scraptechworkshop.data.multitool.DisplayMode;
import de.markusbordihn.scraptechworkshop.data.multitool.ScrapMultitoolData;
import de.markusbordihn.scraptechworkshop.data.multitool.ToolMode;
import de.markusbordihn.scraptechworkshop.item.component.EnergyCellItem;
import de.markusbordihn.scraptechworkshop.item.tool.ScrapMultitoolItem;
import de.markusbordihn.scraptechworkshop.menu.multitool.MultitoolBatteryInfo;
import de.markusbordihn.scraptechworkshop.menu.multitool.MultitoolContainerFactory;
import de.markusbordihn.scraptechworkshop.menu.multitool.MultitoolDataSaver;
import de.markusbordihn.scraptechworkshop.menu.slots.EnergyCellSlot;
import de.markusbordihn.scraptechworkshop.menu.slots.MultitoolModuleSlot;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ScrapMultitoolMenu
extends AbstractContainerMenu {
    private static final int BATTERY_SLOT_X = 100;
    private static final int BATTERY_SLOT_Y = 20;
    private static final int MODULE_SLOTS_START_X = 64;
    private static final int MODULE_SLOTS_Y = 50;
    private static final int MODULE_SLOTS_COUNT = 4;
    private static final int PLAYER_INVENTORY_START_X = 8;
    private static final int PLAYER_INVENTORY_START_Y = 138;
    private static final int PLAYER_INVENTORY_ROWS = 3;
    private static final int PLAYER_INVENTORY_COLUMNS = 9;
    private static final int PLAYER_HOTBAR_START_X = 8;
    private static final int PLAYER_HOTBAR_Y = 196;
    private static final int PLAYER_HOTBAR_SLOTS = 9;
    private static final int SLOT_SPACING = 18;
    private static final int TOTAL_TOOL_SLOTS = 5;
    public static MenuType<ScrapMultitoolMenu> TYPE;
    private final ItemStack multitoolStack;
    private final SimpleContainer toolContainer;
    private final int toolSlotIndex;
    private final InteractionHand hand;
    private boolean initialized = false;

    public ScrapMultitoolMenu(int windowId, Inventory playerInventory, FriendlyByteBuf additionalData) {
        this(windowId, playerInventory, additionalData != null ? additionalData.m_130267_() : playerInventory.f_35978_.m_21205_(), additionalData != null ? (InteractionHand)additionalData.m_130066_(InteractionHand.class) : InteractionHand.MAIN_HAND, additionalData != null ? additionalData.readInt() : playerInventory.f_35977_);
    }

    public ScrapMultitoolMenu(int windowId, Inventory playerInventory, ItemStack multitoolStack, InteractionHand hand, int slotIndex) {
        super(TYPE, windowId);
        SimpleContainer tempContainer;
        this.multitoolStack = multitoolStack;
        this.hand = hand;
        this.toolSlotIndex = slotIndex;
        Item item = multitoolStack.m_41720_();
        if (!(item instanceof ScrapMultitoolItem)) {
            throw new IllegalArgumentException("Invalid multitool ItemStack");
        }
        ScrapMultitoolItem multitool = (ScrapMultitoolItem)item;
        this.toolContainer = tempContainer = MultitoolContainerFactory.createToolContainer(multitoolStack, () -> {});
        tempContainer.m_19164_(container -> {
            if (this.initialized) {
                MultitoolDataSaver.saveToMultitool(multitoolStack, this.toolContainer);
            }
        });
        this.addToolSlots();
        this.addPlayerInventory(playerInventory);
        this.addPlayerHotbar(playerInventory);
        this.initialized = true;
    }

    private void addToolSlots() {
        this.m_38897_(new EnergyCellSlot((Container)this.toolContainer, 0, 100, 20));
        for (int i = 0; i < 4; ++i) {
            int slotIndex = i + 1;
            int x = 64 + i * 18;
            this.m_38897_(new MultitoolModuleSlot((Container)this.toolContainer, slotIndex, x, 50));
        }
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 138 + row * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        int col = 0;
        while (col < 9) {
            int x = 8 + col * 18;
            int index = col++;
            this.m_38897_(new Slot((Container)playerInventory, index, x, 196){

                public boolean m_8010_(Player player) {
                    return this.f_40219_ != ScrapMultitoolMenu.this.toolSlotIndex;
                }
            });
        }
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            itemStack = slotStack.m_41777_();
            int playerInventoryEnd = 32;
            int playerHotbarEnd = playerInventoryEnd + 9;
            if (index < 5 ? !this.m_38903_(slotStack, 5, playerHotbarEnd, true) : (index < playerInventoryEnd ? (slotStack.m_41720_() instanceof EnergyCellItem ? !this.m_38903_(slotStack, 0, 1, false) && !this.m_38903_(slotStack, playerInventoryEnd, playerHotbarEnd, false) : (this.isValidModule(slotStack) ? !this.m_38903_(slotStack, 1, 5, false) && !this.m_38903_(slotStack, playerInventoryEnd, playerHotbarEnd, false) : !this.m_38903_(slotStack, playerInventoryEnd, playerHotbarEnd, false))) : index < playerHotbarEnd && (slotStack.m_41720_() instanceof EnergyCellItem ? !this.m_38903_(slotStack, 0, 1, false) && !this.m_38903_(slotStack, 5, playerInventoryEnd, false) : (this.isValidModule(slotStack) ? !this.m_38903_(slotStack, 1, 5, false) && !this.m_38903_(slotStack, 5, playerInventoryEnd, false) : !this.m_38903_(slotStack, 5, playerInventoryEnd, false))))) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemStack;
    }

    private boolean isValidModule(ItemStack itemStack) {
        return itemStack.m_41720_().toString().contains("module") || itemStack.m_41720_().toString().contains("upgrade");
    }

    public boolean m_6875_(Player player) {
        return !this.multitoolStack.m_41619_() && player.m_150109_().m_36063_(this.multitoolStack);
    }

    public void m_6199_(Container container) {
        super.m_6199_(container);
        if (container == this.toolContainer && this.initialized) {
            this.updateMultitoolInPlayerInventory();
        }
    }

    private void updateMultitoolInPlayerInventory() {
        Player player = null;
        for (Slot slot : this.f_38839_) {
            Container container = slot.f_40218_;
            if (!(container instanceof Inventory)) continue;
            Inventory inventory = (Inventory)container;
            if (inventory.f_35978_ == null) continue;
            player = inventory.f_35978_;
            break;
        }
        if (player == null) {
            return;
        }
        this.updateMultitoolInPlayerInventoryForPlayer(player);
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.updateMultitoolInPlayerInventoryForPlayer(player);
    }

    private void updateMultitoolInPlayerInventoryForPlayer(Player player) {
        ItemStack actualMultitoolStack = player.m_21120_(this.hand);
        if (!(actualMultitoolStack.m_41720_() instanceof ScrapMultitoolItem)) {
            return;
        }
        ItemStack[] modules = new ItemStack[4];
        for (int i = 0; i < modules.length; ++i) {
            modules[i] = this.toolContainer.m_8020_(i + 1);
        }
        ScrapMultitoolData currentData = ScrapMultitoolData.fromItemStack(actualMultitoolStack);
        ScrapMultitoolData newData = new ScrapMultitoolData(this.toolContainer.m_8020_(0), modules, currentData.hologramColor(), currentData.hudEnabled(), currentData.toolPriority(), currentData.activeMode());
        newData.saveToItemStack(actualMultitoolStack);
        Item item = actualMultitoolStack.m_41720_();
        if (item instanceof ScrapMultitoolItem) {
            ScrapMultitoolItem multitoolItem = (ScrapMultitoolItem)item;
            multitoolItem.syncEnergyDisplay(actualMultitoolStack);
        }
        DisplayMode displayMode = new DisplayMode(actualMultitoolStack);
        displayMode.updateModel(ToolMode.fromId(newData.activeMode()), newData.getBatteryLevel());
    }

    public ItemStack getMultitoolStack() {
        return this.multitoolStack;
    }

    public int getCurrentEnergyFromBattery() {
        return MultitoolBatteryInfo.getCurrentEnergy(this.toolContainer);
    }

    public int getMaxEnergyFromBattery() {
        return MultitoolBatteryInfo.getMaxEnergy(this.toolContainer);
    }

    public int getBatteryPercentageFromSlot() {
        return MultitoolBatteryInfo.getPercentage(this.toolContainer);
    }
}

