/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.block.entity;

import de.markusbordihn.scraptechworkshop.block.hololog.HoloCubeBlock;
import de.markusbordihn.scraptechworkshop.client.hololog.HolologPlayer;
import de.markusbordihn.scraptechworkshop.data.hololog.HolologData;
import de.markusbordihn.scraptechworkshop.data.hololog.HolologParser;
import de.markusbordihn.scraptechworkshop.data.hololog.HolologStatus;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HoloCubeBlockEntity
extends BlockEntity {
    public static final String ID = "holocube";
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");
    private static final String HOLOLOG_ID_TAG = "HolologId";
    private static final String PLAYER_UUID_TAG = "PlayerUUID";
    private static final ResourceLocation DEFAULT_HOLOLOG = new ResourceLocation("scrap_tech_workshop", "holologs/intro/introduction");
    public static BlockEntityType<HoloCubeBlockEntity> TYPE;
    private ResourceLocation holologId;
    private UUID playerUUID;
    private UUID currentPlayerId = null;

    public HoloCubeBlockEntity(BlockPos pos, BlockState state) {
        super(TYPE, pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, HoloCubeBlockEntity blockEntity) {
        if (!level.f_46443_) {
            return;
        }
        HolologStatus status = (HolologStatus)((Object)state.m_61143_(HoloCubeBlock.STATUS));
        ResourceLocation holologId = blockEntity.getHolologId();
        if (status == HolologStatus.PLAYING && holologId != null) {
            if (blockEntity.currentPlayerId == null) {
                ResourceLocation localizedId = HolologParser.getLocalizedId(holologId);
                Optional<HolologData> holologData = HolologParser.getHololog(localizedId);
                if (holologData.isPresent()) {
                    UUID playerId;
                    HolologPlayer.WorldContext context = new HolologPlayer.WorldContext(level, pos);
                    blockEntity.currentPlayerId = playerId = HolologPlayer.play(holologData.get(), context, text -> {
                        if (Minecraft.m_91087_().f_91074_ != null) {
                            Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237113_((String)("\u00a77[Hololog] \u00a7f" + text)), false);
                        }
                    }, () -> {
                        log.info("Hololog playback finished at {}", (Object)pos);
                        HoloCubeBlock.updateStatus(level, pos, HolologStatus.ENDED);
                    });
                    log.info("Started hololog player with ID: {} at position {}", (Object)playerId, (Object)pos);
                } else {
                    log.error("Failed to load hololog data for: {}", (Object)holologId);
                }
            }
        } else if (status == HolologStatus.PAUSED) {
            if (blockEntity.currentPlayerId != null) {
                HolologPlayer.pause(blockEntity.currentPlayerId);
            }
        } else if (status == HolologStatus.READY) {
            if (blockEntity.currentPlayerId != null) {
                HolologPlayer.stop(blockEntity.currentPlayerId);
                blockEntity.currentPlayerId = null;
            }
        } else if (status == HolologStatus.ENDED && blockEntity.currentPlayerId != null) {
            HolologPlayer.stop(blockEntity.currentPlayerId);
            blockEntity.currentPlayerId = null;
        }
    }

    public void cleanup() {
        if (this.currentPlayerId != null) {
            HolologPlayer.stop(this.currentPlayerId);
            this.currentPlayerId = null;
        }
    }

    public void m_7651_() {
        super.m_7651_();
        this.cleanup();
    }

    public ResourceLocation getHolologId() {
        return this.holologId != null ? this.holologId : DEFAULT_HOLOLOG;
    }

    public void setHolologId(ResourceLocation holologId) {
        log.debug("Setting hololog ID for HoloCube at {} to: {}", (Object)this.f_58858_, (Object)holologId);
        this.holologId = holologId;
        this.m_6596_();
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public void setPlayerUUID(UUID playerUUID) {
        this.playerUUID = playerUUID;
        this.m_6596_();
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_(HOLOLOG_ID_TAG)) {
            try {
                this.holologId = new ResourceLocation(tag.m_128461_(HOLOLOG_ID_TAG));
            }
            catch (Exception e) {
                log.warn("Failed to load hololog ID from NBT: {}", (Object)e.getMessage());
                this.holologId = DEFAULT_HOLOLOG;
            }
        }
        if (tag.m_128441_(PLAYER_UUID_TAG)) {
            this.playerUUID = tag.m_128342_(PLAYER_UUID_TAG);
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.holologId != null) {
            tag.m_128359_(HOLOLOG_ID_TAG, this.holologId.toString());
        }
        if (this.playerUUID != null) {
            tag.m_128362_(PLAYER_UUID_TAG, this.playerUUID);
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    private void syncToClient() {
        Level currentLevel = this.f_58857_;
        if (currentLevel != null && !currentLevel.f_46443_) {
            currentLevel.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void m_6596_() {
        super.m_6596_();
        this.syncToClient();
    }
}

