/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.block.hololog;

import de.markusbordihn.scraptechworkshop.block.entity.HoloCubeBlockEntity;
import de.markusbordihn.scraptechworkshop.data.hololog.HolologStatus;
import de.markusbordihn.scraptechworkshop.item.hololog.HoloCubeItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HoloCubeBlock
extends BaseEntityBlock {
    public static final String ID = "holocube";
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<HolologStatus> STATUS = EnumProperty.m_61587_((String)"status", HolologStatus.class);
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");
    private static final VoxelShape SHAPE = Shapes.m_83048_((double)0.3125, (double)0.0, (double)0.3125, (double)0.6875, (double)0.375, (double)0.6875);

    public HoloCubeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(STATUS, (Comparable)((Object)HolologStatus.READY)));
    }

    public static void updateStatus(Level level, BlockPos pos, HolologStatus newStatus) {
        BlockState currentState = level.m_8055_(pos);
        if (currentState.m_60734_() instanceof HoloCubeBlock && currentState.m_61143_(STATUS) != newStatus) {
            level.m_7731_(pos, (BlockState)currentState.m_61124_(STATUS, (Comparable)((Object)newStatus)), 3);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, STATUS});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new HoloCubeBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return level.f_46443_ ? HoloCubeBlock.m_152132_(type, HoloCubeBlockEntity.TYPE, HoloCubeBlockEntity::tick) : null;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        log.debug("HoloCube used at {} by player {}", (Object)pos, (Object)player.m_7755_().getString());
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof HoloCubeBlockEntity)) {
            log.warn("No HoloCubeBlockEntity found at {}", (Object)pos);
            return InteractionResult.FAIL;
        }
        HoloCubeBlockEntity blockEntity2 = (HoloCubeBlockEntity)blockEntity;
        ResourceLocation holologId = blockEntity2.getHolologId();
        log.debug("HoloCube at {} has hololog ID: {}", (Object)pos, (Object)holologId);
        if (holologId == null) {
            player.m_5661_((Component)Component.m_237113_((String)"No hololog data found!"), true);
            log.warn("HoloCube at {} has no hololog ID!", (Object)pos);
            return InteractionResult.FAIL;
        }
        log.debug("HoloCube interaction - hololog ID: {}", (Object)holologId);
        HolologStatus currentStatus = (HolologStatus)((Object)state.m_61143_(STATUS));
        HolologStatus newStatus = currentStatus.cycle();
        log.debug("Changing HoloCube status from {} to {} at {}", (Object)currentStatus, (Object)newStatus, (Object)pos);
        level.m_7731_(pos, (BlockState)state.m_61124_(STATUS, (Comparable)((Object)newStatus)), 3);
        return InteractionResult.SUCCESS;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_(STATUS, (Comparable)((Object)HolologStatus.READY));
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity;
            if (level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof HoloCubeBlockEntity) {
                HoloCubeBlockEntity blockEntity2 = (HoloCubeBlockEntity)blockEntity;
                blockEntity2.cleanup();
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof HoloCubeBlockEntity) {
            HoloCubeBlockEntity blockEntity2 = (HoloCubeBlockEntity)blockEntity;
            ResourceLocation holologId = HoloCubeItem.getHolologId(stack);
            log.debug("Placing HoloCube at {} with hololog ID from ItemStack: {}", (Object)pos, (Object)holologId);
            if (holologId != null) {
                blockEntity2.setHolologId(holologId);
                log.info("HoloCube placed at {} with hololog: {}", (Object)pos, (Object)holologId);
            } else {
                log.warn("HoloCube placed at {} but ItemStack has no hololog ID!", (Object)pos);
            }
        }
    }
}

