/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.client.hololog;

import de.markusbordihn.scraptechworkshop.data.hololog.HolologData;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.FastColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joml.Vector3f;

public class HolologPlayer {
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");
    private static final Map<UUID, HolologPlayer> ACTIVE_PLAYERS = new HashMap<UUID, HolologPlayer>();
    private final HolologData hololog;
    private final PlaybackContext context;
    private final Consumer<String> textDisplay;
    private final Runnable onComplete;
    private PlaybackState state = PlaybackState.STOPPED;
    private int currentTick = 0;
    private int currentLine = 0;
    private boolean endEffectsPlayed = false;

    private HolologPlayer(HolologData hololog, PlaybackContext context, Consumer<String> textDisplay, Runnable onComplete) {
        this.hololog = hololog;
        this.context = context;
        this.textDisplay = textDisplay;
        this.onComplete = onComplete;
    }

    public static UUID play(HolologData hololog, PlaybackContext context, Consumer<String> textDisplay) {
        return HolologPlayer.play(hololog, context, textDisplay, null);
    }

    public static UUID play(HolologData hololog, PlaybackContext context, Consumer<String> textDisplay, Runnable onComplete) {
        log.info("Starting hololog playback: {}", (Object)hololog.id());
        UUID id = UUID.randomUUID();
        HolologPlayer player = new HolologPlayer(hololog, context, textDisplay, onComplete);
        ACTIVE_PLAYERS.put(id, player);
        player.start();
        return id;
    }

    public static void stop(UUID id) {
        HolologPlayer player = ACTIVE_PLAYERS.remove(id);
        if (player != null) {
            player.state = PlaybackState.STOPPED;
        }
    }

    public static void pause(UUID id) {
        HolologPlayer player = ACTIVE_PLAYERS.get(id);
        if (player != null && player.state == PlaybackState.PLAYING) {
            player.state = PlaybackState.PAUSED;
        }
    }

    public static void resume(UUID id) {
        HolologPlayer player = ACTIVE_PLAYERS.get(id);
        if (player != null && player.state == PlaybackState.PAUSED) {
            player.state = PlaybackState.PLAYING;
        }
    }

    public static int getCurrentLine(ResourceLocation holologId) {
        for (HolologPlayer player : ACTIVE_PLAYERS.values()) {
            if (!player.hololog.id().equals((Object)holologId)) continue;
            return player.currentLine;
        }
        return -1;
    }

    public static void stopAll() {
        for (HolologPlayer player : ACTIVE_PLAYERS.values()) {
            player.state = PlaybackState.STOPPED;
        }
        ACTIVE_PLAYERS.clear();
    }

    public static void tickAll() {
        ACTIVE_PLAYERS.values().removeIf(player -> {
            if (player.state == PlaybackState.PLAYING) {
                player.tick();
            }
            return player.state == PlaybackState.STOPPED && player.endEffectsPlayed;
        });
    }

    private void start() {
        this.state = PlaybackState.PLAYING;
        this.currentTick = 0;
        this.currentLine = 0;
        this.endEffectsPlayed = false;
        this.playEffects(this.hololog.start());
        if (this.textDisplay != null) {
            Object titleText = Component.m_237113_((String)this.hololog.title()).getString();
            if (!this.hololog.subtitle().isEmpty()) {
                titleText = (String)titleText + " - " + this.hololog.subtitle();
            }
            this.textDisplay.accept((String)titleText);
        }
    }

    private void tick() {
        if (this.state != PlaybackState.PLAYING) {
            return;
        }
        Level level = this.context.getLevel();
        if (level == null || !(level instanceof ClientLevel)) {
            this.state = PlaybackState.STOPPED;
            return;
        }
        ++this.currentTick;
        if (this.currentLine < this.hololog.lines().size()) {
            HolologData.HolologLine line = this.hololog.lines().get(this.currentLine);
            if (this.currentTick % this.hololog.lineDelayTicks() == 0) {
                if (this.textDisplay != null) {
                    this.textDisplay.accept(line.text());
                }
                this.playEffects(line.effects());
                ++this.currentLine;
            }
        }
        if (this.currentLine >= this.hololog.lines().size()) {
            if (!this.endEffectsPlayed) {
                this.playEffects(this.hololog.end());
                this.endEffectsPlayed = true;
                if (this.onComplete != null) {
                    log.info("Hololog playback completed: {}", (Object)this.hololog.id());
                    this.onComplete.run();
                }
            }
            this.state = PlaybackState.STOPPED;
        }
    }

    private void playEffects(HolologData.HolologEffects effects) {
        if (!(this.context.getLevel() instanceof ClientLevel)) {
            return;
        }
        Vec3 effectPos = this.context.getEffectPosition();
        for (HolologData.HolologSound sound : effects.sfx()) {
            this.context.playSound(sound.id(), sound.volume(), sound.pitch());
        }
        for (HolologData.HolologParticle particle : effects.fx()) {
            this.spawnParticles(particle, effectPos);
        }
    }

    private void spawnParticles(HolologData.HolologParticle particle, Vec3 pos) {
        ParticleOptions particleType = this.getParticleType(particle);
        for (int i = 0; i < particle.count(); ++i) {
            Vec3 spawnPos = pos.m_82520_((Math.random() - 0.5) * 0.5, (Math.random() - 0.5) * 0.5, (Math.random() - 0.5) * 0.5);
            this.context.spawnParticle(particleType, spawnPos, new Vec3((Math.random() - 0.5) * 0.02, Math.random() * 0.05, (Math.random() - 0.5) * 0.02));
        }
    }

    private ParticleOptions getParticleType(HolologData.HolologParticle particle) {
        String particleId = particle.id().m_135815_();
        if (particleId.equals("dust") && particle.color() != null) {
            Vector3f color = this.parseColor(particle.color());
            return new DustParticleOptions(color, particle.scale());
        }
        return switch (particleId) {
            case "smoke" -> ParticleTypes.f_123762_;
            case "portal" -> ParticleTypes.f_123760_;
            case "crit" -> ParticleTypes.f_123797_;
            case "flash" -> ParticleTypes.f_123747_;
            default -> ParticleTypes.f_123810_;
        };
    }

    private Vector3f parseColor(String hexColor) {
        try {
            int color = Integer.parseInt(hexColor.replace("#", ""), 16);
            float r = (float)FastColor.ARGB32.m_13665_((int)(color | 0xFF000000)) / 255.0f;
            float g = (float)FastColor.ARGB32.m_13667_((int)(color | 0xFF000000)) / 255.0f;
            float b = (float)FastColor.ARGB32.m_13669_((int)(color | 0xFF000000)) / 255.0f;
            return new Vector3f(r, g, b);
        }
        catch (NumberFormatException e) {
            return new Vector3f(1.0f, 1.0f, 1.0f);
        }
    }

    public float getProgress() {
        if (this.hololog.lines().isEmpty()) {
            return 1.0f;
        }
        return (float)this.currentLine / (float)this.hololog.lines().size();
    }

    public boolean isActive() {
        return this.state != PlaybackState.STOPPED;
    }

    private static enum PlaybackState {
        STOPPED,
        PLAYING,
        PAUSED;

    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface PlaybackContext {
        public Level getLevel();

        public Vec3 getEffectPosition();

        default public void spawnParticle(ParticleOptions particle, Vec3 pos, Vec3 speed) {
            Level level = this.getLevel();
            if (level instanceof ClientLevel) {
                ClientLevel clientLevel = (ClientLevel)level;
                clientLevel.m_7106_(particle, pos.f_82479_, pos.f_82480_, pos.f_82481_, speed.f_82479_, speed.f_82480_, speed.f_82481_);
            }
        }

        default public void playSound(ResourceLocation soundId, float volume, float pitch) {
            SoundEvent sound = SoundEvent.m_262824_((ResourceLocation)soundId);
            Vec3 pos = this.getEffectPosition();
            this.getLevel().m_7785_(pos.f_82479_, pos.f_82480_, pos.f_82481_, sound, SoundSource.BLOCKS, volume, pitch, false);
        }
    }

    public record UIContext(Level level, Vec3 position) implements PlaybackContext
    {
        @Override
        public Level getLevel() {
            return this.level;
        }

        @Override
        public Vec3 getEffectPosition() {
            return this.position;
        }
    }

    public record WorldContext(Level level, BlockPos blockPos) implements PlaybackContext
    {
        @Override
        public Level getLevel() {
            return this.level;
        }

        @Override
        public Vec3 getEffectPosition() {
            return Vec3.m_82512_((Vec3i)this.blockPos).m_82520_(0.0, 0.75, 0.0);
        }
    }
}

