/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.data.holocube;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;

public record HoloCubePlayerData(UUID playerUUID, ResourceLocation holologId, long receivedTimestamp, Optional<BlockPos> placedAt, Optional<Long> playedTimestamp) {
    public static final Codec<HoloCubePlayerData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.xmap(UUID::fromString, UUID::toString).fieldOf("playerUUID").forGetter(HoloCubePlayerData::playerUUID), (App)ResourceLocation.f_135803_.fieldOf("holologId").forGetter(HoloCubePlayerData::holologId), (App)Codec.LONG.fieldOf("receivedTimestamp").forGetter(HoloCubePlayerData::receivedTimestamp), (App)BlockPos.f_121852_.optionalFieldOf("placedAt").forGetter(HoloCubePlayerData::placedAt), (App)Codec.LONG.optionalFieldOf("playedTimestamp").forGetter(HoloCubePlayerData::playedTimestamp)).apply((Applicative)instance, HoloCubePlayerData::new));

    public static HoloCubePlayerData create(UUID playerUUID, ResourceLocation holologId) {
        return new HoloCubePlayerData(playerUUID, holologId, System.currentTimeMillis(), Optional.empty(), Optional.empty());
    }

    public HoloCubePlayerData withPlacedAt(BlockPos pos) {
        return new HoloCubePlayerData(this.playerUUID, this.holologId, this.receivedTimestamp, Optional.of(pos), this.playedTimestamp);
    }

    public HoloCubePlayerData withPlayedTimestamp(long timestamp) {
        return new HoloCubePlayerData(this.playerUUID, this.holologId, this.receivedTimestamp, this.placedAt, Optional.of(timestamp));
    }

    public boolean hasBeenPlayed() {
        return this.playedTimestamp.isPresent();
    }
}

