/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.data.hololog;

import java.util.List;
import net.minecraft.resources.ResourceLocation;

public record HolologData(ResourceLocation id, String title, String subtitle, String titleColor, String subtitleColor, int lineDelayTicks, int charDelayTicks, ResourceLocation voiceOver, HolologDisplayEntity displayEntity, HolologEffects start, List<HolologLine> lines, HolologEffects end) {
    public boolean hasVoiceOver() {
        return this.voiceOver != null;
    }

    public int getTotalTicks() {
        return this.lines.size() * this.lineDelayTicks;
    }

    public record HolologDisplayEntity(DisplayType type, ResourceLocation id, float scale, float rotationSpeed) {
        public static final HolologDisplayEntity DEFAULT_VILLAGER = new HolologDisplayEntity(DisplayType.ENTITY, new ResourceLocation("minecraft", "villager"), 0.5f, 1.0f);

        public HolologDisplayEntity(DisplayType type, ResourceLocation id) {
            this(type, id, 0.5f, 1.0f);
        }
    }

    public record HolologEffects(List<HolologSound> sfx, List<HolologParticle> fx) {
        public static final HolologEffects EMPTY = new HolologEffects(List.of(), List.of());
    }

    public record HolologLine(String text, HolologDisplayEntity displayEntity, HolologEffects effects) {
        public HolologLine(String text) {
            this(text, null, HolologEffects.EMPTY);
        }

        public HolologLine(String text, HolologEffects effects) {
            this(text, null, effects);
        }
    }

    public record HolologParticle(ResourceLocation id, int count, String color, float scale) {
        public HolologParticle(ResourceLocation id) {
            this(id, 5, null, 1.0f);
        }

        public HolologParticle(ResourceLocation id, int count) {
            this(id, count, null, 1.0f);
        }
    }

    public record HolologSound(ResourceLocation id, float volume, float pitch) {
        public HolologSound(ResourceLocation id) {
            this(id, 1.0f, 1.0f);
        }
    }

    public static enum DisplayType {
        ENTITY,
        BLOCK,
        ITEM;

    }
}

