/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.saveddata;

import com.mojang.serialization.DynamicOps;
import de.markusbordihn.scraptechworkshop.data.holocube.HoloCubePlayerData;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HoloCubeStorage
extends SavedData {
    public static final String DATA_NAME = "scrap_tech_workshop_holocubes";
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");
    private static final String HOLOCUBES_TAG = "HoloCubes";
    private static HoloCubeStorage instance;
    private final List<HoloCubePlayerData> holoCubeList;

    public HoloCubeStorage(List<HoloCubePlayerData> holoCubes) {
        log.info("Creating new HoloCubeStorage with {} entries", (Object)holoCubes.size());
        this.holoCubeList = new ArrayList<HoloCubePlayerData>(holoCubes);
    }

    public HoloCubeStorage() {
        this(new ArrayList<HoloCubePlayerData>());
    }

    public static void init(ServerLevel serverLevel) {
        if (serverLevel == null) {
            log.error("Cannot initialize HoloCubeStorage without a valid level!");
            return;
        }
        log.info("Initializing HoloCubeStorage with level: {}", (Object)serverLevel);
        instance = HoloCubeStorage.get(serverLevel);
    }

    public static HoloCubeStorage get() {
        if (instance == null) {
            throw new IllegalStateException("HoloCubeStorage is not initialized!");
        }
        return instance;
    }

    public static HoloCubeStorage get(ServerLevel level) {
        if (instance == null) {
            instance = (HoloCubeStorage)level.m_8895_().m_164861_(HoloCubeStorage::load, HoloCubeStorage::new, DATA_NAME);
        }
        return instance;
    }

    public static HoloCubeStorage load(CompoundTag compoundTag) {
        List loadedData = HoloCubePlayerData.CODEC.listOf().parse((DynamicOps)NbtOps.f_128958_, (Object)compoundTag.m_128423_(HOLOCUBES_TAG)).resultOrPartial(error -> log.error("Failed to decode holocube data: {}", error)).orElse(new ArrayList());
        return new HoloCubeStorage(loadedData);
    }

    public static void clearInstance() {
        log.info("Clearing HoloCubeStorage instance");
        instance = null;
    }

    public boolean hasReceivedHoloCube(UUID playerUUID, ResourceLocation holologId) {
        return this.holoCubeList.stream().anyMatch(data -> data.playerUUID().equals(playerUUID) && data.holologId().equals((Object)holologId));
    }

    public void addHoloCube(HoloCubePlayerData data) {
        if (data == null) {
            log.warn("Cannot add null holocube data");
            return;
        }
        this.holoCubeList.add(data);
        log.info("Added holocube {} for player {} at {}", (Object)data.holologId(), (Object)data.playerUUID(), (Object)data.receivedTimestamp());
        this.m_77762_();
    }

    public void updateHoloCube(HoloCubePlayerData updatedData) {
        if (updatedData == null) {
            log.warn("Cannot update with null holocube data");
            return;
        }
        for (int i = 0; i < this.holoCubeList.size(); ++i) {
            HoloCubePlayerData data = this.holoCubeList.get(i);
            if (!data.playerUUID().equals(updatedData.playerUUID()) || !data.holologId().equals((Object)updatedData.holologId())) continue;
            this.holoCubeList.set(i, updatedData);
            log.info("Updated holocube {} for player {}", (Object)updatedData.holologId(), (Object)updatedData.playerUUID());
            this.m_77762_();
            return;
        }
        log.warn("Holocube not found for update: {} for player {}", (Object)updatedData.holologId(), (Object)updatedData.playerUUID());
    }

    public Optional<HoloCubePlayerData> getHoloCubeData(UUID playerUUID, ResourceLocation holologId) {
        return this.holoCubeList.stream().filter(data -> data.playerUUID().equals(playerUUID) && data.holologId().equals((Object)holologId)).findFirst();
    }

    public List<HoloCubePlayerData> getPlayerHoloCubes(UUID playerUUID) {
        return this.holoCubeList.stream().filter(data -> data.playerUUID().equals(playerUUID)).toList();
    }

    public List<HoloCubePlayerData> getAllHoloCubes() {
        return new ArrayList<HoloCubePlayerData>(this.holoCubeList);
    }

    public void clear() {
        this.holoCubeList.clear();
        log.info("Cleared all holocube data");
        this.m_77762_();
    }

    public CompoundTag m_7176_(CompoundTag compoundTag) {
        HoloCubePlayerData.CODEC.listOf().encodeStart((DynamicOps)NbtOps.f_128958_, this.holoCubeList).resultOrPartial(error -> log.error("Failed to encode holocube data: {}", error)).ifPresent(tag -> compoundTag.m_128365_(HOLOCUBES_TAG, tag));
        return compoundTag;
    }
}

