/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.client;

import de.markusbordihn.scraptechworkshop.data.hololog.HoloLogManager;
import de.markusbordihn.scraptechworkshop.item.ItemPropertyFunctions;
import de.markusbordihn.scraptechworkshop.item.ModItems;
import de.markusbordihn.scraptechworkshop.item.hololog.HoloPadItem;
import de.markusbordihn.scraptechworkshop.registry.item.hololog.HoloLogItemRegistry;
import de.markusbordihn.scraptechworkshop.utils.ColorUtils;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="scrap_tech_workshop", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
class ClientModEventHandler {
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");

    ClientModEventHandler() {
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ItemProperties.register((Item)ModItems.SCRAP_FISHING_ROD.get(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"cast"), ItemPropertyFunctions::getFishingRodCastValue);
            ItemProperties.register((Item)ModItems.MAGNET_FISHING_ROD.get(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"cast"), ItemPropertyFunctions::getFishingRodCastValue);
        });
    }

    @SubscribeEvent
    public static void onRegisterReloadListeners(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((preparationBarrier, resourceManager, profilerFiller, profilerFiller2, executor, executor2) -> preparationBarrier.m_6769_(new Object()).thenRunAsync(() -> {
            log.info("Reloading holologs after resource pack change...");
            HoloLogManager.clearCache();
        }, executor2));
    }

    @SubscribeEvent
    public static void onRegisterItemColors(RegisterColorHandlersEvent.Item event) {
        log.info("{} Item Colors for HoloPads ...", (Object)"Register Scrap Tech Workshop");
        for (HoloPadItem item : HoloLogItemRegistry.getHoloPadItems().values()) {
            event.register((stack, tintIndex) -> {
                Item patt4773$temp;
                if (tintIndex == 0 && (patt4773$temp = stack.m_41720_()) instanceof HoloPadItem) {
                    HoloPadItem holoPad = (HoloPadItem)patt4773$temp;
                    return HoloLogManager.loadHoloLog(holoPad.getHoloLogId()).map(data -> ColorUtils.parseHexColor(data.color())).orElse(65535);
                }
                return 0xFFFFFF;
            }, new ItemLike[]{item});
        }
    }
}

