/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.markusbordihn.scraptechworkshop.block.entity.HoloCubeBlockEntity;
import de.markusbordihn.scraptechworkshop.block.hololog.HoloCubeBlock;
import de.markusbordihn.scraptechworkshop.client.renderer.hololog.HoloLogBlockPlayer;
import de.markusbordihn.scraptechworkshop.data.hololog.DisplayType;
import de.markusbordihn.scraptechworkshop.data.hololog.HoloLogDisplayEntity;
import de.markusbordihn.scraptechworkshop.data.hololog.HoloLogStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HoloCubeBlockEntityRenderer<T extends HoloCubeBlockEntity>
implements BlockEntityRenderer<T> {
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");
    private static final double HOLOGRAM_CENTER_X = 0.5;
    private static final double HOLOGRAM_CENTER_Z = 0.5;
    private static final double HOLOGRAM_Y_OFFSET_ITEM = 0.7;
    private static final double HOLOGRAM_Y_OFFSET_BLOCK = 0.8;
    private static final double HOLOGRAM_Y_OFFSET_DEFAULT = 0.5;
    private static final float BLOCK_SCALE_MULTIPLIER = 0.6f;
    private static final float ENTITY_SCALE_MULTIPLIER = 0.8f;
    private static final float ENTITY_HEAD_BOB_SPEED = 0.1f;
    private static final float ENTITY_HEAD_BOB_AMOUNT = 3.0f;
    private static final int RENDER_DISTANCE = 32;

    public HoloCubeBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(T blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        if (blockEntity.m_58900_().m_61143_(HoloCubeBlock.STATUS) != HoloLogStatus.PLAYING) {
            return;
        }
        HoloLogBlockPlayer player = ((HoloCubeBlockEntity)((Object)blockEntity)).getPlayer();
        if (player == null || !player.isPlaying()) {
            return;
        }
        HoloLogDisplayEntity displayEntity = player.getCurrentDisplayEntity();
        if (displayEntity == null) {
            displayEntity = HoloLogDisplayEntity.DEFAULT_VILLAGER;
        }
        try {
            poseStack.m_85836_();
            this.prepareHologramPose(blockEntity, displayEntity, poseStack);
            player.renderDisplayEntity(poseStack, buffer, displayEntity, partialTicks, combinedLight);
            poseStack.m_85849_();
        }
        catch (Exception e) {
            log.error("Failed to render hologram display {} for block entity at {}: {}", (Object)displayEntity.id(), (Object)blockEntity.m_58899_(), (Object)e.getMessage());
        }
    }

    private void prepareHologramPose(T blockEntity, HoloLogDisplayEntity displayEntity, PoseStack poseStack) {
        double yOffset;
        double d = displayEntity.type() == DisplayType.ITEM ? 0.7 : (yOffset = displayEntity.type() == DisplayType.BLOCK ? 0.8 : 0.5);
        if (displayEntity.type() == DisplayType.BLOCK) {
            poseStack.m_85837_(0.5, yOffset, 0.5);
            float scale = displayEntity.scale() * 0.6f;
            poseStack.m_85841_(scale, scale, scale);
            Level level = blockEntity.m_58904_();
            if (level != null && displayEntity.rotationSpeed() > 0.0f) {
                float time = level.m_46467_();
                float rotationSpeed = displayEntity.rotationSpeed();
                poseStack.m_252781_(Axis.f_252436_.m_252977_(time * rotationSpeed));
            }
            poseStack.m_85837_(-0.5, -0.5, -0.5);
        } else {
            poseStack.m_85837_(0.5, yOffset, 0.5);
        }
        if (displayEntity.type() == DisplayType.ENTITY || displayEntity.type() == DisplayType.HOLO_ENTITY) {
            boolean hasCustomRotation = false;
            if (displayEntity.type() == DisplayType.HOLO_ENTITY) {
                boolean bl = hasCustomRotation = displayEntity.rotationX() != 0.0f || displayEntity.rotationY() != 0.0f || displayEntity.rotationZ() != 0.0f;
            }
            if (!hasCustomRotation) {
                Minecraft minecraft = Minecraft.m_91087_();
                if (minecraft.f_91074_ != null) {
                    Vec3 blockCenter = Vec3.m_82512_((Vec3i)blockEntity.m_58899_()).m_82520_(0.0, yOffset, 0.0);
                    Vec3 playerPos = minecraft.f_91074_.m_146892_();
                    Vec3 lookDir = playerPos.m_82546_(blockCenter).m_82541_();
                    float yaw = (float)Math.toDegrees(Math.atan2(lookDir.f_82479_, lookDir.f_82481_));
                    poseStack.m_252781_(Axis.f_252436_.m_252977_(yaw));
                    Level level = blockEntity.m_58904_();
                    if (level != null) {
                        float time = (float)level.m_46467_() + (float)minecraft.m_261169_() / 1.0E9f;
                        float headBob = (float)Math.sin(time * 0.1f) * 3.0f;
                        poseStack.m_252781_(Axis.f_252529_.m_252977_(headBob));
                    }
                }
            } else {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(displayEntity.rotationX()));
                poseStack.m_252781_(Axis.f_252436_.m_252977_(displayEntity.rotationY()));
                poseStack.m_252781_(Axis.f_252403_.m_252977_(displayEntity.rotationZ()));
            }
            float scale = displayEntity.scale() * 0.8f;
            poseStack.m_85841_(scale, scale, scale);
        } else if (displayEntity.type() == DisplayType.ITEM) {
            Level level = blockEntity.m_58904_();
            if (level != null && displayEntity.rotationSpeed() > 0.0f) {
                float time = level.m_46467_();
                float rotationSpeed = displayEntity.rotationSpeed();
                poseStack.m_252781_(Axis.f_252436_.m_252977_(time * rotationSpeed));
            }
            float scale = displayEntity.scale();
            poseStack.m_85841_(scale, scale, scale);
        }
    }

    public int m_142163_() {
        return 32;
    }
}

