/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import de.markusbordihn.scraptechworkshop.client.screen.BaseContainerScreen;
import de.markusbordihn.scraptechworkshop.menu.CollectorStationMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class CollectorStationScreen
extends BaseContainerScreen<CollectorStationMenu> {
    private static final String TRANSLATION_KEY_PREFIX = "gui.scrap_tech_workshop.collector_station.";
    private static final String TRANSLATION_STATUS_READY = "gui.scrap_tech_workshop.collector_station.status.ready";
    private static final String TRANSLATION_STATUS_COLLECTING = "gui.scrap_tech_workshop.collector_station.status.collecting";
    private static final String TRANSLATION_STATUS_RETURNING = "gui.scrap_tech_workshop.collector_station.status.returning";
    private static final String TRANSLATION_STATUS_PROCESSING = "gui.scrap_tech_workshop.collector_station.status.processing";
    private static final String TRANSLATION_STATUS_CHARGING = "gui.scrap_tech_workshop.collector_station.status.charging";
    private static final String TRANSLATION_STATUS_NO_POWER = "gui.scrap_tech_workshop.collector_station.status.no_power";
    private static final ResourceLocation TEXTURE = new ResourceLocation("scrap_tech_workshop", "textures/gui/collector_station.png");
    private static final int SCREEN_WIDTH = 176;
    private static final int SCREEN_HEIGHT = 220;
    private static final int ENERGY_BAR_WIDTH = 14;
    private static final int ENERGY_BAR_HEIGHT = 50;
    private static final int ENERGY_BAR_TEXTURE_X = 176;
    private static final int ENERGY_BAR_TEXTURE_Y = 0;
    private static final int PROGRESS_BAR_WIDTH = 100;
    private static final int PROGRESS_BAR_HEIGHT = 14;
    private static final int PROGRESS_BAR_TEXTURE_X = 176;
    private static final int PROGRESS_BAR_TEXTURE_Y = 50;
    private static final int PROGRESS_TEXT_Y = 114;
    private static final int MAX_ENERGY = 5000;

    public CollectorStationScreen(CollectorStationMenu menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title);
        this.f_97726_ = 176;
        this.f_97727_ = 220;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_97728_ = (this.f_97726_ - this.f_96547_.m_92852_((FormattedText)this.f_96539_)) / 2;
        this.f_97731_ = this.f_97727_ - 94;
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int x = this.f_97735_;
        int y = this.f_97736_;
        this.renderDefaultBackground(guiGraphics, x, y, this.f_97726_, this.f_97727_);
        this.renderSlot(guiGraphics, x + 8, y + 18);
        this.renderSlots(guiGraphics, x + 30 + 2, y + 18, 6, 4);
        for (int i = 0; i < 4; ++i) {
            this.renderSlot(guiGraphics, x + 150 + 2, y + 18 + i * 18);
        }
        this.renderPlayerInventoryAt(guiGraphics, x, y, 139, 197);
        int energyBarX = x + 9;
        int energyBarY = y + 38;
        guiGraphics.m_280509_(energyBarX - 1, energyBarY - 1, energyBarX + 14 + 1, energyBarY + 50 + 1, -7631989);
        int progressBarX = x + 39;
        int progressBarY = y + 96;
        guiGraphics.m_280509_(progressBarX - 1, progressBarY - 1, progressBarX + 100 + 1, progressBarY + 14 + 1, -7631989);
        this.renderEnergyBar(guiGraphics, x, y);
        this.renderProgressBar(guiGraphics, x, y);
    }

    private void renderEnergyBar(GuiGraphics guiGraphics, int x, int y) {
        int energy = ((CollectorStationMenu)this.f_97732_).getCurrentEnergy();
        int maxEnergy = 5000;
        int energyBarX = x + 9;
        int energyBarY = y + 38;
        guiGraphics.m_280509_(energyBarX, energyBarY, energyBarX + 14, energyBarY + 50, -11184811);
        if (energy > 0) {
            int energyBarHeight = (int)((float)energy / (float)maxEnergy * 50.0f);
            guiGraphics.m_280509_(energyBarX, energyBarY + (50 - energyBarHeight), energyBarX + 14, energyBarY + 50, -16711936);
        }
        int percentage = energy * 100 / maxEnergy;
        String energyText = percentage + "%";
        int textX = energyBarX + 7 - this.f_96547_.m_92895_(energyText) / 2 + 1;
        int textY = energyBarY + 50 + 3;
        guiGraphics.m_280056_(this.f_96547_, energyText, textX, textY, 0x55FF55, false);
    }

    private void renderProgressBar(GuiGraphics guiGraphics, int x, int y) {
        int progress = ((CollectorStationMenu)this.f_97732_).getCollectionProgress();
        int maxProgress = ((CollectorStationMenu)this.f_97732_).getMaxCollectionTime();
        int progressBarX = x + 39;
        int progressBarY = y + 96;
        guiGraphics.m_280509_(progressBarX, progressBarY, progressBarX + 100, progressBarY + 14, -11184811);
        if (maxProgress > 0 && progress > 0) {
            int progressBarWidth = (int)((float)progress / (float)maxProgress * 100.0f);
            guiGraphics.m_280509_(progressBarX, progressBarY, progressBarX + progressBarWidth, progressBarY + 14, -22016);
        }
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.m_280614_(this.f_96547_, this.f_96539_, this.f_97728_, this.f_97729_, 0x404040, false);
        guiGraphics.m_280614_(this.f_96547_, this.f_169604_, this.f_97730_, this.f_97731_, 0x404040, false);
        int status = ((CollectorStationMenu)this.f_97732_).getStatus();
        int stateTimer = ((CollectorStationMenu)this.f_97732_).getStateTimer();
        int maxTime = ((CollectorStationMenu)this.f_97732_).getMaxCollectionTime();
        MutableComponent statusText = switch (status) {
            case 0 -> Component.m_237115_((String)TRANSLATION_STATUS_READY);
            case 1 -> {
                int percentage;
                if (maxTime > 0 && stateTimer >= 0) {
                    percentage = stateTimer * 100 / maxTime;
                    yield Component.m_237110_((String)TRANSLATION_STATUS_COLLECTING, (Object[])new Object[]{percentage});
                }
                yield Component.m_237110_((String)TRANSLATION_STATUS_COLLECTING, (Object[])new Object[]{0});
            }
            case 2 -> {
                int percentage;
                if (maxTime > 0 && stateTimer >= 0) {
                    percentage = stateTimer * 100 / maxTime;
                    yield Component.m_237110_((String)TRANSLATION_STATUS_RETURNING, (Object[])new Object[]{percentage});
                }
                yield Component.m_237110_((String)TRANSLATION_STATUS_RETURNING, (Object[])new Object[]{0});
            }
            case 3 -> {
                int percentage;
                if (maxTime > 0 && stateTimer >= 0) {
                    percentage = stateTimer * 100 / maxTime;
                    yield Component.m_237110_((String)TRANSLATION_STATUS_PROCESSING, (Object[])new Object[]{percentage});
                }
                yield Component.m_237110_((String)TRANSLATION_STATUS_PROCESSING, (Object[])new Object[]{0});
            }
            case 4 -> {
                int percentage;
                if (maxTime > 0 && stateTimer >= 0) {
                    percentage = stateTimer * 100 / maxTime;
                    yield Component.m_237110_((String)TRANSLATION_STATUS_CHARGING, (Object[])new Object[]{percentage});
                }
                yield Component.m_237110_((String)TRANSLATION_STATUS_CHARGING, (Object[])new Object[]{0});
            }
            case 5 -> Component.m_237115_((String)TRANSLATION_STATUS_NO_POWER);
            default -> Component.m_237115_((String)TRANSLATION_STATUS_READY);
        };
        int textX = 39 - this.f_96547_.m_92852_((FormattedText)statusText) / 2 + 50;
        guiGraphics.m_280614_(this.f_96547_, (Component)statusText, textX, 114, 0x404040, false);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    protected void m_280072_(GuiGraphics guiGraphics, int x, int y) {
        int percentage;
        super.m_280072_(guiGraphics, x, y);
        int relativeX = x - this.f_97735_;
        int relativeY = y - this.f_97736_;
        if (relativeX >= 9 && relativeX <= 23 && relativeY >= 38 && relativeY <= 88) {
            int currentEnergy = ((CollectorStationMenu)this.f_97732_).getCurrentEnergy();
            int maxEnergy = 5000;
            percentage = maxEnergy > 0 ? currentEnergy * 100 / maxEnergy : 0;
            MutableComponent tooltip = Component.m_237113_((String)String.format("Energy: %d / %d (%d%%)", currentEnergy, maxEnergy, percentage));
            guiGraphics.m_280557_(this.f_96547_, (Component)tooltip, x, y);
        }
        if (relativeX >= 39 && relativeX <= 139 && relativeY >= 96 && relativeY <= 110) {
            int progress = ((CollectorStationMenu)this.f_97732_).getCollectionProgress();
            int maxProgress = ((CollectorStationMenu)this.f_97732_).getMaxCollectionTime();
            percentage = maxProgress > 0 ? progress * 100 / maxProgress : 0;
            String statusName = this.getStatusName(((CollectorStationMenu)this.f_97732_).getStatus());
            MutableComponent tooltip = Component.m_237113_((String)String.format("%s: %d%%", statusName, percentage));
            guiGraphics.m_280557_(this.f_96547_, (Component)tooltip, x, y);
        }
    }

    private String getStatusName(int status) {
        return switch (status) {
            case 0 -> "Ready";
            case 1 -> "Collecting";
            case 2 -> "Returning";
            case 3 -> "Processing";
            case 4 -> "Charging";
            case 5 -> "No Power";
            default -> "Unknown";
        };
    }
}

