/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.menu;

import de.markusbordihn.scraptechworkshop.block.entity.CollectorStationBlockEntity;
import de.markusbordihn.scraptechworkshop.config.CollectorStationConfig;
import de.markusbordihn.scraptechworkshop.item.component.EnergyCellItem;
import de.markusbordihn.scraptechworkshop.menu.slots.CollectorStationStorageSlot;
import de.markusbordihn.scraptechworkshop.menu.slots.CollectorStationUpgradeSlot;
import de.markusbordihn.scraptechworkshop.menu.slots.DummySlot;
import de.markusbordihn.scraptechworkshop.menu.slots.EnergyCellSlot;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CollectorStationMenu
extends AbstractContainerMenu {
    public static final int BATTERY_SLOT_X = 8;
    public static final int BATTERY_SLOT_Y = 18;
    public static final int ENERGY_BAR_X = 9;
    public static final int ENERGY_BAR_Y = 38;
    public static final int STORAGE_GRID_START_X = 30;
    public static final int STORAGE_GRID_START_Y = 18;
    public static final int STORAGE_GRID_COLUMNS = 6;
    public static final int STORAGE_GRID_ROWS = 4;
    public static final int PROGRESS_BAR_X = 39;
    public static final int PROGRESS_BAR_Y = 96;
    public static final int UPGRADE_SLOT_START_X = 150;
    public static final int UPGRADE_SLOT_Y = 18;
    public static final int UPGRADE_SLOTS_COUNT = 4;
    public static final int PLAYER_INVENTORY_START_Y = 139;
    public static final int PLAYER_HOTBAR_START_Y = 197;
    public static final int SLOT_SPACING = 18;
    public static final int CONTAINER_DATA_SIZE = 4;
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");
    private static final String LOG_PREFIX = "[CollectorStationMenu]";
    public static MenuType<CollectorStationMenu> TYPE;
    private final CollectorStationBlockEntity blockEntity;
    private final Level level;
    private final ContainerData data;
    private final SimpleContainer dummyContainer;
    private final BlockPos blockPos;

    public CollectorStationMenu(int windowId, Inventory playerInventory, FriendlyByteBuf additionalData) {
        this(windowId, playerInventory, CollectorStationMenu.getBlockEntityFromData(playerInventory, additionalData), (ContainerData)new SimpleContainerData(4));
    }

    public CollectorStationMenu(int windowId, Inventory playerInventory, BlockEntity entity, ContainerData data) {
        super(TYPE, windowId);
        this.level = playerInventory.f_35978_.m_9236_();
        this.data = data != null ? data : new SimpleContainerData(4);
        this.dummyContainer = new SimpleContainer(29);
        if (entity instanceof CollectorStationBlockEntity) {
            CollectorStationBlockEntity stationEntity;
            this.blockEntity = stationEntity = (CollectorStationBlockEntity)entity;
            this.blockPos = stationEntity.m_58899_();
        } else {
            log.error("{} Expected CollectorStationBlockEntity but got {} at {}", (Object)LOG_PREFIX, (Object)entity, entity != null ? entity.m_58899_() : "NULL");
            this.blockEntity = null;
            this.blockPos = null;
        }
        CollectorStationMenu.m_38869_((Container)playerInventory, (int)29);
        this.addCollectorStationSlots();
        this.addPlayerInventory(playerInventory);
        this.addPlayerHotbar(playerInventory);
        this.m_38884_(this.data);
    }

    private static BlockEntity getBlockEntityFromData(Inventory playerInventory, FriendlyByteBuf additionalData) {
        if (additionalData != null && additionalData.isReadable()) {
            BlockPos pos = additionalData.m_130135_();
            Level level = playerInventory.f_35978_.m_9236_();
            if (level != null) {
                return level.m_7702_(pos);
            }
        }
        return null;
    }

    private void addCollectorStationSlots() {
        CollectorStationBlockEntity entityToUse = this.getValidBlockEntity();
        if (entityToUse != null) {
            this.m_38897_(new EnergyCellSlot((Container)entityToUse, 0, 8, 18));
            int storageIndex = 1;
            for (int row = 0; row < 4; ++row) {
                for (int col = 0; col < 6; ++col) {
                    this.m_38897_(new CollectorStationStorageSlot(entityToUse, storageIndex++, 30 + col * 18 + 2, 18 + row * 18));
                }
            }
            for (int i = 0; i < 4; ++i) {
                this.m_38897_(new CollectorStationUpgradeSlot(entityToUse, 25 + i, 152, 18 + i * 18));
            }
        } else {
            for (int i = 0; i < 29; ++i) {
                this.m_38897_(new DummySlot((Container)this.dummyContainer, i, -1000, -1000));
            }
        }
    }

    private CollectorStationBlockEntity getValidBlockEntity() {
        BlockEntity entity;
        if (this.blockEntity != null) {
            return this.blockEntity;
        }
        if (this.blockPos != null && this.level != null && (entity = this.level.m_7702_(this.blockPos)) instanceof CollectorStationBlockEntity) {
            CollectorStationBlockEntity stationEntity = (CollectorStationBlockEntity)entity;
            log.debug("{} Resolved BlockEntity on delayed lookup", (Object)LOG_PREFIX);
            return stationEntity;
        }
        return null;
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 139 + row * 18 + 1));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInventory, col, 8 + col * 18, 198));
        }
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack returnStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            returnStack = slotStack.m_41777_();
            if (index < 29 ? !this.m_38903_(slotStack, 29, this.f_38839_.size(), true) : (slotStack.m_41720_() instanceof EnergyCellItem ? !this.m_38903_(slotStack, 0, 1, false) : !this.m_38903_(slotStack, 1, 25, false))) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return returnStack;
    }

    public boolean m_6875_(Player player) {
        if (this.blockEntity == null) {
            return false;
        }
        return CollectorStationMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.blockEntity.m_58899_()), (Player)player, (Block)this.blockEntity.m_58900_().m_60734_());
    }

    public int getStatus() {
        return this.data.m_6413_(0);
    }

    public int getStateTimer() {
        return this.data.m_6413_(1);
    }

    public int getCollectionProgress() {
        return this.data.m_6413_(1);
    }

    public int getMaxCollectionTime() {
        return switch (this.getStatus()) {
            case 1 -> CollectorStationConfig.collectingTime;
            case 2 -> CollectorStationConfig.returningTime;
            case 3 -> CollectorStationConfig.processingTime;
            case 4 -> CollectorStationConfig.chargingTime;
            default -> CollectorStationConfig.collectingTime;
        };
    }

    public int getCurrentEnergy() {
        return this.data.m_6413_(2);
    }

    public CollectorStationBlockEntity getBlockEntity() {
        return this.blockEntity;
    }
}

