/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.registry.item.hololog;

import de.markusbordihn.scraptechworkshop.item.hololog.HoloCubeItem;
import de.markusbordihn.scraptechworkshop.item.hololog.HoloPadItem;
import de.markusbordihn.scraptechworkshop.registry.block.hololog.HoloLogBlockRegistry;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class HoloLogItemRegistry {
    private static final Map<String, HoloPadItem> HOLO_PAD_ITEMS = new LinkedHashMap<String, HoloPadItem>();
    private static final Map<String, HoloCubeItem> HOLO_CUBE_ITEMS = new LinkedHashMap<String, HoloCubeItem>();
    private static final Map<ResourceLocation, HoloCubeItem> HOLO_LOG_TO_CUBE_ITEM = new LinkedHashMap<ResourceLocation, HoloCubeItem>();

    private HoloLogItemRegistry() {
    }

    public static Supplier<HoloPadItem> createHoloPadSupplier(String id, ResourceLocation holoLogId) {
        return () -> {
            HoloPadItem item = new HoloPadItem(holoLogId, new Item.Properties());
            HOLO_PAD_ITEMS.put(id, item);
            return item;
        };
    }

    public static Supplier<HoloCubeItem> createHoloCubeSupplier(String id, ResourceLocation holoLogId) {
        return () -> {
            HoloCubeItem item = new HoloCubeItem(holoLogId, (Block)HoloLogBlockRegistry.HOLO_CUBE_BLOCK, new Item.Properties());
            HOLO_CUBE_ITEMS.put(id, item);
            HOLO_LOG_TO_CUBE_ITEM.put(holoLogId, item);
            return item;
        };
    }

    public static Map<String, HoloPadItem> getHoloPadItems() {
        return HOLO_PAD_ITEMS;
    }

    public static Map<String, HoloCubeItem> getHoloCubeItems() {
        return HOLO_CUBE_ITEMS;
    }

    public static HoloCubeItem getHoloCubeItemByHoloLog(ResourceLocation holoLogId) {
        return HOLO_LOG_TO_CUBE_ITEM.get(holoLogId);
    }
}

