/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.item.tool;

import de.markusbordihn.scraptechworkshop.Constants;
import de.markusbordihn.scraptechworkshop.data.ScrapMultitoolData;
import de.markusbordihn.scraptechworkshop.item.ModItems;
import de.markusbordihn.scraptechworkshop.item.component.EnergyCellItem;
import de.markusbordihn.scraptechworkshop.menu.ScrapMultitoolMenu;
import de.markusbordihn.scraptechworkshop.menu.ScrapMultitoolMenuProvider;
import java.lang.reflect.Proxy;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1766;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1832;
import net.minecraft.class_1834;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3908;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScrapMultitoolItem
extends class_1766 {
    public static final String ID = "scrap_multitool";
    public static final int ENERGY_MAX = 10000;
    public static final int ENERGY_PER_USE = 1;
    public static final int ENERGY_PER_BLOCK = 2;
    public static final int ENERGY_PER_ATTACK = 5;
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");

    public ScrapMultitoolItem(class_1792.class_1793 properties) {
        super(4.0f, -2.0f, (class_1832)class_1834.field_8923, class_3481.field_33715, properties.method_7895(10000).method_7894(class_1814.field_8903));
    }

    public static class_1799 createWithBattery() {
        class_1799 battery = new class_1799((class_1935)ModItems.SLIGHTLY_DAMAGED_ENERGY_CELL.get());
        class_1792 class_17922 = battery.method_7909();
        if (class_17922 instanceof EnergyCellItem) {
            EnergyCellItem energyCell = (EnergyCellItem)class_17922;
            energyCell.setEnergy(battery, 2500);
        }
        class_1799 multitool = new class_1799((class_1935)ModItems.SCRAP_MULTITOOL.get());
        ScrapMultitoolData data = ScrapMultitoolData.createDefault().withBattery(battery);
        ((ScrapMultitoolItem)multitool.method_7909()).setData(multitool, data);
        ((ScrapMultitoolItem)multitool.method_7909()).syncEnergyFromBattery(multitool);
        return multitool;
    }

    public void method_7843(class_1799 itemStack, class_1937 level, class_1657 player) {
        super.method_7843(itemStack, level, player);
        ScrapMultitoolData data = this.getData(itemStack);
        if (!data.hasBattery()) {
            class_1799 battery = new class_1799((class_1935)ModItems.SLIGHTLY_DAMAGED_ENERGY_CELL.get());
            class_1792 class_17922 = battery.method_7909();
            if (class_17922 instanceof EnergyCellItem) {
                EnergyCellItem energyCell = (EnergyCellItem)class_17922;
                energyCell.setEnergy(battery, 2500);
            }
            this.setData(itemStack, data.withBattery(battery));
            this.syncEnergyFromBattery(itemStack);
        }
    }

    public float method_7865(class_1799 itemStack, class_2680 state) {
        if (!this.hasEnergy(itemStack, 2)) {
            return 1.0f;
        }
        ToolMode mode = this.getToolModeForBlock(state);
        if (mode != ToolMode.NONE) {
            return this.getPoweredSpeed(mode);
        }
        return super.method_7865(itemStack, state);
    }

    public boolean method_7873(class_1799 itemStack, class_1309 target, class_1309 attacker) {
        if (this.hasEnergy(itemStack, 5)) {
            this.consumeEnergy(itemStack, 5);
            return true;
        }
        return false;
    }

    public boolean method_7879(class_1799 itemStack, class_1937 level, class_2680 state, class_2338 pos, class_1309 entity) {
        if (this.hasEnergy(itemStack, 2)) {
            this.consumeEnergy(itemStack, 2);
            return true;
        }
        return false;
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (player.method_5715() && !level.field_9236) {
            this.openMultitoolScreen(player, itemStack, hand);
            return class_1271.method_29237((Object)itemStack, (boolean)level.field_9236);
        }
        if (!level.field_9236 && this.hasEnergy(itemStack, 1)) {
            class_243 playerPos = player.method_19538().method_1031(0.0, 1.0, 0.0);
            class_243 lookDirection = player.method_5720();
            class_243 particlePos = playerPos.method_1019(lookDirection.method_1021(1.5));
            if (level instanceof class_3218) {
                class_3218 serverLevel = (class_3218)level;
                serverLevel.method_14199((class_2394)class_2398.field_11207, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, 5, 0.2, 0.2, 0.2, 0.05);
            }
            level.method_8396(null, player.method_24515(), class_3417.field_14891, class_3419.field_15248, 0.5f, 1.2f);
            this.consumeEnergy(itemStack, 1);
        }
        return class_1271.method_22430((Object)itemStack);
    }

    public class_1269 method_7884(class_1838 context) {
        if (context.method_8036() != null && context.method_8036().method_5715()) {
            return class_1269.field_5811;
        }
        return super.method_7884(context);
    }

    public boolean hasEnergy(class_1799 itemStack, int amount) {
        return this.getEnergy(itemStack) >= amount;
    }

    public int getEnergy(class_1799 itemStack) {
        return 10000 - itemStack.method_7919();
    }

    public float getEnergyPercentage(class_1799 itemStack) {
        int energy = this.getEnergy(itemStack);
        if (energy <= 1) {
            return 0.0f;
        }
        return (float)energy / 10000.0f;
    }

    public int getDisplayEnergy(class_1799 itemStack) {
        float percentage = this.getEnergyPercentage(itemStack);
        return Math.round(percentage * 100.0f);
    }

    public int getTotalEnergy(class_1799 itemStack) {
        class_1799 battery;
        class_1792 class_17922;
        int toolEnergy = this.getEnergy(itemStack);
        ScrapMultitoolData data = this.getData(itemStack);
        if (data.hasBattery() && (class_17922 = (battery = data.battery()).method_7909()) instanceof EnergyCellItem) {
            EnergyCellItem batteryItem = (EnergyCellItem)class_17922;
            return toolEnergy + batteryItem.getEnergy(battery);
        }
        return toolEnergy;
    }

    public void syncEnergyFromBattery(class_1799 itemStack) {
        ScrapMultitoolData data = this.getData(itemStack);
        if (data.hasBattery()) {
            class_1799 battery = data.battery();
            class_1792 class_17922 = battery.method_7909();
            if (class_17922 instanceof EnergyCellItem) {
                EnergyCellItem batteryItem = (EnergyCellItem)class_17922;
                float batteryPercentage = batteryItem.getEnergyPercentage(battery);
                int newEnergy = Math.round(10000.0f * batteryPercentage);
                this.setEnergy(itemStack, newEnergy);
            }
        } else {
            this.setEnergy(itemStack, 1);
        }
        this.updateDisplayModel(itemStack, data);
    }

    public BatteryLevel getBatteryLevel(class_1799 itemStack) {
        ScrapMultitoolData data = this.getData(itemStack);
        if (!data.hasBattery()) {
            return BatteryLevel.BATTERY_LEVEL_0;
        }
        class_1799 battery = data.battery();
        class_1792 class_17922 = battery.method_7909();
        if (class_17922 instanceof EnergyCellItem) {
            EnergyCellItem batteryItem = (EnergyCellItem)class_17922;
            float percentage = batteryItem.getEnergyPercentage(battery);
            if (percentage >= 1.0f) {
                return BatteryLevel.BATTERY_LEVEL_100;
            }
            if (percentage >= 0.75f) {
                return BatteryLevel.BATTERY_LEVEL_75;
            }
            if (percentage >= 0.5f) {
                return BatteryLevel.BATTERY_LEVEL_50;
            }
            if (percentage >= 0.25f) {
                return BatteryLevel.BATTERY_LEVEL_25;
            }
        }
        return BatteryLevel.BATTERY_LEVEL_0;
    }

    public void setEnergy(class_1799 itemStack, int energy) {
        itemStack.method_7974(10000 - Math.max(1, Math.min(energy, 10000)));
    }

    public void consumeEnergy(class_1799 itemStack, int amount) {
        class_1799 battery;
        class_1792 class_17922;
        ScrapMultitoolData data = this.getData(itemStack);
        if (data.hasBattery() && (class_17922 = (battery = data.battery()).method_7909()) instanceof EnergyCellItem) {
            EnergyCellItem batteryItem = (EnergyCellItem)class_17922;
            int batteryEnergy = batteryItem.getEnergy(battery);
            if (batteryEnergy > amount) {
                batteryItem.consumeEnergy(battery, amount);
                this.syncEnergyFromBattery(itemStack);
                return;
            }
            class_1799 emptyBattery = batteryItem.createEmptyBattery();
            ScrapMultitoolData newData = new ScrapMultitoolData(emptyBattery, data.modules(), data.hologramColor(), data.hudEnabled(), data.toolPriority());
            this.setData(itemStack, newData);
            this.syncEnergyFromBattery(itemStack);
            return;
        }
        int currentEnergy = this.getEnergy(itemStack);
        this.setEnergy(itemStack, Math.max(1, currentEnergy - amount));
    }

    public void addEnergy(class_1799 itemStack, int amount) {
        int currentEnergy = this.getEnergy(itemStack);
        this.setEnergy(itemStack, Math.min(10000, currentEnergy + amount));
    }

    public ToolMode getToolModeForBlock(class_2680 state) {
        if (state.method_26164(class_3481.field_33713)) {
            return ToolMode.AXE;
        }
        if (state.method_26164(class_3481.field_33716)) {
            return ToolMode.SHOVEL;
        }
        if (state.method_26164(class_3481.field_33715)) {
            return ToolMode.PICKAXE;
        }
        return ToolMode.NONE;
    }

    public ToolMode getToolModeForEntity(class_1309 entity) {
        return entity != null ? ToolMode.SWORD : ToolMode.NONE;
    }

    private float getPoweredSpeed(ToolMode mode) {
        return switch (mode) {
            case ToolMode.PICKAXE -> 8.0f;
            case ToolMode.AXE -> 9.0f;
            case ToolMode.SHOVEL -> 7.0f;
            default -> 6.0f;
        };
    }

    public ScrapMultitoolData getData(class_1799 itemStack) {
        class_2487 tag = itemStack.method_7948();
        if (tag.method_10545("MultitoolData")) {
            return ScrapMultitoolData.fromNBT(tag.method_10562("MultitoolData"));
        }
        return ScrapMultitoolData.createDefault();
    }

    public void setData(class_1799 itemStack, ScrapMultitoolData data) {
        class_2487 tag = itemStack.method_7948();
        tag.method_10566("MultitoolData", (class_2520)data.toNBT());
        this.updateDisplayModel(itemStack, data);
    }

    private void updateDisplayModel(class_1799 itemStack, ScrapMultitoolData data) {
        BatteryLevel level = this.getBatteryLevel(itemStack);
        int customModelData = switch (level) {
            default -> throw new IncompatibleClassChangeError();
            case BatteryLevel.BATTERY_LEVEL_0 -> 1;
            case BatteryLevel.BATTERY_LEVEL_25 -> 2;
            case BatteryLevel.BATTERY_LEVEL_50 -> 3;
            case BatteryLevel.BATTERY_LEVEL_75 -> 4;
            case BatteryLevel.BATTERY_LEVEL_100 -> 5;
        };
        class_2487 tag = itemStack.method_7948();
        tag.method_10569("CustomModelData", customModelData);
    }

    private void openMultitoolScreen(class_1657 player, class_1799 stack, class_1268 hand) {
        if (Constants.IS_FABRIC) {
            try {
                Class<?> menuFactoryInterface = Class.forName("de.markusbordihn.scraptechworkshop.menu.ItemBaseScreenHandler$MenuFactory");
                Object menuFactory = Proxy.newProxyInstance(menuFactoryInterface.getClassLoader(), new Class[]{menuFactoryInterface}, (proxy, method, args) -> {
                    if ("create".equals(method.getName())) {
                        int windowId = (Integer)args[0];
                        class_1661 playerInventory = (class_1661)args[1];
                        class_1799 itemStack = (class_1799)args[2];
                        class_1268 h = (class_1268)args[3];
                        int slotIndex = (Integer)args[4];
                        return new ScrapMultitoolMenu(windowId, playerInventory, itemStack, h, slotIndex);
                    }
                    return null;
                });
                Class<?> fabricFactoryClass = Class.forName("de.markusbordihn.scraptechworkshop.menu.ItemBaseScreenHandler");
                Object fabricFactory = fabricFactoryClass.getConstructor(class_1799.class, class_1268.class, menuFactoryInterface).newInstance(stack, hand, menuFactory);
                player.method_17355((class_3908)fabricFactory);
            }
            catch (Exception e) {
                log.error("Failed to open Multitool menu on Fabric: {}", (Object)e.getMessage(), (Object)e);
                player.method_17355((class_3908)new ScrapMultitoolMenuProvider(stack, hand));
            }
        } else {
            player.method_17355((class_3908)new ScrapMultitoolMenuProvider(stack, hand));
        }
    }

    public boolean method_31567(class_1799 itemStack) {
        return true;
    }

    public int method_31571(class_1799 itemStack) {
        float energyRatio = this.getEnergyPercentage(itemStack);
        return energyRatio > 0.6f ? 65280 : (energyRatio > 0.3f ? 0xFFFF00 : 0xFF0000);
    }

    public void method_7851(class_1799 itemStack, class_1937 level, List<class_2561> tooltipComponents, class_1836 isAdvanced) {
        tooltipComponents.add((class_2561)class_2561.method_43471((String)"item.scrap_tech_workshop.scrap_multitool.description"));
        int displayEnergy = this.getDisplayEnergy(itemStack);
        tooltipComponents.add((class_2561)class_2561.method_43470((String)("Energy: " + displayEnergy + "%")).method_27694(style -> style.method_36139(this.method_31571(itemStack))));
        ScrapMultitoolData data = this.getData(itemStack);
        if (data.hasBattery()) {
            tooltipComponents.add((class_2561)class_2561.method_43470((String)"Battery: Installed").method_27694(style -> style.method_36139(65280)));
        }
        tooltipComponents.add((class_2561)class_2561.method_43470((String)"Shift + Right-click to configure").method_27694(style -> style.method_10978(Boolean.valueOf(true))));
        super.method_7851(itemStack, level, tooltipComponents, isAdvanced);
    }

    public boolean method_7878(class_1799 toRepair, class_1799 repair) {
        return false;
    }

    public boolean method_7870(class_1799 itemStack) {
        return false;
    }

    public static enum ToolMode {
        NONE,
        PICKAXE,
        AXE,
        SHOVEL,
        SWORD;

    }

    public static enum BatteryLevel {
        BATTERY_LEVEL_0(0.0f),
        BATTERY_LEVEL_25(0.25f),
        BATTERY_LEVEL_50(0.5f),
        BATTERY_LEVEL_75(0.75f),
        BATTERY_LEVEL_100(1.0f);

        private final float percentage;

        private BatteryLevel(float percentage) {
            this.percentage = percentage;
        }

        public float getPercentage() {
            return this.percentage;
        }
    }
}

