/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.loot;

import net.minecraft.class_5819;

public final class WeightedLootTable<T> {
    private final Entry<T>[] entries;
    private final int totalWeight;

    @SafeVarargs
    public WeightedLootTable(Entry<T> ... entries) {
        if (entries == null || entries.length == 0) {
            throw new IllegalArgumentException("Weighted loot table cannot be empty");
        }
        this.entries = (Entry[])entries.clone();
        int cumulative = 0;
        for (Entry<T> entry : this.entries) {
            if (entry == null) {
                throw new IllegalArgumentException("Entry cannot be null");
            }
            entry.cumulativeWeight = cumulative += entry.weight;
        }
        this.totalWeight = cumulative;
        if (this.totalWeight <= 0) {
            throw new IllegalArgumentException("Total weight must be positive, got: " + this.totalWeight);
        }
    }

    public T generate(class_5819 random) {
        if (this.totalWeight <= 0) {
            return this.entries[0].item;
        }
        int randomValue = random.method_43048(this.totalWeight);
        int left = 0;
        int right = this.entries.length - 1;
        while (left < right) {
            int mid = left + right >>> 1;
            if (randomValue < this.entries[mid].cumulativeWeight) {
                right = mid;
                continue;
            }
            left = mid + 1;
        }
        return this.entries[left].item;
    }

    public int getTotalWeight() {
        return this.totalWeight;
    }

    public int size() {
        return this.entries.length;
    }

    public double getProbability(int entryIndex) {
        if (entryIndex < 0 || entryIndex >= this.entries.length) {
            throw new IndexOutOfBoundsException("Entry index out of bounds: " + entryIndex);
        }
        return (double)this.entries[entryIndex].weight / (double)this.totalWeight * 100.0;
    }

    public Entry<T> getEntry(int index) {
        if (index < 0 || index >= this.entries.length) {
            throw new IndexOutOfBoundsException("Entry index out of bounds: " + index);
        }
        return this.entries[index];
    }

    public static final class Entry<T> {
        public final T item;
        public final int weight;
        int cumulativeWeight;

        public Entry(T item, int weight) {
            if (weight < 0) {
                throw new IllegalArgumentException("Weight cannot be negative: " + weight);
            }
            this.item = item;
            this.weight = weight;
        }
    }
}

