/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.menu;

import de.markusbordihn.scraptechworkshop.data.ScrapMultitoolData;
import de.markusbordihn.scraptechworkshop.item.component.EnergyCellItem;
import de.markusbordihn.scraptechworkshop.item.tool.ScrapMultitoolItem;
import de.markusbordihn.scraptechworkshop.menu.slots.MultitoolBatterySlot;
import de.markusbordihn.scraptechworkshop.menu.slots.MultitoolModuleSlot;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_3917;

public class ScrapMultitoolMenu
extends class_1703 {
    public static final int BATTERY_SLOT_X = 100;
    public static final int BATTERY_SLOT_Y = 20;
    public static final int SLOT_SPACING = 18;
    public static final int MODULE_SLOTS_START_X = 64;
    public static final int MODULE_SLOTS_Y = 50;
    public static final int MODULE_SLOTS_COUNT = 4;
    public static final int PLAYER_INVENTORY_START_X = 8;
    public static final int PLAYER_INVENTORY_START_Y = 138;
    public static final int PLAYER_INVENTORY_ROWS = 3;
    public static final int PLAYER_INVENTORY_COLUMNS = 9;
    public static final int PLAYER_HOTBAR_START_X = 8;
    public static final int PLAYER_HOTBAR_Y = 196;
    public static final int PLAYER_HOTBAR_SLOTS = 9;
    public static final int TOTAL_TOOL_SLOTS = 5;
    public static class_3917<ScrapMultitoolMenu> TYPE;
    private final class_1799 multitoolStack;
    private final class_1277 toolContainer;
    private final int toolSlotIndex;
    private final class_1268 hand;
    private boolean initialized = false;

    public ScrapMultitoolMenu(int windowId, class_1661 playerInventory, class_2540 additionalData) {
        this(windowId, playerInventory, additionalData != null ? additionalData.method_10819() : playerInventory.field_7546.method_6047(), additionalData != null ? (class_1268)additionalData.method_10818(class_1268.class) : class_1268.field_5808, additionalData != null ? additionalData.readInt() : playerInventory.field_7545);
    }

    public ScrapMultitoolMenu(int windowId, class_1661 playerInventory, class_1799 multitoolStack, class_1268 hand, int slotIndex) {
        super(TYPE, windowId);
        this.multitoolStack = multitoolStack;
        this.hand = hand;
        this.toolSlotIndex = slotIndex;
        class_1792 class_17922 = multitoolStack.method_7909();
        if (!(class_17922 instanceof ScrapMultitoolItem)) {
            throw new IllegalArgumentException("Invalid multitool ItemStack");
        }
        ScrapMultitoolItem multitool = (ScrapMultitoolItem)class_17922;
        this.toolContainer = this.createToolContainer(multitool);
        this.addToolSlots();
        this.addPlayerInventory(playerInventory);
        this.addPlayerHotbar(playerInventory);
    }

    private class_1277 createToolContainer(ScrapMultitoolItem multitool) {
        ScrapMultitoolData data = multitool.getData(this.multitoolStack);
        class_1277 container = new class_1277(5){

            public void method_5431() {
                super.method_5431();
                if (ScrapMultitoolMenu.this.initialized) {
                    ScrapMultitoolMenu.this.saveToMultitool();
                }
            }
        };
        container.method_5447(0, data.battery());
        for (int i = 0; i < data.modules().length; ++i) {
            class_1799 module = data.modules()[i];
            if (module == null) continue;
            container.method_5447(i + 1, module);
        }
        this.initialized = true;
        return container;
    }

    private void addToolSlots() {
        this.method_7621(new MultitoolBatterySlot((class_1263)this.toolContainer, 0, 100, 20));
        for (int i = 0; i < 4; ++i) {
            int slotIndex = i + 1;
            int x = 64 + i * 18;
            this.method_7621(new MultitoolModuleSlot((class_1263)this.toolContainer, slotIndex, x, 50));
        }
    }

    private void addPlayerInventory(class_1661 playerInventory) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.method_7621(new class_1735((class_1263)playerInventory, col + row * 9 + 9, 8 + col * 18, 138 + row * 18));
            }
        }
    }

    private void addPlayerHotbar(class_1661 playerInventory) {
        int col = 0;
        while (col < 9) {
            int x = 8 + col * 18;
            int index = col++;
            this.method_7621(new class_1735((class_1263)playerInventory, index, x, 196){

                public boolean method_7674(class_1657 player) {
                    return this.field_7874 != ScrapMultitoolMenu.this.toolSlotIndex;
                }
            });
        }
    }

    private void saveToMultitool() {
        class_1792 class_17922 = this.multitoolStack.method_7909();
        if (class_17922 instanceof ScrapMultitoolItem) {
            ScrapMultitoolItem multitool = (ScrapMultitoolItem)class_17922;
            if (this.toolContainer != null) {
                class_1799[] modules = new class_1799[4];
                for (int i = 0; i < modules.length; ++i) {
                    modules[i] = this.toolContainer.method_5438(i + 1);
                }
                ScrapMultitoolData currentData = multitool.getData(this.multitoolStack);
                ScrapMultitoolData newData = new ScrapMultitoolData(this.toolContainer.method_5438(0), modules, currentData.hologramColor(), currentData.hudEnabled(), currentData.toolPriority());
                multitool.setData(this.multitoolStack, newData);
                multitool.syncEnergyFromBattery(this.multitoolStack);
            }
        }
    }

    public class_1799 method_7601(class_1657 player, int index) {
        class_1799 itemStack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(index);
        if (slot.method_7681()) {
            class_1799 slotStack = slot.method_7677();
            itemStack = slotStack.method_7972();
            int playerInventoryEnd = 32;
            int playerHotbarEnd = playerInventoryEnd + 9;
            if (index < 5 ? !this.method_7616(slotStack, 5, playerHotbarEnd, true) : (index < playerInventoryEnd ? (slotStack.method_7909() instanceof EnergyCellItem ? !this.method_7616(slotStack, 0, 1, false) && !this.method_7616(slotStack, playerInventoryEnd, playerHotbarEnd, false) : (this.isValidModule(slotStack) ? !this.method_7616(slotStack, 1, 5, false) && !this.method_7616(slotStack, playerInventoryEnd, playerHotbarEnd, false) : !this.method_7616(slotStack, playerInventoryEnd, playerHotbarEnd, false))) : index < playerHotbarEnd && (slotStack.method_7909() instanceof EnergyCellItem ? !this.method_7616(slotStack, 0, 1, false) && !this.method_7616(slotStack, 5, playerInventoryEnd, false) : (this.isValidModule(slotStack) ? !this.method_7616(slotStack, 1, 5, false) && !this.method_7616(slotStack, 5, playerInventoryEnd, false) : !this.method_7616(slotStack, 5, playerInventoryEnd, false))))) {
                return class_1799.field_8037;
            }
            if (slotStack.method_7960()) {
                slot.method_48931(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
        }
        return itemStack;
    }

    private boolean isValidModule(class_1799 stack) {
        return stack.method_7909().toString().contains("module") || stack.method_7909().toString().contains("upgrade");
    }

    public boolean method_7597(class_1657 player) {
        return !this.multitoolStack.method_7960() && player.method_31548().method_7379(this.multitoolStack);
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        this.saveToMultitool();
    }

    public class_1799 getMultitoolStack() {
        return this.multitoolStack;
    }

    public class_1268 getHand() {
        return this.hand;
    }
}

