/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.spawner;

import de.markusbordihn.scraptechworkshop.block.ScrapPileBlock;
import de.markusbordihn.scraptechworkshop.config.ScrapPileConfig;
import de.markusbordihn.scraptechworkshop.data.ScrapPileVariant;
import de.markusbordihn.scraptechworkshop.registry.block.ScrapPileBlockRegistry;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1923;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3481;
import net.minecraft.class_3612;
import net.minecraft.class_5819;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScrapPileSpawner {
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");
    private static final Map<class_1923, Integer> chunkScrapCounts = new ConcurrentHashMap<class_1923, Integer>();
    private static final Map<class_1923, Long> chunkCountTimestamps = new ConcurrentHashMap<class_1923, Long>();
    private static final Map<class_1923, Long> chunkPlayerActivity = new ConcurrentHashMap<class_1923, Long>();
    private static final long CACHE_VALIDITY_MS = 30000L;
    private static final long ACTIVITY_VALIDITY_MS = 300000L;
    private static int tickCounter = 0;

    protected ScrapPileSpawner() {
    }

    public static void tick(MinecraftServer minecraftServer) {
        if (ScrapPileConfig.spawnIntervalTicks <= 0) {
            return;
        }
        if (++tickCounter >= ScrapPileConfig.spawnIntervalTicks) {
            tickCounter = 0;
            ScrapPileSpawner.cleanupExpiredCache();
            for (class_3218 level : minecraftServer.method_3738()) {
                try {
                    ScrapPileSpawner.tick(level);
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void tick(class_3218 level) {
        if (!ScrapPileConfig.spawnEnabled || level.method_18456().isEmpty()) {
            return;
        }
        int attemptsThisTick = ScrapPileSpawner.getAdaptiveSpawnAttempts(level);
        for (int i = 0; i < attemptsThisTick; ++i) {
            try {
                ScrapPileSpawner.trySpawnScrapPile(level);
                continue;
            }
            catch (Exception e) {
                break;
            }
        }
    }

    private static void cleanupExpiredCache() {
        long currentTime = System.currentTimeMillis();
        chunkCountTimestamps.entrySet().removeIf(entry -> currentTime - (Long)entry.getValue() > 30000L);
        chunkScrapCounts.keySet().removeIf(chunkPos -> !chunkCountTimestamps.containsKey(chunkPos));
        chunkPlayerActivity.entrySet().removeIf(entry -> currentTime - (Long)entry.getValue() > 300000L);
    }

    private static int getAdaptiveSpawnAttempts(class_3218 level) {
        int baseAttempts = ScrapPileConfig.spawnAttemptsPerTick;
        double mspt = level.method_8503().method_3830();
        if (mspt > 40.0) {
            return Math.max(1, baseAttempts / 4);
        }
        if (mspt > 30.0) {
            return Math.max(1, baseAttempts / 2);
        }
        if (mspt > 20.0) {
            return Math.max(1, baseAttempts * 3 / 4);
        }
        return baseAttempts;
    }

    private static void trySpawnScrapPile(class_3218 level) {
        class_2338 spawnPos;
        class_1923 targetChunk;
        int offsetZ;
        int offsetX;
        int attempts;
        if (level.method_18456().isEmpty()) {
            return;
        }
        class_3222 randomPlayer = (class_3222)level.method_18456().get(level.field_9229.method_43048(level.method_18456().size()));
        class_1923 playerChunk = new class_1923(randomPlayer.method_24515());
        for (attempts = 0; attempts < 3; ++attempts) {
            offsetX = level.field_9229.method_43048(17) - 8;
            offsetZ = level.field_9229.method_43048(17) - 8;
            targetChunk = new class_1923(playerChunk.field_9181 + offsetX, playerChunk.field_9180 + offsetZ);
            if (!level.method_8393(targetChunk.field_9181, targetChunk.field_9180) || ScrapPileSpawner.getCachedScrapPileCount(level, targetChunk) >= ScrapPileConfig.spawnChunkCap || !ScrapPileSpawner.hasRecentPlayerActivity(targetChunk) || (spawnPos = ScrapPileSpawner.findSuitableSpawnLocation(level, targetChunk)) == null) continue;
            ScrapPileSpawner.spawnScrapPile(level, spawnPos);
            ScrapPileSpawner.incrementChunkCount(targetChunk);
            return;
        }
        for (attempts = 0; attempts < 3; ++attempts) {
            offsetX = level.field_9229.method_43048(17) - 8;
            offsetZ = level.field_9229.method_43048(17) - 8;
            targetChunk = new class_1923(playerChunk.field_9181 + offsetX, playerChunk.field_9180 + offsetZ);
            if (!level.method_8393(targetChunk.field_9181, targetChunk.field_9180) || ScrapPileSpawner.getCachedScrapPileCount(level, targetChunk) >= ScrapPileConfig.spawnChunkCap || (spawnPos = ScrapPileSpawner.findSuitableSpawnLocation(level, targetChunk)) == null) continue;
            ScrapPileSpawner.spawnScrapPile(level, spawnPos);
            ScrapPileSpawner.incrementChunkCount(targetChunk);
            return;
        }
    }

    private static int getCachedScrapPileCount(class_3218 level, class_1923 chunkPos) {
        long currentTime = System.currentTimeMillis();
        Long cacheTime = chunkCountTimestamps.get(chunkPos);
        if (cacheTime != null && currentTime - cacheTime < 30000L) {
            return chunkScrapCounts.getOrDefault(chunkPos, 0);
        }
        int count = ScrapPileSpawner.countScrapPilesInChunk(level, chunkPos);
        chunkScrapCounts.put(chunkPos, count);
        chunkCountTimestamps.put(chunkPos, currentTime);
        return count;
    }

    private static void incrementChunkCount(class_1923 chunkPos) {
        chunkScrapCounts.merge(chunkPos, 1, Integer::sum);
        chunkCountTimestamps.put(chunkPos, System.currentTimeMillis());
    }

    public static void decrementChunkCount(class_1923 chunkPos) {
        Integer current = chunkScrapCounts.get(chunkPos);
        if (current != null && current > 0) {
            chunkScrapCounts.put(chunkPos, current - 1);
            chunkCountTimestamps.put(chunkPos, System.currentTimeMillis());
        }
    }

    public static void recordPlayerActivity(class_1923 chunkPos) {
        chunkPlayerActivity.put(chunkPos, System.currentTimeMillis());
    }

    private static boolean hasRecentPlayerActivity(class_1923 chunkPos) {
        Long lastActivity = chunkPlayerActivity.get(chunkPos);
        if (lastActivity == null) {
            return false;
        }
        return System.currentTimeMillis() - lastActivity < 300000L;
    }

    private static int countScrapPilesInChunk(class_3218 level, class_1923 chunkPos) {
        if (!level.method_8393(chunkPos.field_9181, chunkPos.field_9180)) {
            return 0;
        }
        int count = 0;
        int startX = chunkPos.method_8326();
        int startZ = chunkPos.method_8328();
        int endX = chunkPos.method_8327();
        int endZ = chunkPos.method_8329();
        try {
            for (int x = startX; x <= endX; x += 8) {
                for (int z = startZ; z <= endZ; z += 8) {
                    for (int y = level.method_31607(); y <= ScrapPileConfig.spawnYMax; y += 8) {
                        class_2338 pos = new class_2338(x, y, z);
                        if (!(level.method_8320(pos).method_26204() instanceof ScrapPileBlock)) continue;
                        ++count;
                    }
                }
            }
        }
        catch (Exception e) {
            return 0;
        }
        return count;
    }

    private static class_2338 findSuitableSpawnLocation(class_3218 level, class_1923 chunkPos) {
        class_5819 random = level.field_9229;
        for (int attempt = 0; attempt < 6; ++attempt) {
            int startY;
            int x = chunkPos.method_8326() + random.method_43048(16);
            int z = chunkPos.method_8328() + random.method_43048(16);
            int maxY = Math.min(ScrapPileConfig.spawnYMax, level.method_31600() - 1);
            for (int y = startY = random.method_43048(Math.max(1, maxY - level.method_31607())) + level.method_31607(); y <= maxY; ++y) {
                class_2338 pos = new class_2338(x, y, z);
                try {
                    if (!ScrapPileSpawner.isSuitableSpawnLocation(level, pos)) continue;
                    return pos;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private static boolean isSuitableSpawnLocation(class_3218 level, class_2338 blockPos) {
        try {
            class_2680 groundState = level.method_8320(blockPos.method_10074());
            class_2680 airState = level.method_8320(blockPos);
            if (!groundState.method_26164(class_3481.field_25806) && !groundState.method_26164(class_3481.field_28993)) {
                return false;
            }
            if (!airState.method_26215() && airState.method_26227().method_15772() != class_3612.field_15910) {
                return false;
            }
            if (blockPos.method_10264() > ScrapPileConfig.spawnYMax) {
                return false;
            }
            if (ScrapPileConfig.spawnDarknessRequired && level.method_8314(class_1944.field_9282, blockPos) > 7) {
                return false;
            }
            return level.method_18456().stream().noneMatch(player -> player.method_5649((double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260()) < 196.0);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static void spawnScrapPile(class_3218 level, class_2338 blockPos) {
        try {
            class_5819 random = level.field_9229;
            ScrapPileVariant variant = ScrapPileSpawner.getRandomVariant(random, level, blockPos);
            int size = random.method_43057() < 0.75f ? 1 : (random.method_43057() < 0.8f ? 2 : 3);
            boolean waterlogged = level.method_8320(blockPos).method_26227().method_15772() == class_3612.field_15910;
            class_2680 scrapPileState = (class_2680)((class_2680)((class_2680)ScrapPileBlockRegistry.SCRAP_PILE_BLOCK.method_9564().method_11657((class_2769)ScrapPileBlock.SIZE, (Comparable)Integer.valueOf(size))).method_11657(ScrapPileBlock.VARIANT, (Comparable)((Object)variant))).method_11657((class_2769)ScrapPileBlock.WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
            level.method_8652(blockPos, scrapPileState, 3);
            if (log.isDebugEnabled()) {
                log.debug("Spawned scrap pile at {} in dimension {} - Size: {}, Variant: {}, Waterlogged: {}", (Object)blockPos, (Object)level.method_27983().method_29177(), (Object)size, (Object)variant, (Object)waterlogged);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static ScrapPileVariant getRandomVariant(class_5819 random, class_3218 serverLevel, class_2338 blockPos) {
        int depth = blockPos.method_10264();
        if (depth < -32) {
            float rand = random.method_43057();
            if (rand < 0.2f) {
                return ScrapPileVariant.MIXED;
            }
            if (rand < 0.4f) {
                return ScrapPileVariant.METAL;
            }
            return ScrapPileVariant.TECH;
        }
        if (depth < 0) {
            float rand = random.method_43057();
            if (rand < 0.3f) {
                return ScrapPileVariant.MIXED;
            }
            if (rand < 0.7f) {
                return ScrapPileVariant.METAL;
            }
            return ScrapPileVariant.TECH;
        }
        float rand = random.method_43057();
        if (rand < 0.6f) {
            return ScrapPileVariant.MIXED;
        }
        if (rand < 0.85f) {
            return ScrapPileVariant.METAL;
        }
        return ScrapPileVariant.TECH;
    }
}

