/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import de.markusbordihn.scraptechworkshop.client.renderer.hololog.HoloLogScreenPlayer;
import de.markusbordihn.scraptechworkshop.data.hololog.DisplayType;
import de.markusbordihn.scraptechworkshop.data.hololog.HoloLogData;
import de.markusbordihn.scraptechworkshop.data.hololog.HoloLogDisplayEntity;
import de.markusbordihn.scraptechworkshop.data.hololog.HoloLogDisplayRecipe;
import de.markusbordihn.scraptechworkshop.data.hololog.HoloLogLine;
import de.markusbordihn.scraptechworkshop.data.hololog.HoloLogManager;
import de.markusbordihn.scraptechworkshop.data.hololog.UIContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import net.minecraft.class_7833;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HoloPadScreen
extends class_437 {
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");
    private static final class_2960 HOLOPAD_TEXTURE = new class_2960("scrap_tech_workshop", "textures/gui/holo_pad.png");
    private static final int TEXTURE_WIDTH = 512;
    private static final int TEXTURE_HEIGHT = 256;
    private static final int SCREEN_WIDTH = 370;
    private static final int SCREEN_HEIGHT = 250;
    private static final int HOLOGRAM_AREA_X = 16;
    private static final int HOLOGRAM_AREA_Y = 16;
    private static final int HOLOGRAM_AREA_WIDTH = 338;
    private static final int HOLOGRAM_AREA_HEIGHT = 100;
    private static final int HOLOGRAM_AREA_CENTER_Y_OFFSET = 0;
    private static final int HOLOLOG_TITLE_AREA_X = 24;
    private static final int HOLOLOG_TITLE_AREA_Y = 94;
    private static final int TEXT_AREA_X = 12;
    private static final int TEXT_AREA_Y = 118;
    private static final int TEXT_AREA_WIDTH = 338;
    private static final int TEXT_AREA_HEIGHT = 120;
    private static final int TEXT_PADDING = 4;
    private static final int TITLE_SPACING = 2;
    private static final int SUBTITLE_SPACING = 4;
    private static final int LINE_SPACING = 2;
    private static final int SCROLL_BUTTON_WIDTH = 12;
    private static final int SCROLL_BUTTON_HEIGHT = 17;
    private static final int SCROLL_BUTTON_X_OFFSET = 338;
    private static final float HOLOGRAM_SCALE_FACTOR = 35.0f;
    private static final float HOLOGRAM_ITEM_SCALE_MULTIPLIER = 2.5f;
    private static final float HOLOGRAM_BLOCK_SCALE_MULTIPLIER = 2.0f;
    private static final float HOLOGRAM_ENTITY_SCALE_MULTIPLIER = 1.95f;
    private static final int HOLOGRAM_ENTITY_Y_OFFSET = 20;
    private static final float HOLOGRAM_Z_OFFSET = 100.0f;
    private static final int ROTATION_X = 180;
    private static final int MAX_LIGHT_LEVEL = 0xF000F0;
    private static final int COLOR_TITLE_TEXT = 65535;
    private static final int COLOR_SUBTITLE_TEXT = 0xAAAAAA;
    private static final int COLOR_LINE_TEXT = 0xFFFFFF;
    private final class_2960 holoLogId;
    private final List<String> wrappedTextLines = new ArrayList<String>();
    private HoloLogData holoLogData;
    private HoloLogScreenPlayer player;
    private int scrollOffset;
    private int leftPos;
    private int topPos;
    private class_4185 replayButton;
    private class_4185 closeButton;
    private boolean playbackCompleted = false;

    public HoloPadScreen(class_2960 holoLogId) {
        super((class_2561)class_2561.method_43471((String)"item.scrap_tech_workshop.holo_pad"));
        this.holoLogId = holoLogId;
    }

    protected void method_25426() {
        super.method_25426();
        this.leftPos = (this.field_22789 - 370) / 2;
        this.topPos = (this.field_22790 - 250) / 2;
        this.addScrollButtons();
        this.addReplayButton();
        this.addCloseButton();
        if (this.player != null) {
            return;
        }
        if (this.holoLogId == null) {
            log.warn("{} No holo log ID provided", (Object)"Scrap Tech Workshop");
            return;
        }
        log.info("{} Opening holo pad screen: {}", (Object)"Scrap Tech Workshop", (Object)this.holoLogId);
        HoloLogManager.loadHoloLog(this.holoLogId).ifPresentOrElse(data -> {
            this.holoLogData = data;
            this.prepareTextLines();
            this.startHoloLogPlayback((HoloLogData)data);
        }, () -> log.error("{} Failed to load hololog: {}", (Object)"Scrap Tech Workshop", (Object)this.holoLogId));
    }

    private void addScrollButtons() {
        int buttonX = this.leftPos + 12 + 338;
        int scrollUpY = this.topPos + 118 + 2;
        int scrollDownY = this.topPos + 118 + 120 - 17 - 2;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u25b2"), button -> this.scrollUp()).method_46434(buttonX, scrollUpY, 12, 17).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u25bc"), button -> this.scrollDown()).method_46434(buttonX, scrollDownY, 12, 17).method_46431());
    }

    private void addReplayButton() {
        int buttonWidth = 80;
        int buttonHeight = 20;
        int buttonX = this.leftPos + 16 + (338 - buttonWidth) / 2;
        int buttonY = this.topPos + 16 + (100 - buttonHeight) / 2 - 15;
        this.replayButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.scrap_tech_workshop.holo_pad.replay"), button -> this.replayHololog()).method_46434(buttonX, buttonY, buttonWidth, buttonHeight).method_46431();
        this.replayButton.field_22764 = false;
        this.method_37063((class_364)this.replayButton);
    }

    private void addCloseButton() {
        int buttonWidth = 80;
        int buttonHeight = 20;
        int buttonX = this.leftPos + 16 + (338 - buttonWidth) / 2;
        int buttonY = this.topPos + 16 + (100 - buttonHeight) / 2 + 10;
        this.closeButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.scrap_tech_workshop.holo_pad.close"), button -> this.method_25419()).method_46434(buttonX, buttonY, buttonWidth, buttonHeight).method_46431();
        this.closeButton.field_22764 = false;
        this.method_37063((class_364)this.closeButton);
    }

    private void scrollUp() {
        this.scrollOffset = Math.max(0, this.scrollOffset - 10);
    }

    private void scrollDown() {
        int maxScroll = Math.max(0, this.calculateTotalTextHeight() - 112);
        this.scrollOffset = Math.min(this.scrollOffset + 10, maxScroll);
    }

    private void startHoloLogPlayback(HoloLogData data) {
        if (this.field_22787 == null || this.field_22787.field_1687 == null) {
            log.error("{} Cannot start playback: minecraft or level is null", (Object)"Scrap Tech Workshop");
            return;
        }
        this.player = new HoloLogScreenPlayer(data, new UIContext((class_1937)this.field_22787.field_1687, class_243.field_1353), UUID.randomUUID(), this::onPlaybackComplete);
        this.player.start();
        this.playbackCompleted = false;
        if (this.replayButton != null) {
            this.replayButton.field_22764 = false;
        }
        if (this.closeButton != null) {
            this.closeButton.field_22764 = false;
        }
        log.info("{} Started hololog playback for: {}", (Object)"Scrap Tech Workshop", (Object)this.holoLogId);
    }

    private void onPlaybackComplete() {
        this.playbackCompleted = true;
        log.info("{} Hololog playback completed: {}", (Object)"Scrap Tech Workshop", (Object)this.holoLogId);
        if (this.replayButton != null) {
            this.replayButton.field_22764 = true;
        }
        if (this.closeButton != null) {
            this.closeButton.field_22764 = true;
        }
    }

    private void replayHololog() {
        log.info("{} Replaying hololog: {}", (Object)"Scrap Tech Workshop", (Object)this.holoLogId);
        this.scrollOffset = 0;
        if (this.holoLogData != null) {
            this.startHoloLogPlayback(this.holoLogData);
        }
    }

    private void prepareTextLines() {
        this.wrappedTextLines.clear();
        if (this.holoLogData == null || this.holoLogData.lines().isEmpty()) {
            return;
        }
        this.holoLogData.lines().stream().map(HoloLogLine::text).filter(text -> text != null && !text.isEmpty()).forEach(this.wrappedTextLines::add);
    }

    public void method_25393() {
        super.method_25393();
        if (this.player != null && this.player.isPlaying()) {
            this.player.tick();
            this.autoScrollText();
        }
    }

    private void autoScrollText() {
        int maxScroll;
        int neededScroll;
        int targetScroll;
        int visibleHeight;
        if (this.player == null) {
            return;
        }
        int currentContentHeight = this.getCurrentContentHeight();
        if (currentContentHeight > (visibleHeight = 112) && this.scrollOffset < (targetScroll = Math.min(neededScroll = currentContentHeight - visibleHeight, maxScroll = Math.max(0, this.calculateTotalTextHeight() - visibleHeight)))) {
            ++this.scrollOffset;
            this.scrollOffset = Math.min(this.scrollOffset, targetScroll);
        }
    }

    private int getCurrentContentHeight() {
        int currentContentHeight = 0;
        if (this.holoLogData != null) {
            if (this.holoLogData.title() != null) {
                Objects.requireNonNull(this.field_22793);
                currentContentHeight += 9 + 2;
            }
            if (this.holoLogData.subtitle() != null && !this.holoLogData.subtitle().isEmpty()) {
                Objects.requireNonNull(this.field_22793);
                currentContentHeight += 9 + 4;
            }
        }
        int displayedLines = this.player.getDisplayedLines().size();
        Objects.requireNonNull(this.field_22793);
        currentContentHeight += displayedLines * (9 + 2);
        String partialLine = this.player.getCurrentPartialLine();
        if (partialLine != null && !partialLine.isEmpty()) {
            Objects.requireNonNull(this.field_22793);
            currentContentHeight += 9 + 2;
        }
        return currentContentHeight;
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.method_25420(guiGraphics);
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.renderDefaultBackground(guiGraphics, this.leftPos, this.topPos);
        if (!this.playbackCompleted) {
            this.renderHologram(guiGraphics, this.leftPos, this.topPos, partialTick);
        }
        this.renderHolologTitleArea(guiGraphics, this.leftPos, this.topPos);
        this.renderText(guiGraphics, this.leftPos, this.topPos);
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        if (delta > 0.0) {
            this.scrollUp();
        } else if (delta < 0.0) {
            this.scrollDown();
        }
        return true;
    }

    public void method_25419() {
        if (this.player != null) {
            this.player.stop();
            this.player = null;
        }
        super.method_25419();
    }

    public boolean method_25421() {
        return false;
    }

    private void renderDefaultBackground(class_332 guiGraphics, int x, int y) {
        guiGraphics.method_25290(HOLOPAD_TEXTURE, x, y, 0.0f, 0.0f, 370, 250, 512, 256);
    }

    private void renderHologram(class_332 guiGraphics, int x, int y, float partialTick) {
        if (this.player == null) {
            return;
        }
        HoloLogDisplayRecipe displayRecipe = this.player.getCurrentDisplayRecipe();
        if (displayRecipe != null) {
            this.renderRecipe(guiGraphics, x, y, displayRecipe);
            return;
        }
        HoloLogDisplayEntity displayEntity = this.player.getCurrentDisplayEntity();
        if (displayEntity == null) {
            return;
        }
        class_4587 poseStack = guiGraphics.method_51448();
        poseStack.method_22903();
        int centerX = x + 16 + 169;
        int centerY = y + 16 + 50 + 0;
        if (displayEntity.type() == DisplayType.ITEM) {
            centerY -= 10;
        } else if (displayEntity.type() == DisplayType.ENTITY || displayEntity.type() == DisplayType.HOLO_ENTITY) {
            centerY += 20;
        }
        poseStack.method_46416((float)centerX, (float)centerY, 100.0f);
        float scale = displayEntity.scale() * 35.0f;
        if (displayEntity.type() == DisplayType.ITEM) {
            scale *= 2.5f;
        } else if (displayEntity.type() == DisplayType.BLOCK) {
            scale *= 2.0f;
        } else if (displayEntity.type() == DisplayType.ENTITY || displayEntity.type() == DisplayType.HOLO_ENTITY) {
            scale *= 1.95f;
        }
        poseStack.method_22905(scale, scale, scale);
        if (displayEntity.type() == DisplayType.ENTITY || displayEntity.type() == DisplayType.HOLO_ENTITY) {
            poseStack.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
            if (displayEntity.rotationX() != 0.0f) {
                poseStack.method_22907(class_7833.field_40714.rotationDegrees(displayEntity.rotationX()));
            }
            if (displayEntity.rotationY() != 0.0f) {
                poseStack.method_22907(class_7833.field_40716.rotationDegrees(displayEntity.rotationY()));
            }
            if (displayEntity.rotationZ() != 0.0f) {
                poseStack.method_22907(class_7833.field_40718.rotationDegrees(displayEntity.rotationZ()));
            }
        } else if (displayEntity.type() == DisplayType.ITEM) {
            poseStack.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(0.0f));
            if (displayEntity.rotationSpeed() > 0.0f && this.field_22787 != null && this.field_22787.field_1687 != null) {
                float time = this.field_22787.field_1687.method_8510();
                float rotationSpeed = displayEntity.rotationSpeed();
                poseStack.method_22907(class_7833.field_40716.rotationDegrees(time * rotationSpeed));
            }
            if (displayEntity.rotationX() != 0.0f) {
                poseStack.method_22907(class_7833.field_40714.rotationDegrees(displayEntity.rotationX()));
            }
            if (displayEntity.rotationY() != 0.0f) {
                poseStack.method_22907(class_7833.field_40716.rotationDegrees(displayEntity.rotationY()));
            }
            if (displayEntity.rotationZ() != 0.0f) {
                poseStack.method_22907(class_7833.field_40718.rotationDegrees(displayEntity.rotationZ()));
            }
        } else {
            poseStack.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
            if (displayEntity.rotationSpeed() > 0.0f && this.field_22787 != null && this.field_22787.field_1687 != null) {
                float time = this.field_22787.field_1687.method_8510();
                float rotationSpeed = displayEntity.rotationSpeed();
                poseStack.method_22907(class_7833.field_40716.rotationDegrees(time * rotationSpeed));
            }
            if (displayEntity.rotationX() != 0.0f) {
                poseStack.method_22907(class_7833.field_40714.rotationDegrees(displayEntity.rotationX()));
            }
            if (displayEntity.rotationY() != 0.0f) {
                poseStack.method_22907(class_7833.field_40716.rotationDegrees(displayEntity.rotationY()));
            }
            if (displayEntity.rotationZ() != 0.0f) {
                poseStack.method_22907(class_7833.field_40718.rotationDegrees(displayEntity.rotationZ()));
            }
            if (displayEntity.type() == DisplayType.BLOCK) {
                poseStack.method_22904(-0.5, -0.5, -0.5);
            }
        }
        this.player.renderDisplayEntity(poseStack, partialTick, 0xF000F0);
        poseStack.method_22909();
    }

    private void renderHolologTitleArea(class_332 guiGraphics, int x, int y) {
        if (this.player == null && this.holoLogData == null) {
            return;
        }
        int titleX = x + 24 + 4;
        int titleY = y + 94 + 2;
        if (this.player != null) {
            String subtitle;
            String title = this.player.getTitle();
            if (title != null && !title.isEmpty()) {
                guiGraphics.method_51433(this.field_22793, title, titleX, titleY, 65535, false);
                Objects.requireNonNull(this.field_22793);
                titleY += 9 + 2;
            }
            if ((subtitle = this.player.getSubtitle()) != null && !subtitle.isEmpty()) {
                guiGraphics.method_51433(this.field_22793, subtitle, titleX, titleY, 0xAAAAAA, false);
            }
        } else if (this.holoLogData != null) {
            if (this.holoLogData.title() != null) {
                guiGraphics.method_51433(this.field_22793, this.holoLogData.title(), titleX, titleY, 65535, false);
                Objects.requireNonNull(this.field_22793);
                titleY += 9 + 2;
            }
            if (this.holoLogData.subtitle() != null && !this.holoLogData.subtitle().isEmpty()) {
                guiGraphics.method_51433(this.field_22793, this.holoLogData.subtitle(), titleX, titleY, 0xAAAAAA, false);
            }
        }
    }

    private void renderText(class_332 guiGraphics, int x, int y) {
        int textX = x + 12 + 4;
        int textY = y + 118 + 4;
        guiGraphics.method_44379(x + 12, y + 118, x + 12 + 338, y + 118 + 120);
        if (this.player != null) {
            this.renderPlayerContent(guiGraphics, textX, textY - this.scrollOffset, y);
        } else if (this.holoLogData != null) {
            this.renderFallbackContent(guiGraphics, textX, textY - this.scrollOffset);
        } else {
            this.renderNoContent(guiGraphics, textX, textY);
        }
        guiGraphics.method_44380();
    }

    private void renderPlayerContent(class_332 guiGraphics, int textX, int yOffset, int areaY) {
        int maxY = areaY + 118 + 120 - 8;
        for (String line : this.player.getDisplayedLines()) {
            if (yOffset >= areaY + 118 && yOffset < maxY) {
                guiGraphics.method_51433(this.field_22793, line, textX, yOffset, 0xFFFFFF, false);
            }
            Objects.requireNonNull(this.field_22793);
            yOffset += 9 + 2;
        }
        String partialLine = this.player.getCurrentPartialLine();
        if (partialLine != null && !partialLine.isEmpty() && yOffset >= areaY + 118 && yOffset < maxY) {
            guiGraphics.method_51433(this.field_22793, partialLine, textX, yOffset, 0xFFFFFF, false);
        }
    }

    private void renderFallbackContent(class_332 guiGraphics, int textX, int yOffset) {
    }

    private void renderNoContent(class_332 guiGraphics, int textX, int textY) {
        String message = "No hololog content";
        int n = textX + (330 - this.field_22793.method_1727(message)) / 2;
        Objects.requireNonNull(this.field_22793);
        guiGraphics.method_51433(this.field_22793, message, n, textY + (112 - 9) / 2, 0xAAAAAA, false);
    }

    private void renderRecipe(class_332 guiGraphics, int x, int y, HoloLogDisplayRecipe displayRecipe) {
        if (this.field_22787 == null || this.field_22787.field_1687 == null) {
            return;
        }
        Optional recipeOpt = this.field_22787.field_1687.method_8433().method_8130(displayRecipe.recipeId());
        if (recipeOpt.isEmpty()) {
            log.warn("Recipe not found: {}", (Object)displayRecipe.recipeId());
            return;
        }
        class_1860 recipe = (class_1860)recipeOpt.get();
        int centerX = x + 16 + 169;
        int centerY = y + 16 + 50 - 15;
        ArrayList inputs = new ArrayList();
        try {
            if (!recipe.method_8117().isEmpty()) {
                recipe.method_8117().forEach(ingredient -> {
                    class_1799[] items = ingredient.method_8105();
                    if (items.length > 0) {
                        inputs.add(items[0]);
                    }
                });
            }
        }
        catch (Exception e) {
            log.error("Failed to get recipe inputs: {}", (Object)e.getMessage());
        }
        class_1799 output = recipe.method_8110(this.field_22787.field_1687.method_30349());
        int itemSize = 24;
        int spacing = 12;
        float inputScale = 1.5f * displayRecipe.scale();
        int gridSize = (int)Math.ceil(Math.sqrt(inputs.size()));
        int totalGridWidth = gridSize * itemSize + (gridSize - 1) * 4;
        int totalGridHeight = gridSize * itemSize + (gridSize - 1) * 4;
        int inputStartX = centerX - totalGridWidth - spacing - 10;
        int inputStartY = centerY - totalGridHeight / 2;
        class_4587 poseStack = guiGraphics.method_51448();
        for (int i = 0; i < inputs.size(); ++i) {
            class_1799 input = (class_1799)inputs.get(i);
            if (input.method_7960()) continue;
            int gridX = i % gridSize;
            int gridY = i / gridSize;
            int xPos = inputStartX + gridX * (itemSize + 4);
            int yPos = inputStartY + gridY * (itemSize + 4);
            poseStack.method_22903();
            poseStack.method_46416((float)xPos, (float)yPos, 0.0f);
            poseStack.method_22905(inputScale, inputScale, 1.0f);
            guiGraphics.method_51427(input, 0, 0);
            guiGraphics.method_51431(this.field_22793, input, 0, 0);
            poseStack.method_22909();
        }
        String arrow = "\u2192";
        float arrowScale = 2.5f;
        poseStack.method_22903();
        int arrowWidth = (int)((float)this.field_22793.method_1727(arrow) * arrowScale);
        Objects.requireNonNull(this.field_22793);
        int arrowHeight = (int)(9.0f * arrowScale);
        int arrowX = centerX - arrowWidth / 2;
        int arrowY = centerY - arrowHeight / 2;
        poseStack.method_46416((float)arrowX, (float)arrowY, 0.0f);
        poseStack.method_22905(arrowScale, arrowScale, 1.0f);
        guiGraphics.method_51433(this.field_22793, arrow, 0, 0, 65535, false);
        poseStack.method_22909();
        if (!output.method_7960()) {
            int outputX = centerX + spacing + 10;
            int outputY = centerY - itemSize / 2;
            float outputScale = 1.8f * displayRecipe.scale();
            poseStack.method_22903();
            poseStack.method_46416((float)outputX, (float)outputY, 0.0f);
            poseStack.method_22905(outputScale, outputScale, 1.0f);
            guiGraphics.method_51427(output, 0, 0);
            guiGraphics.method_51431(this.field_22793, output, 0, 0);
            poseStack.method_22909();
        }
    }

    private int calculateTotalTextHeight() {
        int n = this.wrappedTextLines.size();
        Objects.requireNonNull(this.field_22793);
        return n * (9 + 2);
    }
}

