/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.data.multitool;

import de.markusbordihn.scraptechworkshop.data.multitool.BatteryLevel;
import de.markusbordihn.scraptechworkshop.data.multitool.ScrapMultitoolData;
import de.markusbordihn.scraptechworkshop.data.multitool.ToolMode;
import net.minecraft.class_1799;
import net.minecraft.class_2487;

public record DisplayMode(class_1799 itemStack) {
    private static final String CUSTOM_MODEL_DATA_TAG = "CustomModelData";

    public void updateModel(ToolMode activeMode, BatteryLevel batteryLevel) {
        int customModelData = this.getModelDataForMode(activeMode, batteryLevel);
        class_2487 compoundTag = this.itemStack.method_7948();
        compoundTag.method_10569(CUSTOM_MODEL_DATA_TAG, customModelData);
    }

    private int getModelDataForMode(ToolMode activeMode, BatteryLevel batteryLevel) {
        if (!this.hasBattery()) {
            return 1;
        }
        if (activeMode == ToolMode.DEFAULT) {
            return this.getBatteryLevelModelData(batteryLevel);
        }
        return activeMode.getModelData();
    }

    private int getBatteryLevelModelData(BatteryLevel level) {
        return switch (level) {
            default -> throw new IncompatibleClassChangeError();
            case BatteryLevel.BATTERY_LEVEL_0 -> 1;
            case BatteryLevel.BATTERY_LEVEL_25 -> 2;
            case BatteryLevel.BATTERY_LEVEL_50 -> 3;
            case BatteryLevel.BATTERY_LEVEL_75 -> 4;
            case BatteryLevel.BATTERY_LEVEL_100 -> 5;
        };
    }

    private boolean hasBattery() {
        ScrapMultitoolData data = ScrapMultitoolData.fromItemStack(this.itemStack);
        return data.hasBattery();
    }
}

