/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.energy;

import de.markusbordihn.scraptechworkshop.data.multitool.ScrapMultitoolData;
import de.markusbordihn.scraptechworkshop.energy.EnergyManager;
import de.markusbordihn.scraptechworkshop.item.component.EnergyCellItem;
import net.minecraft.class_1792;
import net.minecraft.class_1799;

public interface EnergyCellConsumer {
    public int getMaxEnergy();

    default public class_1799 getBattery(class_1799 itemStack) {
        if (itemStack.method_7909() instanceof EnergyCellConsumer) {
            ScrapMultitoolData data = ScrapMultitoolData.fromItemStack(itemStack);
            return data.battery();
        }
        return class_1799.field_8037;
    }

    default public void setBattery(class_1799 consumer, class_1799 battery) {
        if (consumer.method_7909() instanceof EnergyCellConsumer) {
            ScrapMultitoolData data = ScrapMultitoolData.fromItemStack(consumer);
            ScrapMultitoolData updatedData = data.withBattery(battery);
            updatedData.saveToItemStack(consumer);
        }
    }

    default public boolean hasBattery(class_1799 consumer) {
        class_1799 battery = this.getBattery(consumer);
        return !battery.method_7960() && battery.method_7909() instanceof EnergyCellItem;
    }

    default public boolean hasEnergy(class_1799 consumer, int amount) {
        class_1799 battery = this.getBattery(consumer);
        if (!this.hasBattery(consumer)) {
            return false;
        }
        return EnergyManager.hasEnergyFromBattery(consumer, this.getMaxEnergy(), battery, amount);
    }

    default public boolean consumeEnergy(class_1799 itemStack, int amount) {
        if (!this.hasBattery(itemStack)) {
            return false;
        }
        class_1799 battery = this.getBattery(itemStack);
        class_1792 class_17922 = battery.method_7909();
        if (!(class_17922 instanceof EnergyCellItem)) {
            return false;
        }
        EnergyCellItem batteryItem = (EnergyCellItem)class_17922;
        if (batteryItem.getEnergy(battery) < amount) {
            return false;
        }
        batteryItem.consumeEnergy(battery, amount);
        this.setBattery(itemStack, battery);
        this.syncEnergyDisplay(itemStack);
        return true;
    }

    default public void syncEnergyDisplay(class_1799 itemStack) {
        if (!this.hasBattery(itemStack)) {
            EnergyManager.setEnergy(itemStack, this.getMaxEnergy(), 0);
            return;
        }
        class_1799 battery = this.getBattery(itemStack);
        class_1792 class_17922 = battery.method_7909();
        if (class_17922 instanceof EnergyCellItem) {
            EnergyCellItem batteryItem = (EnergyCellItem)class_17922;
            int batteryEnergy = batteryItem.getEnergy(battery);
            if (batteryEnergy <= 1) {
                class_1799 emptyBattery = batteryItem.createEmptyBattery();
                this.setBattery(itemStack, emptyBattery);
                EnergyManager.setEnergy(itemStack, this.getMaxEnergy(), 0);
                return;
            }
            EnergyManager.syncEnergyWithBattery(itemStack, this.getMaxEnergy(), battery);
        } else {
            EnergyManager.setEnergy(itemStack, this.getMaxEnergy(), 0);
        }
    }

    default public float getEnergyPercentage(class_1799 itemStack) {
        if (!this.hasBattery(itemStack)) {
            return 0.0f;
        }
        class_1799 battery = this.getBattery(itemStack);
        class_1792 class_17922 = battery.method_7909();
        if (class_17922 instanceof EnergyCellItem) {
            EnergyCellItem batteryItem = (EnergyCellItem)class_17922;
            int batteryEnergy = batteryItem.getEnergy(battery);
            return (float)batteryEnergy / 5000.0f;
        }
        return 0.0f;
    }
}

