/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.entity.robot.collectorstationrobot;

import de.markusbordihn.scraptechworkshop.data.collectorstation.CollectorStationStatus;
import de.markusbordihn.scraptechworkshop.entity.robot.collectorstationrobot.CollectorStationRobotEntity;
import de.markusbordihn.scraptechworkshop.pathfinding.ClientSideMovement;
import java.util.EnumSet;
import net.minecraft.class_1308;
import net.minecraft.class_1352;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;

public class ReturnToStationGoal
extends class_1352 {
    private static final double TELEPORT_DISTANCE_XZ = 64.0;
    private static final double TELEPORT_RADIUS = 16.0;
    private static final double REACH_DISTANCE = 0.25;
    private static final double LOOK_AHEAD_DISTANCE = 3.0;
    private static final int STUCK_THRESHOLD = 100;
    private final CollectorStationRobotEntity robot;
    private final double speedModifier;
    private int stuckCounter = 0;
    private int rotationDelay = 0;
    private double targetX;
    private double targetY;
    private double targetZ;

    public ReturnToStationGoal(CollectorStationRobotEntity robot, double speedModifier) {
        this.robot = robot;
        this.speedModifier = speedModifier;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        return this.robot.getStatus() == CollectorStationStatus.RETURNING && this.robot.getStationPos() != null && !this.robot.getStationPos().equals((Object)class_2338.field_10980);
    }

    public boolean method_6266() {
        class_2338 stationPos = this.robot.getStationPos();
        if (stationPos == null) {
            return false;
        }
        double distance = this.robot.method_19538().method_1022(new class_243(this.targetX, this.targetY, this.targetZ));
        return this.robot.getStatus() == CollectorStationStatus.RETURNING && distance > 0.25;
    }

    public void method_6269() {
        this.stuckCounter = 0;
        this.rotationDelay = 10;
        class_2338 stationPos = this.robot.getStationPos();
        class_2350 facing = this.robot.getFacing();
        if (stationPos == null || facing == null) {
            return;
        }
        class_2338 targetBlockPos = stationPos.method_10081(facing.method_10163());
        this.targetX = (double)targetBlockPos.method_10263() + 0.5;
        this.targetY = targetBlockPos.method_10264();
        this.targetZ = (double)targetBlockPos.method_10260() + 0.5;
        if (this.shouldTeleport()) {
            this.teleportNearStation();
            this.rotationDelay = 20;
        }
    }

    public void method_6270() {
        this.robot.method_18799(class_243.field_1353);
        this.robot.method_6125(0.0f);
        this.robot.setMovingFromGoal(false);
    }

    public void method_6268() {
        if (this.robot.getStationPos() == null) {
            return;
        }
        double distance = this.robot.method_19538().method_1022(new class_243(this.targetX, this.targetY, this.targetZ));
        if (distance < 0.25) {
            this.method_6270();
            return;
        }
        if (this.rotationDelay > 0) {
            --this.rotationDelay;
            this.robot.method_18800(0.0, this.robot.method_18798().field_1351, 0.0);
            this.robot.method_6125(0.0f);
            this.robot.setMovingFromGoal(false);
            this.robot.method_5988().method_20248(this.targetX, this.targetY, this.targetZ);
            return;
        }
        boolean isMoving = ClientSideMovement.moveTowards((class_1308)this.robot, this.targetX, this.targetY, this.targetZ, this.speedModifier * 0.04);
        this.robot.setMovingFromGoal(isMoving);
        if (!isMoving) {
            this.handleStuck();
        } else {
            this.stuckCounter = 0;
            this.updateLookDirection();
        }
    }

    private boolean shouldTeleport() {
        double distanceXZ = Math.sqrt(Math.pow(this.targetX - this.robot.method_23317(), 2.0) + Math.pow(this.targetZ - this.robot.method_23321(), 2.0));
        return distanceXZ > 64.0;
    }

    private void teleportNearStation() {
        double angle = this.robot.method_6051().method_43058() * 2.0 * Math.PI;
        double distance = 8.0 + this.robot.method_6051().method_43058() * 16.0 * 0.5;
        double teleportX = this.targetX + Math.cos(angle) * distance;
        double teleportZ = this.targetZ + Math.sin(angle) * distance;
        class_243 safePos = ClientSideMovement.findGroundPosition(this.robot.method_37908(), teleportX, this.targetY, teleportZ, 5);
        if (safePos != null) {
            this.robot.method_5814(safePos.field_1352, safePos.field_1351, safePos.field_1350);
        } else {
            safePos = ClientSideMovement.findGroundPosition(this.robot.method_37908(), this.targetX, this.targetY, this.targetZ, 5);
            if (safePos != null) {
                this.robot.method_5814(safePos.field_1352, safePos.field_1351, safePos.field_1350);
            }
        }
    }

    private void handleStuck() {
        ++this.stuckCounter;
        if (this.stuckCounter >= 100 && this.shouldTeleport()) {
            this.teleportNearStation();
            this.stuckCounter = 0;
            this.rotationDelay = 10;
        }
    }

    private void updateLookDirection() {
        this.robot.method_5962().method_6239(this.targetX, this.targetY, this.targetZ, this.speedModifier);
        double dx = this.targetX - this.robot.method_23317();
        double dy = this.targetY - this.robot.method_23318();
        double dz = this.targetZ - this.robot.method_23321();
        double dist = Math.sqrt(dx * dx + dz * dz);
        if (dist > 0.1) {
            double lookX = this.robot.method_23317() + dx / dist * 3.0;
            double lookY = this.robot.method_23320() + Math.max(0.0, dy * 0.3);
            double lookZ = this.robot.method_23321() + dz / dist * 3.0;
            this.robot.method_5988().method_20248(lookX, lookY, lookZ);
        }
    }
}

