/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.block.entity.floatingscrapcollector;

import de.markusbordihn.scraptechworkshop.block.entity.AbstractWorkshopBlockEntity;
import de.markusbordihn.scraptechworkshop.block.entity.floatingscrapcollector.FloatingScrapCollectorContainer;
import de.markusbordihn.scraptechworkshop.block.floatingscrapcollector.FloatingScrapCollectorBlock;
import de.markusbordihn.scraptechworkshop.data.floatingscrapcollector.FloatingScrapCollectorStatus;
import de.markusbordihn.scraptechworkshop.data.floatingscrapcollector.ScrapFilterType;
import de.markusbordihn.scraptechworkshop.item.ScrapFilterItem;
import de.markusbordihn.scraptechworkshop.menu.FloatingScrapCollectorMenu;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class FloatingScrapCollectorBlockEntity
extends AbstractWorkshopBlockEntity {
    private static final String TRANSLATION_KEY = "container.scrap_tech_workshop.floating_scrap_collector";
    private static final String PROGRESS_TAG = "Progress";
    private static final String MAX_PROGRESS_TAG = "MaxProgress";
    private static final int DATA_PROGRESS = 0;
    private static final int DATA_MAX_PROGRESS = 1;
    private static final int DATA_COUNT = 2;
    private static final int MIN_COLLECTION_TIME = 2400;
    private static final int MAX_COLLECTION_TIME = 4800;
    public static BlockEntityType<FloatingScrapCollectorBlockEntity> TYPE;
    private final FloatingScrapCollectorContainer container;
    private int progress = 0;
    private int maxProgress = 2400;
    private final ContainerData containerData = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> FloatingScrapCollectorBlockEntity.this.progress;
                case 1 -> FloatingScrapCollectorBlockEntity.this.maxProgress;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    FloatingScrapCollectorBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    FloatingScrapCollectorBlockEntity.this.maxProgress = value;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };

    public FloatingScrapCollectorBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(TYPE, blockPos, blockState);
        this.container = new FloatingScrapCollectorContainer(this);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, FloatingScrapCollectorBlockEntity blockEntity) {
        if (!level.f_46443_) {
            blockEntity.serverTick(level, blockPos, blockState);
        }
    }

    @Override
    protected NonNullList<ItemStack> getItems() {
        return this.container.getItems();
    }

    protected int getTotalSlots() {
        return 10;
    }

    @Override
    protected WorldlyContainer getContainerDelegate() {
        return this.container;
    }

    private void serverTick(Level level, BlockPos blockPos, BlockState blockState) {
        ItemStack netStack = this.container.m_8020_(0);
        FloatingScrapCollectorStatus newStatus = this.determineStatus(netStack);
        if (newStatus == FloatingScrapCollectorStatus.WORKING) {
            ++this.progress;
            if (this.progress >= this.maxProgress) {
                this.collectScrap(level, blockPos, netStack);
                this.progress = 0;
                this.maxProgress = 2400 + level.m_213780_().m_188503_(2400);
            }
        } else {
            this.progress = 0;
        }
        this.setStatus(blockState, newStatus);
    }

    private FloatingScrapCollectorStatus determineStatus(ItemStack netStack) {
        if (netStack.m_41619_() || !(netStack.m_41720_() instanceof ScrapFilterItem)) {
            return FloatingScrapCollectorStatus.EMPTY;
        }
        if (ScrapFilterItem.getDurability(netStack) <= 0) {
            return FloatingScrapCollectorStatus.EMPTY;
        }
        if (this.isOutputFull()) {
            return FloatingScrapCollectorStatus.FULL;
        }
        return FloatingScrapCollectorStatus.WORKING;
    }

    private boolean isOutputFull() {
        for (int i = 1; i < 10; ++i) {
            ItemStack stack = this.container.m_8020_(i);
            if (!stack.m_41619_() && stack.m_41613_() >= stack.m_41741_()) continue;
            return false;
        }
        return true;
    }

    private void collectScrap(Level level, BlockPos blockPos, ItemStack netStack) {
        Item item = netStack.m_41720_();
        if (!(item instanceof ScrapFilterItem)) {
            return;
        }
        ScrapFilterItem filterItem = (ScrapFilterItem)item;
        ScrapFilterType filterType = filterItem.getFilterType();
        int waterBlocks = this.countSurroundingWater(level, blockPos);
        float waterQualityBonus = this.getWaterQualityBonus(waterBlocks);
        List<ItemStack> loot = this.generateLoot(level, filterType, waterQualityBonus);
        for (ItemStack item2 : loot) {
            if (!this.addToOutput(item2)) break;
        }
        ScrapFilterItem.consumeDurability(netStack, 1);
        if (ScrapFilterItem.getDurability(netStack) <= 0) {
            this.container.m_6836_(0, ItemStack.f_41583_);
        }
        this.m_6596_();
    }

    private int countSurroundingWater(Level level, BlockPos pos) {
        int waterCount = 0;
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                BlockPos checkPos = pos.m_7918_(x, 0, z);
                FluidState fluid = level.m_6425_(checkPos);
                if (fluid.m_76152_() == Fluids.f_76193_) {
                    ++waterCount;
                    continue;
                }
                if (fluid.m_76152_() != Fluids.f_76192_) continue;
                ++waterCount;
            }
        }
        BlockPos belowPos = pos.m_7495_();
        FluidState fluidBelow = level.m_6425_(belowPos);
        if (fluidBelow.m_76152_() == Fluids.f_76193_) {
            ++waterCount;
        } else if (fluidBelow.m_76152_() == Fluids.f_76192_) {
            ++waterCount;
        }
        return waterCount;
    }

    private float getWaterQualityBonus(int waterBlocks) {
        if (waterBlocks >= 9) {
            return 0.75f;
        }
        if (waterBlocks >= 7) {
            return 0.5f;
        }
        if (waterBlocks >= 4) {
            return 0.25f;
        }
        return 0.0f;
    }

    private List<ItemStack> generateLoot(Level level, ScrapFilterType filterType, float waterQualityBonus) {
        if (!(level instanceof ServerLevel)) {
            return new ArrayList<ItemStack>();
        }
        ServerLevel serverLevel = (ServerLevel)level;
        String lootTablePath = "scrap_tech_workshop:gameplay/floating_scrap_collector/" + filterType.m_7912_();
        ResourceLocation lootTableId = new ResourceLocation(lootTablePath);
        LootTable lootTable = serverLevel.m_7654_().m_278653_().m_278676_(lootTableId);
        if (lootTable == LootTable.f_79105_) {
            return new ArrayList<ItemStack>();
        }
        LootParams lootParams = new LootParams.Builder(serverLevel).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)this.f_58858_)).m_287235_(LootContextParamSets.f_81410_);
        ObjectArrayList loot = lootTable.m_287195_(lootParams);
        if (waterQualityBonus > 0.0f && level.m_213780_().m_188501_() < waterQualityBonus) {
            ObjectArrayList bonusLoot = lootTable.m_287195_(lootParams);
            loot.addAll(bonusLoot);
        }
        return loot;
    }

    private boolean addToOutput(ItemStack newItem) {
        if (newItem.m_41619_()) {
            return false;
        }
        for (int i = 1; i < 10; ++i) {
            int space;
            ItemStack existing = this.container.m_8020_(i);
            if (existing.m_41619_()) {
                this.container.m_6836_(i, newItem.m_41777_());
                return true;
            }
            if (!ItemStack.m_150942_((ItemStack)existing, (ItemStack)newItem) || (space = existing.m_41741_() - existing.m_41613_()) <= 0) continue;
            int amountToAdd = Math.min(space, newItem.m_41613_());
            existing.m_41769_(amountToAdd);
            newItem.m_41774_(amountToAdd);
            if (!newItem.m_41619_()) continue;
            return true;
        }
        return newItem.m_41619_();
    }

    private void setStatus(BlockState blockState, FloatingScrapCollectorStatus newStatus) {
        Level currentLevel = this.m_58904_();
        if (currentLevel != null && blockState.m_61138_(FloatingScrapCollectorBlock.STATUS) && blockState.m_61143_(FloatingScrapCollectorBlock.STATUS) != newStatus) {
            currentLevel.m_7731_(this.f_58858_, (BlockState)blockState.m_61124_(FloatingScrapCollectorBlock.STATUS, (Comparable)((Object)newStatus)), 3);
        }
    }

    public FloatingScrapCollectorContainer getContainer() {
        return this.container;
    }

    public ContainerData getContainerData() {
        return this.containerData;
    }

    @Override
    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        this.progress = compoundTag.m_128451_(PROGRESS_TAG);
        this.maxProgress = compoundTag.m_128451_(MAX_PROGRESS_TAG);
    }

    @Override
    protected void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        compoundTag.m_128405_(PROGRESS_TAG, this.progress);
        compoundTag.m_128405_(MAX_PROGRESS_TAG, this.maxProgress);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)TRANSLATION_KEY);
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
        return new FloatingScrapCollectorMenu(windowId, playerInventory, this, this.containerData);
    }
}

