/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.config;

import de.markusbordihn.scraptechworkshop.config.Config;
import java.io.File;
import java.util.Properties;
import java.util.Set;

public class RecyclerConfig
extends Config {
    public static final String CONFIG_FILE_NAME = "recycler.cfg";
    public static final String CONFIG_FILE_HEADER = " Recycler Configuration\n\n This configuration file allows you to define the general settings for the Recycler system.\n processTime: Time in ticks for processing items (default: 2000, ~100 seconds at 20 TPS)\n enableEnergy: Whether the recycler requires energy (default: false)\n energyPerOperation: Energy required per operation when energy is enabled (default: 200)\n durabilityScaling: Whether processing time scales with item durability (default: true)\n byproductMode: Mode for byproduct generation - \"multi\" or \"single\" (default: \"multi\")\n maxByproductsPerOperation: Maximum number of byproducts per operation (default: 2)\n deniedItems: Comma-separated list of item IDs that cannot be recycled\n allowedItems: Comma-separated list of item IDs that can be recycled (empty = all allowed)\n progressUpdateInterval: Interval in ticks for progress updates (default: 5)\n\n";
    public static final int DEFAULT_PROCESS_TIME = 2000;
    public static final boolean DEFAULT_ENABLE_ENERGY = false;
    public static final int DEFAULT_ENERGY_PER_OPERATION = 200;
    public static final boolean DEFAULT_DURABILITY_SCALING = true;
    public static final String DEFAULT_BYPRODUCT_MODE = "multi";
    public static final int DEFAULT_MAX_BYPRODUCTS_PER_OPERATION = 2;
    public static final int DEFAULT_PROGRESS_UPDATE_INTERVAL = 5;
    public static int processTime = 2000;
    public static boolean enableEnergy = false;
    public static int energyPerOperation = 200;
    public static boolean durabilityScaling = true;
    public static String byproductMode = "multi";
    public static int maxByproductsPerOperation = 2;
    public static Set<String> deniedItems = Set.of();
    public static Set<String> allowedItems = Set.of();
    public static int progressUpdateInterval = 5;

    public static void registerConfig() {
        RecyclerConfig.registerConfigFile(CONFIG_FILE_NAME, CONFIG_FILE_HEADER);
        RecyclerConfig.parseConfigFile();
    }

    public static void parseConfigFile() {
        File configFile = RecyclerConfig.getConfigFile(CONFIG_FILE_NAME);
        Properties properties = RecyclerConfig.readConfigFile(configFile);
        Properties unmodifiedProperties = (Properties)properties.clone();
        processTime = RecyclerConfig.parseConfigValue(properties, "processTime", processTime);
        enableEnergy = RecyclerConfig.parseConfigValue(properties, "enableEnergy", enableEnergy);
        energyPerOperation = RecyclerConfig.parseConfigValue(properties, "energyPerOperation", energyPerOperation);
        durabilityScaling = RecyclerConfig.parseConfigValue(properties, "durabilityScaling", durabilityScaling);
        byproductMode = RecyclerConfig.parseConfigValue(properties, "byproductMode", byproductMode);
        maxByproductsPerOperation = RecyclerConfig.parseConfigValue(properties, "maxByproductsPerOperation", maxByproductsPerOperation);
        deniedItems = RecyclerConfig.parseConfigValue(properties, "deniedItems", deniedItems);
        allowedItems = RecyclerConfig.parseConfigValue(properties, "allowedItems", allowedItems);
        progressUpdateInterval = RecyclerConfig.parseConfigValue(properties, "progressUpdateInterval", progressUpdateInterval);
        RecyclerConfig.updateConfigFileIfChanged(configFile, CONFIG_FILE_HEADER, properties, unmodifiedProperties);
    }

    public static boolean isItemDenied(String itemId) {
        return deniedItems.contains(itemId);
    }

    public static boolean isItemAllowed(String itemId) {
        return allowedItems.isEmpty() || allowedItems.contains(itemId);
    }

    public static boolean isMultiByproductMode() {
        return DEFAULT_BYPRODUCT_MODE.equals(byproductMode);
    }
}

