/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.entity.robot.collectorstationrobot;

import de.markusbordihn.scraptechworkshop.data.collectorstation.CollectorStationStatus;
import de.markusbordihn.scraptechworkshop.entity.robot.BaseRobotEntity;
import de.markusbordihn.scraptechworkshop.entity.robot.collectorstationrobot.RandomCollectGoal;
import de.markusbordihn.scraptechworkshop.entity.robot.collectorstationrobot.ReturnToStationGoal;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class CollectorStationRobotEntity
extends BaseRobotEntity {
    public static final String ID = "collector_station_robot";
    private CollectorStationStatus status = CollectorStationStatus.CHARGING;
    private float animationSpeed = 0.0f;
    private boolean isMovingFromGoal = false;
    private boolean isDigging = false;

    public CollectorStationRobotEntity(EntityType<? extends BaseRobotEntity> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return CollectorStationRobotEntity.createBaseAttributes();
    }

    protected void m_8099_() {
    }

    public void registerClientSideGoals() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new ReturnToStationGoal(this, 1.2));
        this.f_21345_.m_25352_(2, (Goal)new RandomCollectGoal(this, 0.7, 64));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
    }

    @Override
    public void m_8119_() {
        if (!this.m_9236_().f_46443_) {
            return;
        }
        super.m_8119_();
        this.updateWalkAnimation();
        this.tickAiAndNavigation();
    }

    private void updateWalkAnimation() {
        double dz;
        double dx = this.m_20185_() - this.f_19854_;
        float distanceMoved = (float)Math.sqrt(dx * dx + (dz = this.m_20189_() - this.f_19856_) * dz);
        this.animationSpeed = distanceMoved > 0.01f ? Math.min(1.0f, this.animationSpeed + 0.15f) : Math.max(0.0f, this.animationSpeed - 0.15f);
        this.f_267362_.m_267566_(this.animationSpeed, 0.4f);
    }

    private void tickAiAndNavigation() {
        this.f_21345_.m_25373_();
        this.f_21344_.m_7638_();
        this.f_21365_.m_8128_();
        this.f_21342_.m_8126_();
    }

    private void onStatusChanged(CollectorStationStatus oldStatus, CollectorStationStatus newStatus) {
        if (newStatus == CollectorStationStatus.COLLECTING || newStatus == CollectorStationStatus.RETURNING) {
            return;
        }
        this.m_21573_().m_26573_();
    }

    public CollectorStationStatus getStatus() {
        return this.status;
    }

    public void setStatus(CollectorStationStatus newStatus) {
        if (this.status != newStatus) {
            CollectorStationStatus oldStatus = this.status;
            this.status = newStatus;
            this.onStatusChanged(oldStatus, newStatus);
        }
    }

    public boolean isMovingFromGoal() {
        return this.isMovingFromGoal;
    }

    public void setMovingFromGoal(boolean moving) {
        this.isMovingFromGoal = moving;
    }

    public boolean isDigging() {
        return this.isDigging;
    }

    public void setDigging(boolean digging) {
        this.isDigging = digging;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return true;
    }
}

