/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.item.hololog;

import de.markusbordihn.scraptechworkshop.client.ClientHelper;
import de.markusbordihn.scraptechworkshop.data.hololog.HoloLogManager;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HoloPadItem
extends Item {
    public static final String ID_PREFIX = "holo_pad_";
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");
    private static final String TRANSLATION_KEY_PREFIX = "item.scrap_tech_workshop.holo_pad";
    private final ResourceLocation holoLogId;

    public HoloPadItem(ResourceLocation holoLogId, Item.Properties properties) {
        super(properties);
        this.holoLogId = holoLogId;
    }

    public ResourceLocation getHoloLogId() {
        return this.holoLogId;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!level.f_46443_) {
            if (!HoloLogManager.isValidHoloLog(this.holoLogId)) {
                player.m_5661_((Component)Component.m_237115_((String)"item.scrap_tech_workshop.holo_pad.invalid_hololog").m_130940_(ChatFormatting.RED), true);
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            log.info("{} Player {} used HoloPad with hololog: {}", (Object)"Scrap Tech Workshop", (Object)player.m_7755_().getString(), (Object)this.holoLogId);
            if (player instanceof ServerPlayer) {
                AdvancementProgress progress;
                Advancement advancement;
                MinecraftServer server;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (this.holoLogId.equals((Object)new ResourceLocation("scrap_tech_workshop", "holologs/tutorial/scavenging_field_briefing_01")) && (server = serverPlayer.m_20194_()) != null && (advancement = server.m_129889_().m_136041_(new ResourceLocation("scrap_tech_workshop", "hololog/scavenging_basics"))) != null && !(progress = serverPlayer.m_8960_().m_135996_(advancement)).m_8193_()) {
                    for (String criterion : progress.m_8219_()) {
                        serverPlayer.m_8960_().m_135988_(advancement, criterion);
                    }
                }
            }
        } else {
            ClientHelper.openHoloPadScreen(this.holoLogId);
        }
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.f_46443_);
    }

    public Component m_7626_(ItemStack stack) {
        return HoloLogManager.loadHoloLog(this.holoLogId).map(data -> Component.m_237113_((String)("HoloPad: " + data.title()))).orElse(super.m_7626_(stack));
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltipComponents, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltipComponents, flag);
        HoloLogManager.loadHoloLog(this.holoLogId).ifPresent(data -> {
            tooltipComponents.add((Component)Component.m_237113_((String)("\"" + data.title() + "\"")).m_130940_(ChatFormatting.AQUA));
            if (data.subtitle() != null && !data.subtitle().isEmpty()) {
                tooltipComponents.add((Component)Component.m_237113_((String)data.subtitle()).m_130940_(ChatFormatting.DARK_GRAY));
            }
        });
        tooltipComponents.add((Component)Component.m_237115_((String)"item.scrap_tech_workshop.holo_pad.description").m_130940_(ChatFormatting.GRAY));
        tooltipComponents.add((Component)Component.m_237115_((String)"item.scrap_tech_workshop.holo_pad.holo_log").m_7220_((Component)Component.m_237113_((String)(": " + String.valueOf(this.holoLogId)))).m_130940_(ChatFormatting.GRAY));
    }
}

