/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.registry.item.hololog;

import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HoloLogRegistry {
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");
    private static final Map<String, ResourceLocation> HOLO_PAD_REGISTRY = new LinkedHashMap<String, ResourceLocation>();
    private static final Map<String, ResourceLocation> HOLO_CUBE_REGISTRY = new LinkedHashMap<String, ResourceLocation>();

    private HoloLogRegistry() {
    }

    public static void registerHoloPad(String itemId, ResourceLocation holoLogLocation) {
        HOLO_PAD_REGISTRY.put(itemId, holoLogLocation);
        log.debug("Registered HoloPad: holo_pad_{} -> {}", (Object)itemId, (Object)holoLogLocation);
    }

    public static void registerHoloCube(String itemId, ResourceLocation holoLogLocation) {
        HOLO_CUBE_REGISTRY.put(itemId, holoLogLocation);
        log.debug("Registered HoloCube: holo_cube_{} -> {}", (Object)itemId, (Object)holoLogLocation);
    }

    public static Map<String, ResourceLocation> getHoloPadRegistry() {
        return HOLO_PAD_REGISTRY;
    }

    public static Map<String, ResourceLocation> getHoloCubeRegistry() {
        return HOLO_CUBE_REGISTRY;
    }

    public static ResourceLocation getHoloPadHoloLog(String itemId) {
        return HOLO_PAD_REGISTRY.get(itemId);
    }

    public static ResourceLocation getHoloCubeHoloLog(String itemId) {
        return HOLO_CUBE_REGISTRY.get(itemId);
    }

    static {
        HoloLogRegistry.registerHoloPad("introduction", new ResourceLocation("scrap_tech_workshop", "holologs/intro/introduction"));
        HoloLogRegistry.registerHoloPad("scavenging_field_briefing_01", new ResourceLocation("scrap_tech_workshop", "holologs/tutorial/scavenging_field_briefing_01"));
        HoloLogRegistry.registerHoloPad("scavenging_field_briefing_02", new ResourceLocation("scrap_tech_workshop", "holologs/tutorial/scavenging_field_briefing_02"));
        HoloLogRegistry.registerHoloPad("engineering_briefing_01", new ResourceLocation("scrap_tech_workshop", "holologs/tutorial/engineering_briefing_01"));
        HoloLogRegistry.registerHoloPad("engineering_briefing_02", new ResourceLocation("scrap_tech_workshop", "holologs/tutorial/engineering_briefing_02"));
        HoloLogRegistry.registerHoloCube("introduction", new ResourceLocation("scrap_tech_workshop", "holologs/intro/introduction"));
    }
}

