/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.block.entity.collectorstation;

import de.markusbordihn.scraptechworkshop.block.entity.collectorstation.CollectorStationBlockEntity;
import de.markusbordihn.scraptechworkshop.item.component.EnergyCellItem;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class CollectorStationContainer
implements WorldlyContainer {
    private final NonNullList<ItemStack> items;
    private final CollectorStationBlockEntity blockEntity;

    public CollectorStationContainer(CollectorStationBlockEntity blockEntity) {
        this.blockEntity = blockEntity;
        this.items = NonNullList.m_122780_((int)29, (Object)ItemStack.f_41583_);
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int slot) {
        return slot >= 0 && slot < this.items.size() ? (ItemStack)this.items.get(slot) : ItemStack.f_41583_;
    }

    public ItemStack m_7407_(int slot, int amount) {
        ItemStack itemStack = ContainerHelper.m_18969_(this.items, (int)slot, (int)amount);
        if (!itemStack.m_41619_()) {
            this.m_6596_();
        }
        return itemStack;
    }

    public ItemStack m_8016_(int slot) {
        return ContainerHelper.m_18966_(this.items, (int)slot);
    }

    public void m_6836_(int slot, ItemStack itemStack) {
        if (slot >= 0 && slot < this.items.size()) {
            this.items.set(slot, (Object)itemStack);
            if (itemStack.m_41613_() > this.m_6893_()) {
                itemStack.m_41764_(this.m_6893_());
            }
            this.m_6596_();
        }
    }

    public void m_6596_() {
        if (this.blockEntity != null) {
            this.blockEntity.m_6596_();
        }
    }

    public boolean m_6542_(Player player) {
        if (this.blockEntity == null || this.blockEntity.m_58904_() == null) {
            return false;
        }
        return Container.m_272074_((BlockEntity)this.blockEntity, (Player)player);
    }

    public void m_6211_() {
        this.items.clear();
    }

    public boolean m_7013_(int slot, ItemStack itemStack) {
        if (slot == 0) {
            return itemStack.m_41720_() instanceof EnergyCellItem;
        }
        if (slot >= 1 && slot <= 24) {
            return true;
        }
        if (slot >= 25 && slot <= 28) {
            return this.isValidUpgrade(itemStack);
        }
        return false;
    }

    private boolean isValidUpgrade(ItemStack itemStack) {
        String itemName = itemStack.m_41720_().toString().toLowerCase();
        return itemName.contains("upgrade") || itemName.contains("module");
    }

    public int[] m_7071_(Direction direction) {
        if (direction == Direction.UP) {
            int[] storageSlots = new int[24];
            for (int i = 0; i < 24; ++i) {
                storageSlots[i] = 1 + i;
            }
            return storageSlots;
        }
        if (direction == Direction.DOWN) {
            int[] storageSlots = new int[24];
            for (int i = 0; i < 24; ++i) {
                storageSlots[i] = 1 + i;
            }
            return storageSlots;
        }
        int[] storageSlots = new int[24];
        for (int i = 0; i < 24; ++i) {
            storageSlots[i] = 1 + i;
        }
        return storageSlots;
    }

    public boolean m_7155_(int slot, ItemStack itemStack, Direction direction) {
        return slot >= 1 && slot <= 24 && direction == Direction.UP;
    }

    public boolean m_7157_(int slot, ItemStack itemStack, Direction direction) {
        return slot >= 1 && slot <= 24;
    }
}

