/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.block.entity.recycler;

import de.markusbordihn.scraptechworkshop.block.entity.recycler.RecyclerRecipeHandler;
import de.markusbordihn.scraptechworkshop.block.recycler.RecyclerBlock;
import de.markusbordihn.scraptechworkshop.data.recycler.RecyclerStatus;
import de.markusbordihn.scraptechworkshop.recipe.recycler.RecyclerRecipe;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class RecyclerTickProcessor {
    private static final int NO_RECIPE_COOLDOWN = 40;
    private static final int DONE_DISPLAY_TIME = 20;
    private static final int PROGRESS_DECAY_RATE = 2;

    public static TickResult processNoRecipeStatus(RecyclerState state) {
        --state.noRecipeTimer;
        if (state.noRecipeTimer <= 0) {
            return new TickResult(RecyclerStatus.IDLE, true);
        }
        return new TickResult(RecyclerStatus.NO_RECIPE, false);
    }

    public static TickResult processDoneStatus(RecyclerState state) {
        --state.doneTimer;
        if (state.doneTimer <= 0) {
            state.currentRecipe = RecyclerRecipeHandler.findRecipe(state.level, state.getInputStack());
            if (state.currentRecipe != null && RecyclerRecipeHandler.canProcessRecipe(state.currentRecipe, state.getInputStack(), state.items)) {
                state.progress = 0;
                return new TickResult(RecyclerStatus.WORKING, true);
            }
            return new TickResult(RecyclerStatus.IDLE, true);
        }
        return new TickResult(RecyclerStatus.DONE, false);
    }

    public static TickResult processActiveStatus(RecyclerState state, BlockState blockState) {
        boolean hasChanged = false;
        RecyclerStatus newStatus = (RecyclerStatus)((Object)blockState.m_61143_(RecyclerBlock.STATUS));
        if (state.currentRecipe == null || !RecyclerRecipeHandler.canProcessRecipe(state.currentRecipe, state.getInputStack(), state.items)) {
            state.currentRecipe = RecyclerRecipeHandler.findRecipe(state.level, state.getInputStack());
            if (state.currentRecipe == null && !state.getInputStack().m_41619_()) {
                RecyclerTickProcessor.ejectInputItem(state, blockState);
                state.noRecipeTimer = 40;
                return new TickResult(RecyclerStatus.NO_RECIPE, true);
            }
            state.progress = 0;
            hasChanged = true;
        }
        if (state.currentRecipe != null && RecyclerRecipeHandler.canProcessRecipe(state.currentRecipe, state.getInputStack(), state.items)) {
            state.progress += state.speedMultiplier;
            newStatus = RecyclerStatus.WORKING;
            hasChanged = true;
            if (state.progress >= state.maxProgress) {
                RecyclerRecipeHandler.processRecipe(state.currentRecipe, state.getInputStack(), state.items);
                state.progress = 0;
                state.currentRecipe = null;
                newStatus = RecyclerStatus.DONE;
                state.doneTimer = 20;
            }
        } else if (state.currentRecipe != null && !RecyclerRecipeHandler.canProcessRecipe(state.currentRecipe, state.getInputStack(), state.items)) {
            ItemStack inputStack = state.getInputStack();
            newStatus = !inputStack.m_41619_() && state.currentRecipe.matchesInput(inputStack) ? RecyclerStatus.ERROR : RecyclerStatus.IDLE;
            state.progress = 0;
            hasChanged = true;
        } else if (state.progress > 0) {
            if (RecyclerRecipeHandler.findRecipe(state.level, state.getInputStack()) == null) {
                newStatus = RecyclerStatus.IDLE;
            }
            state.progress = Math.max(0, state.progress - 2);
            hasChanged = true;
            if (state.progress == 0) {
                newStatus = RecyclerStatus.IDLE;
            }
        } else {
            newStatus = RecyclerStatus.IDLE;
        }
        return new TickResult(newStatus, hasChanged);
    }

    private static void ejectInputItem(RecyclerState state, BlockState blockState) {
        ItemStack inputStack = state.getInputStack();
        if (inputStack.m_41619_()) {
            return;
        }
        Direction backDirection = ((Direction)blockState.m_61143_((Property)RecyclerBlock.FACING)).m_122424_();
        BlockPos ejectPos = state.pos.m_121945_(backDirection);
        ItemStack itemToEject = inputStack.m_41777_();
        itemToEject.m_41764_(1);
        inputStack.m_41774_(1);
        Containers.m_18992_((Level)state.level, (double)((double)ejectPos.m_123341_() + 0.5), (double)((double)ejectPos.m_123342_() + 0.5), (double)((double)ejectPos.m_123343_() + 0.5), (ItemStack)itemToEject);
        RecyclerTickProcessor.addEjectionFeedback(state.level, state.pos, ejectPos);
    }

    private static void addEjectionFeedback(Level level, BlockPos recyclerPos, BlockPos ejectPos) {
        if (level.f_46443_) {
            return;
        }
        level.m_5594_(null, recyclerPos, SoundEvents.f_11797_, SoundSource.BLOCKS, 0.5f, 1.2f);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, (double)ejectPos.m_123341_() + 0.5, (double)ejectPos.m_123342_() + 0.5, (double)ejectPos.m_123343_() + 0.5, 3, 0.2, 0.1, 0.2, 0.02);
        }
    }

    public static class RecyclerState {
        public final Level level;
        public final BlockPos pos;
        public final ItemStack[] items;
        public final int maxProgress;
        public final int speedMultiplier;
        public int progress;
        public int noRecipeTimer;
        public int doneTimer;
        public RecyclerRecipe currentRecipe;

        public RecyclerState(Level level, BlockPos pos, ItemStack[] items, int progress, int maxProgress, int noRecipeTimer, int doneTimer, RecyclerRecipe currentRecipe, int speedMultiplier) {
            this.level = level;
            this.pos = pos;
            this.items = items;
            this.progress = progress;
            this.maxProgress = maxProgress;
            this.noRecipeTimer = noRecipeTimer;
            this.doneTimer = doneTimer;
            this.currentRecipe = currentRecipe;
            this.speedMultiplier = speedMultiplier;
        }

        public ItemStack getInputStack() {
            return this.items[0];
        }
    }

    public static class TickResult {
        public final RecyclerStatus newStatus;
        public final boolean hasChanged;

        public TickResult(RecyclerStatus newStatus, boolean hasChanged) {
            this.newStatus = newStatus;
            this.hasChanged = hasChanged;
        }
    }
}

