/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import de.markusbordihn.scraptechworkshop.entity.BaseRobotEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class BaseRobotModel<T extends BaseRobotEntity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("scrap_tech_workshop", "base_robot"), "main");
    protected final ModelPart left_arm;
    protected final ModelPart right_arm;
    protected final ModelPart left_front_wheel;
    protected final ModelPart left_back_wheel;
    protected final ModelPart right_front_wheel;
    protected final ModelPart right_back_wheel;
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart arms;
    private final ModelPart wheels;
    private final ModelPart left_wheel;
    private final ModelPart right_wheel;

    public BaseRobotModel(ModelPart root) {
        this.head = root.m_171324_("head");
        this.body = root.m_171324_("body");
        this.arms = root.m_171324_("arms");
        this.left_arm = this.arms.m_171324_("left_arm");
        this.right_arm = this.arms.m_171324_("right_arm");
        this.wheels = root.m_171324_("wheels");
        this.left_wheel = this.wheels.m_171324_("left_wheel");
        this.left_front_wheel = this.left_wheel.m_171324_("left_front_wheel");
        this.left_back_wheel = this.left_wheel.m_171324_("left_back_wheel");
        this.right_wheel = this.wheels.m_171324_("right_wheel");
        this.right_front_wheel = this.right_wheel.m_171324_("right_front_wheel");
        this.right_back_wheel = this.right_wheel.m_171324_("right_back_wheel");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(24, 30).m_171488_(2.0f, -4.75f, -3.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-4.0f, -2.0f, -4.0f, 8.0f, 4.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)15.0f, (float)0.0f));
        partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 30).m_171488_(-1.5f, -1.875f, -1.5f, 3.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(0, 12).m_171488_(-3.0f, -0.625f, -3.0f, 6.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)18.125f, (float)0.0f));
        PartDefinition arms = partdefinition.m_171599_("arms", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        arms.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(28, 30).m_171480_().m_171488_(-1.0f, -0.75f, -0.5f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-3.0f, (float)-5.5f, (float)0.0f));
        arms.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(28, 30).m_171488_(0.0f, -0.75f, -0.5f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)-5.5f, (float)0.0f));
        PartDefinition wheels = partdefinition.m_171599_("wheels", CubeListBuilder.m_171558_().m_171514_(24, 12).m_171488_(-2.0f, -1.0f, -2.0f, 4.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)21.5f, (float)0.0f));
        PartDefinition left_wheel = wheels.m_171599_("left_wheel", CubeListBuilder.m_171558_().m_171514_(0, 21).m_171488_(-2.0f, -1.5f, -3.0f, 2.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)1.0f, (float)0.0f));
        left_wheel.m_171599_("left_front_wheel", CubeListBuilder.m_171558_().m_171514_(12, 21).m_171488_(-2.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(-0.001f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-3.0f));
        left_wheel.m_171599_("left_back_wheel", CubeListBuilder.m_171558_().m_171514_(12, 21).m_171488_(-2.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(-0.001f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)3.0f));
        PartDefinition right_wheel = wheels.m_171599_("right_wheel", CubeListBuilder.m_171558_().m_171514_(0, 21).m_171480_().m_171488_(0.0f, -1.5f, -3.0f, 2.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)2.0f, (float)1.0f, (float)0.0f));
        right_wheel.m_171599_("right_front_wheel", CubeListBuilder.m_171558_().m_171514_(12, 21).m_171480_().m_171488_(0.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(-0.001f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-3.0f));
        right_wheel.m_171599_("right_back_wheel", CubeListBuilder.m_171558_().m_171514_(12, 21).m_171480_().m_171488_(0.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(-0.001f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)3.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float bodyRotation;
        float armSwing;
        switch (((BaseRobotEntity)((Object)entity)).getHeadAnimation()) {
            case NOD_YES: {
                float nodProgress = Mth.m_14031_((float)(ageInTicks * 0.6f));
                this.head.f_104203_ = nodProgress * 0.6f;
                this.head.f_104204_ = 0.0f;
                break;
            }
            case SHAKE_NO: {
                float shakeProgress = Mth.m_14031_((float)(ageInTicks * 0.6f));
                this.head.f_104204_ = shakeProgress * 0.6f;
                this.head.f_104203_ = 0.0f;
                break;
            }
            default: {
                this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
                this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
            }
        }
        this.left_arm.f_104203_ = armSwing = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.right_arm.f_104203_ = -armSwing;
        this.left_wheel.f_104203_ = 0.0f;
        this.left_wheel.f_104204_ = 0.0f;
        this.left_wheel.f_104205_ = 0.0f;
        this.right_wheel.f_104203_ = 0.0f;
        this.right_wheel.f_104204_ = 0.0f;
        this.right_wheel.f_104205_ = 0.0f;
        for (bodyRotation = ((BaseRobotEntity)((Object)entity)).f_20883_ - ((BaseRobotEntity)((Object)entity)).f_20884_; bodyRotation > 180.0f; bodyRotation -= 360.0f) {
        }
        while (bodyRotation < -180.0f) {
            bodyRotation += 360.0f;
        }
        float rotationEffect = bodyRotation * 0.1f;
        float wheelRotation = limbSwing * limbSwingAmount * 2.0f;
        this.left_front_wheel.f_104203_ = wheelRotation + rotationEffect;
        this.left_back_wheel.f_104203_ = wheelRotation + rotationEffect;
        this.right_front_wheel.f_104203_ = wheelRotation - rotationEffect;
        this.right_back_wheel.f_104203_ = wheelRotation - rotationEffect;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.head.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.arms.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.wheels.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

