/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.data.energy;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;

public record EnergyData(int current, int maximum, int transferRate) {
    public static final String NBT_ENERGY = "Energy";
    public static final String NBT_MAX_ENERGY = "MaxEnergy";
    public static final String NBT_TRANSFER_RATE = "TransferRate";
    public static final int DEFAULT_TRANSFER_RATE = 100;

    public EnergyData(ItemStack itemStack) {
        this(itemStack, itemStack.m_41776_());
    }

    public EnergyData(ItemStack itemStack, int maxEnergy) {
        this(EnergyData.readFromItemStack(itemStack, maxEnergy));
    }

    private EnergyData(EnergyValues values) {
        this(values.current, values.maximum, values.transferRate);
    }

    private static EnergyValues readFromItemStack(ItemStack itemStack, int maxEnergy) {
        int transferRate;
        int maximum;
        int current;
        CompoundTag tag = itemStack.m_41783_();
        if (tag != null) {
            current = tag.m_128441_(NBT_ENERGY) ? tag.m_128451_(NBT_ENERGY) : Math.max(1, maxEnergy - itemStack.m_41773_());
            maximum = tag.m_128441_(NBT_MAX_ENERGY) ? tag.m_128451_(NBT_MAX_ENERGY) : maxEnergy;
            transferRate = tag.m_128441_(NBT_TRANSFER_RATE) ? tag.m_128451_(NBT_TRANSFER_RATE) : 100;
        } else {
            current = Math.max(1, maxEnergy - itemStack.m_41773_());
            maximum = maxEnergy;
            transferRate = 100;
        }
        return new EnergyValues(current, maximum, transferRate);
    }

    public void writeToItemStack(ItemStack itemStack) {
        CompoundTag tag = itemStack.m_41784_();
        tag.m_128405_(NBT_ENERGY, this.current);
        tag.m_128405_(NBT_MAX_ENERGY, this.maximum);
        tag.m_128405_(NBT_TRANSFER_RATE, this.transferRate);
        itemStack.m_41721_(this.maximum - Math.max(1, this.current));
    }

    public boolean hasEnergy(int amount) {
        return this.current >= amount;
    }

    public float getPercentage() {
        if (this.current <= 0 || this.maximum <= 0) {
            return 0.0f;
        }
        return (float)this.current / (float)this.maximum;
    }

    public int getDisplayEnergy() {
        return Math.round(this.getPercentage() * 100.0f);
    }

    public EnergyData consume(int amount) {
        return new EnergyData(Math.max(0, this.current - amount), this.maximum, this.transferRate);
    }

    public EnergyData add(int amount) {
        return new EnergyData(Math.min(this.maximum, this.current + amount), this.maximum, this.transferRate);
    }

    public EnergyData withCurrent(int newCurrent) {
        return new EnergyData(Math.max(0, Math.min(this.maximum, newCurrent)), this.maximum, this.transferRate);
    }

    public boolean isEmpty() {
        return this.current <= 0;
    }

    public boolean isFull() {
        return this.current >= this.maximum;
    }

    private record EnergyValues(int current, int maximum, int transferRate) {
    }
}

