/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.entity;

import de.markusbordihn.scraptechworkshop.config.ScrapRobotConfig;
import de.markusbordihn.scraptechworkshop.spawner.ScrapRobotSpawner;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="scrap_tech_workshop", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeEntitySpawnHandler {
    protected static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");
    private static final String LOG_PREFIX = "[Entity Spawn Handler]";
    private static boolean spawnsRegistered = false;

    private ForgeEntitySpawnHandler() {
    }

    @SubscribeEvent
    public static void onLevelLoad(LevelEvent.Load event) {
        if (spawnsRegistered) {
            return;
        }
        ForgeEntitySpawnHandler.registerSpawns();
        spawnsRegistered = true;
    }

    private static void registerSpawns() {
        if (!ScrapRobotConfig.mixedScrapRobotSpawnEnabled) {
            log.info("{} Mixed Scrap Robot spawning is disabled in config", (Object)LOG_PREFIX);
            return;
        }
        MobSpawnSettings.SpawnerData spawnerData = ScrapRobotSpawner.createMixedScrapRobotSpawn();
        if (spawnerData == null) {
            log.warn("{} Failed to create Mixed Scrap Robot spawner data", (Object)LOG_PREFIX);
            return;
        }
        log.info("{} Registered Mixed Scrap Robot natural spawning (weight: {}, group: {}-{})", (Object)LOG_PREFIX, (Object)ScrapRobotConfig.mixedScrapRobotSpawnWeight, (Object)ScrapRobotConfig.mixedScrapRobotSpawnMinGroup, (Object)ScrapRobotConfig.mixedScrapRobotSpawnMaxGroup);
    }
}

