/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.item;

import de.markusbordihn.scraptechworkshop.data.scrap.ScrapType;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public abstract class ScrapItem
extends Item {
    protected final ScrapType scrapType;

    protected ScrapItem(Item.Properties properties, ScrapType scrapType) {
        super(properties);
        this.scrapType = scrapType;
    }

    public ScrapType getScrapType() {
        return this.scrapType;
    }

    public abstract int getScrapValue();

    public abstract Rarity getScrapRarity();

    public boolean isRecyclable() {
        return true;
    }

    public abstract float getEfficiencyBonus();

    public Rarity m_41460_(ItemStack stack) {
        return this.getScrapRarity();
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        tooltip.add((Component)Component.m_237115_((String)(this.m_5524_() + ".description")).m_130940_(ChatFormatting.GRAY));
        this.addScrapTooltip(stack, level, tooltip, flag);
    }

    protected void addScrapTooltip(ItemStack itemStack, Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237110_((String)"tooltip.scrap_tech_workshop.scrap_value", (Object[])new Object[]{this.getScrapValue()}).m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237110_((String)"tooltip.scrap_tech_workshop.category", (Object[])new Object[]{Component.m_237115_((String)this.scrapType.getCategory().getTranslationKey())}).m_130940_(ChatFormatting.BLUE));
        Rarity rarity = this.getScrapRarity();
        tooltip.add((Component)Component.m_237110_((String)"tooltip.scrap_tech_workshop.rarity", (Object[])new Object[]{Component.m_237115_((String)("rarity." + rarity.name().toLowerCase()))}).m_130940_(rarity.f_43022_));
        if (this.getEfficiencyBonus() != 1.0f) {
            String efficiencyKey = this.getEfficiencyBonus() > 1.0f ? "tooltip.scrap_tech_workshop.efficiency.bonus" : "tooltip.scrap_tech_workshop.efficiency.penalty";
            int percentage = Math.round((this.getEfficiencyBonus() - 1.0f) * 100.0f);
            tooltip.add((Component)Component.m_237110_((String)efficiencyKey, (Object[])new Object[]{Math.abs(percentage)}).m_130940_(this.getEfficiencyBonus() > 1.0f ? ChatFormatting.GREEN : ChatFormatting.RED));
        }
        if (!this.isRecyclable()) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.scrap_tech_workshop.not_recyclable").m_130940_(ChatFormatting.DARK_RED));
        }
    }
}

