/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.menu;

import de.markusbordihn.scraptechworkshop.block.entity.recycler.RecyclerBlockEntity;
import de.markusbordihn.scraptechworkshop.block.recycler.RecyclerBlock;
import de.markusbordihn.scraptechworkshop.data.recycler.RecyclerStatus;
import de.markusbordihn.scraptechworkshop.menu.slots.DummySlot;
import de.markusbordihn.scraptechworkshop.menu.slots.RecyclerInputSlot;
import de.markusbordihn.scraptechworkshop.menu.slots.RecyclerOutputSlot;
import de.markusbordihn.scraptechworkshop.menu.slots.RecyclerUpgradeSlot;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecyclerMenu
extends AbstractContainerMenu {
    public static final int INPUT_SLOT_X = 26;
    public static final int INPUT_SLOT_Y = 35;
    public static final int SLOT_SPACING = 18;
    public static final int OUTPUT_GRID_START_X = 116;
    public static final int OUTPUT_GRID_START_Y = 17;
    public static final int OUTPUT_GRID_ROWS = 3;
    public static final int OUTPUT_GRID_COLUMNS = 3;
    public static final int UPGRADE_SLOT_START_X = 62;
    public static final int UPGRADE_SLOT_Y = 71;
    public static final int PLAYER_INVENTORY_START_X = 8;
    public static final int PLAYER_INVENTORY_START_Y = 124;
    public static final int PLAYER_INVENTORY_ROWS = 3;
    public static final int PLAYER_INVENTORY_COLUMNS = 9;
    public static final int PLAYER_HOTBAR_START_X = 8;
    public static final int PLAYER_HOTBAR_START_Y = 182;
    public static final int PLAYER_HOTBAR_SLOTS = 9;
    public static final int PROGRESS_ARROW_SIZE = 26;
    public static final int CONTAINER_DATA_SIZE = 2;
    public static final int PROGRESS_DATA_INDEX = 0;
    public static final int MAX_PROGRESS_DATA_INDEX = 1;
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");
    private static final String LOG_PREFIX = "[RECYCLER]";
    public static MenuType<RecyclerMenu> TYPE;
    private final RecyclerBlockEntity blockEntity;
    private final Level level;
    private final ContainerData data;
    private final SimpleContainer dummyContainer;
    private final BlockPos blockPos;

    public RecyclerMenu(int windowId, Inventory playerInventory, FriendlyByteBuf additionalData) {
        this(windowId, playerInventory, RecyclerMenu.getBlockEntityFromData(playerInventory, additionalData), (ContainerData)new SimpleContainerData(2));
    }

    public RecyclerMenu(int windowId, Inventory playerInventory, BlockEntity entity, ContainerData data) {
        super(TYPE, windowId);
        this.level = playerInventory.f_35978_.m_9236_();
        this.data = data != null ? data : new SimpleContainerData(2);
        this.dummyContainer = new SimpleContainer(12);
        if (entity instanceof RecyclerBlockEntity) {
            RecyclerBlockEntity recyclerEntity;
            this.blockEntity = recyclerEntity = (RecyclerBlockEntity)entity;
            this.blockPos = recyclerEntity.m_58899_();
        } else {
            log.error("{} Expected RecyclerBlockEntity but got {} at {}", (Object)LOG_PREFIX, (Object)entity, entity != null ? entity.m_58899_() : "NULL");
            this.blockEntity = null;
            this.blockPos = null;
        }
        RecyclerMenu.m_38869_((Container)playerInventory, (int)12);
        this.addRecyclerSlots();
        this.addPlayerInventory(playerInventory);
        this.addPlayerHotbar(playerInventory);
        this.m_38884_(this.data);
    }

    private static BlockEntity getBlockEntityFromData(Inventory playerInventory, FriendlyByteBuf additionalData) {
        if (additionalData == null) {
            log.error("{} additionalData is NULL", (Object)LOG_PREFIX);
            return null;
        }
        try {
            BlockPos pos = additionalData.m_130135_();
            Level level = playerInventory.f_35978_.m_9236_();
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity == null) {
                log.error("{} BlockEntity is NULL at {}", (Object)LOG_PREFIX, (Object)pos);
                return null;
            }
            return blockEntity;
        }
        catch (Exception e) {
            log.error("{} Error reading BlockEntity from additionalData: {}", (Object)LOG_PREFIX, (Object)e.getMessage());
            return null;
        }
    }

    private void addRecyclerSlots() {
        RecyclerBlockEntity entityToUse = this.getValidBlockEntity();
        if (entityToUse != null) {
            this.m_38897_(new RecyclerInputSlot(entityToUse, 0, 26, 35));
            int outputStartIndex = 1;
            for (int row = 0; row < 3; ++row) {
                for (int col = 0; col < 3; ++col) {
                    this.m_38897_(new RecyclerOutputSlot(entityToUse, outputStartIndex++, 116 + col * 18, 17 + row * 18));
                }
            }
            this.m_38897_(new RecyclerUpgradeSlot(entityToUse, 10, 62, 71));
            this.m_38897_(new RecyclerUpgradeSlot(entityToUse, 11, 80, 71));
        } else {
            for (int i = 0; i < 12; ++i) {
                this.m_38897_(new DummySlot((Container)this.dummyContainer, i, -1000, -1000));
            }
        }
    }

    private RecyclerBlockEntity getValidBlockEntity() {
        BlockEntity entity;
        if (this.blockEntity != null) {
            return this.blockEntity;
        }
        if (this.blockPos != null && this.level != null && (entity = this.level.m_7702_(this.blockPos)) instanceof RecyclerBlockEntity) {
            RecyclerBlockEntity recyclerEntity = (RecyclerBlockEntity)entity;
            log.debug("{} Resolved BlockEntity on delayed lookup", (Object)LOG_PREFIX);
            return recyclerEntity;
        }
        return null;
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 124 + row * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInventory, col, 8 + col * 18, 182));
        }
    }

    public ItemStack getCurrentInput() {
        return this.blockEntity != null ? this.blockEntity.m_8020_(0) : ItemStack.f_41583_;
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            itemStack = slotStack.m_41777_();
            int playerInventoryEnd = 39;
            int playerHotbarEnd = playerInventoryEnd + 9;
            if (this.blockEntity != null) {
                int inputEnd = 1;
                int outputEnd = inputEnd + 9;
                int upgradeEnd = outputEnd + 2;
                if (index < inputEnd ? !this.m_38903_(slotStack, 12, playerHotbarEnd, false) : (index < outputEnd ? !this.m_38903_(slotStack, 12, playerHotbarEnd, false) : (index < upgradeEnd ? !this.m_38903_(slotStack, 12, playerHotbarEnd, false) : (index < playerInventoryEnd ? !this.m_38903_(slotStack, 0, inputEnd, false) && !this.m_38903_(slotStack, outputEnd, upgradeEnd, false) && !this.m_38903_(slotStack, playerInventoryEnd, playerHotbarEnd, false) : index < playerHotbarEnd && !this.m_38903_(slotStack, 0, inputEnd, false) && !this.m_38903_(slotStack, outputEnd, upgradeEnd, false) && !this.m_38903_(slotStack, 12, playerInventoryEnd, false))))) {
                    return ItemStack.f_41583_;
                }
            } else if (index < playerInventoryEnd ? !this.m_38903_(slotStack, playerInventoryEnd, playerHotbarEnd, false) : index < playerHotbarEnd && !this.m_38903_(slotStack, 12, playerInventoryEnd, false)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemStack;
    }

    public boolean m_6875_(Player player) {
        if (this.blockEntity == null) {
            return false;
        }
        return RecyclerMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.blockEntity.m_58899_()), (Player)player, (Block)this.blockEntity.m_58900_().m_60734_());
    }

    public boolean isCrafting() {
        return this.data.m_6413_(0) > 0;
    }

    public int getScaledProgress() {
        int progress = this.data.m_6413_(0);
        int maxProgress = this.data.m_6413_(1);
        return maxProgress != 0 && progress != 0 ? progress * 26 / maxProgress : 0;
    }

    public RecyclerBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public RecyclerStatus getRecyclerStatus() {
        if (this.blockEntity == null || this.blockEntity.m_58904_() == null) {
            return RecyclerStatus.IDLE;
        }
        return (RecyclerStatus)((Object)this.blockEntity.m_58900_().m_61143_(RecyclerBlock.STATUS));
    }
}

