/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.processing;

import com.google.common.collect.BiMap;
import de.markusbordihn.scraptechworkshop.data.block.StrippableBlocks;
import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;

public class AxeInteractionHandler {
    public static InteractionResult processAxeInteraction(UseOnContext context) {
        BlockPos pos;
        Level level = context.m_43725_();
        BlockState state = level.m_8055_(pos = context.m_8083_());
        Optional<BlockState> strippedState = StrippableBlocks.getStrippedState(state);
        if (strippedState.isPresent()) {
            return AxeInteractionHandler.stripLog(context, level, pos, strippedState.get());
        }
        Optional scrapedState = WeatheringCopper.m_154899_((BlockState)state);
        if (scrapedState.isPresent()) {
            return AxeInteractionHandler.scrapeCopper(context, level, pos, (BlockState)scrapedState.get());
        }
        Optional<BlockState> unwaxedState = Optional.ofNullable((Block)((BiMap)HoneycombItem.f_150864_.get()).get((Object)state.m_60734_())).map(block -> block.m_152465_(state));
        if (unwaxedState.isPresent()) {
            return AxeInteractionHandler.removeWax(context, level, pos, unwaxedState.get());
        }
        return InteractionResult.PASS;
    }

    public static InteractionResult processCycleableWood(UseOnContext context, BlockState blockState) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Optional<BlockState> strippedState = StrippableBlocks.getStrippedState(blockState);
        if (strippedState.isPresent()) {
            return AxeInteractionHandler.stripLog(context, level, pos, strippedState.get());
        }
        Optional<BlockState> unstrippedState = StrippableBlocks.getUnstrippedState(blockState);
        if (unstrippedState.isPresent()) {
            return AxeInteractionHandler.addBark(context, level, pos, unstrippedState.get());
        }
        return InteractionResult.PASS;
    }

    private static InteractionResult addBark(UseOnContext context, Level level, BlockPos blockPos, BlockState blockState) {
        Player player = context.m_43723_();
        level.m_5594_(player, blockPos, SoundEvents.f_11688_, SoundSource.BLOCKS, 1.0f, 0.9f);
        if (!level.f_46443_) {
            level.m_7731_(blockPos, blockState, 11);
            level.m_220407_(GameEvent.f_157792_, blockPos, GameEvent.Context.m_223719_((Entity)player, (BlockState)blockState));
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaTriggers.f_10562_.m_285767_(serverPlayer, blockPos, context.m_43722_());
            }
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    private static InteractionResult stripLog(UseOnContext context, Level level, BlockPos blockPos, BlockState blockState) {
        Player player = context.m_43723_();
        level.m_5594_(player, blockPos, SoundEvents.f_11688_, SoundSource.BLOCKS, 1.0f, 1.0f);
        if (!level.f_46443_) {
            level.m_7731_(blockPos, blockState, 11);
            level.m_220407_(GameEvent.f_157792_, blockPos, GameEvent.Context.m_223719_((Entity)player, (BlockState)blockState));
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaTriggers.f_10562_.m_285767_(serverPlayer, blockPos, context.m_43722_());
            }
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    private static InteractionResult scrapeCopper(UseOnContext context, Level level, BlockPos blockPos, BlockState blockState) {
        Player player = context.m_43723_();
        level.m_5594_(player, blockPos, SoundEvents.f_144059_, SoundSource.BLOCKS, 1.0f, 1.0f);
        level.m_5898_(player, 3005, blockPos, 0);
        if (!level.f_46443_) {
            level.m_7731_(blockPos, blockState, 11);
            level.m_220407_(GameEvent.f_157792_, blockPos, GameEvent.Context.m_223719_((Entity)player, (BlockState)blockState));
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaTriggers.f_10562_.m_285767_(serverPlayer, blockPos, context.m_43722_());
            }
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    private static InteractionResult removeWax(UseOnContext context, Level level, BlockPos blockPos, BlockState blockState) {
        Player player = context.m_43723_();
        level.m_5594_(player, blockPos, SoundEvents.f_144060_, SoundSource.BLOCKS, 1.0f, 1.0f);
        level.m_5898_(player, 3004, blockPos, 0);
        if (!level.f_46443_) {
            level.m_7731_(blockPos, blockState, 11);
            level.m_220407_(GameEvent.f_157792_, blockPos, GameEvent.Context.m_223719_((Entity)player, (BlockState)blockState));
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaTriggers.f_10562_.m_285767_(serverPlayer, blockPos, context.m_43722_());
            }
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }
}

