/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.spawner;

import de.markusbordihn.scraptechworkshop.config.ScrapRobotConfig;
import de.markusbordihn.scraptechworkshop.registry.entity.MixedScrapRobotEntityRegistry;
import net.minecraft.core.Holder;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScrapRobotSpawner {
    protected static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");
    private static final String LOG_PREFIX = "[Scrap Robot Spawner]";

    private ScrapRobotSpawner() {
    }

    public static boolean shouldSpawnInBiome(Holder<Biome> biomeHolder, String biomeTypeFilter) {
        if (biomeTypeFilter.equalsIgnoreCase("ALL")) {
            return true;
        }
        if (biomeTypeFilter.equalsIgnoreCase("OVERWORLD")) {
            return !biomeHolder.m_203656_(BiomeTags.f_207612_) && !biomeHolder.m_203656_(BiomeTags.f_215818_);
        }
        return biomeTypeFilter.equalsIgnoreCase("OVERWORLD");
    }

    public static MobSpawnSettings.SpawnerData createMixedScrapRobotSpawn() {
        if (!ScrapRobotConfig.mixedScrapRobotSpawnEnabled || MixedScrapRobotEntityRegistry.MIXED_SCRAP_ROBOT_ENTITY_TYPE == null) {
            return null;
        }
        log.info("{} Creating spawn data for Mixed Scrap Robot: weight={}, min={}, max={}", (Object)LOG_PREFIX, (Object)ScrapRobotConfig.mixedScrapRobotSpawnWeight, (Object)ScrapRobotConfig.mixedScrapRobotSpawnMinGroup, (Object)ScrapRobotConfig.mixedScrapRobotSpawnMaxGroup);
        return new MobSpawnSettings.SpawnerData(MixedScrapRobotEntityRegistry.MIXED_SCRAP_ROBOT_ENTITY_TYPE, ScrapRobotConfig.mixedScrapRobotSpawnWeight, ScrapRobotConfig.mixedScrapRobotSpawnMinGroup, ScrapRobotConfig.mixedScrapRobotSpawnMaxGroup);
    }

    public static void logSpawnRegistration(String biomeKey) {
        if (ScrapRobotConfig.mixedScrapRobotSpawnEnabled) {
            log.debug("{} Registered Mixed Scrap Robot spawn in biome: {}", (Object)LOG_PREFIX, (Object)biomeKey);
        }
    }
}

