/*
 * Decompiled with CFR 0.152.
 */
package com.lightyorugami.reworkeddeath.event;

import com.lightyorugami.reworkeddeath.enchantment.ModEnchantments;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class PlayerDeathDropHandler {
    private static final int SIX_HOURS_IN_TICKS = 432000;
    private static final Random random = new Random();
    public static final Map<UUID, List<ItemStack>> DEATHBOUND_CACHE = new HashMap<UUID, List<ItemStack>>();

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        ArrayList<ItemStack> keptItems = new ArrayList<ItemStack>();
        Iterator iterator = event.getDrops().iterator();
        while (iterator.hasNext()) {
            ItemEntity itemEntity = (ItemEntity)iterator.next();
            ItemStack stack = itemEntity.m_32055_();
            itemEntity.getPersistentData().m_128379_("DroppedOnDeath", true);
            itemEntity.lifespan = 432000;
            int level = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.DEATHBOUND.get()), (ItemStack)stack);
            if (level <= 0) continue;
            iterator.remove();
            Map enchants = EnchantmentHelper.m_44831_((ItemStack)stack);
            boolean shouldDowngrade = false;
            if (level == 1) {
                shouldDowngrade = random.nextFloat() < 0.5f;
            } else if (level == 2) {
                shouldDowngrade = random.nextFloat() < 0.33f;
            } else if (level == 3) {
                boolean bl = shouldDowngrade = random.nextFloat() < 0.25f;
            }
            if (shouldDowngrade) {
                if (level == 1) {
                    enchants.remove(ModEnchantments.DEATHBOUND.get());
                } else {
                    enchants.put((Enchantment)ModEnchantments.DEATHBOUND.get(), level - 1);
                }
                EnchantmentHelper.m_44865_((Map)enchants, (ItemStack)stack);
            }
            if (stack.m_41763_()) {
                int currentDamage = stack.m_41773_();
                int maxDamage = stack.m_41776_();
                int remaining = maxDamage - currentDamage;
                if (remaining > 1) {
                    int percentLoss = 25 + random.nextInt(26);
                    int extraDamage = remaining * percentLoss / 100;
                    stack.m_41721_(currentDamage + extraDamage);
                }
            }
            keptItems.add(stack);
        }
        if (!keptItems.isEmpty()) {
            DEATHBOUND_CACHE.put(player.m_20148_(), keptItems);
        }
    }
}

