/*
 * Decompiled with CFR 0.152.
 */
package net.oszurteap.client.fluid;

import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.fog.FogData;
import net.minecraft.client.renderer.fog.environment.FogEnvironment;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.fluids.FluidType;
import net.oszurteap.init.OszuRteapModFluidTypes;
import org.joml.Vector4f;

@EventBusSubscriber(value={Dist.CLIENT})
public class RTeaFluidExtension {
    @SubscribeEvent
    public static void registerFluidTypeExtensions(RegisterClientExtensionsEvent event) {
        event.registerFluidType(new IClientFluidTypeExtensions(){
            private static final ResourceLocation STILL_TEXTURE = ResourceLocation.parse((String)"oszu_rteap:block/tea_still");
            private static final ResourceLocation FLOWING_TEXTURE = ResourceLocation.parse((String)"oszu_rteap:block/tea_flow");
            private static final ResourceLocation RENDER_OVERLAY_TEXTURE = ResourceLocation.parse((String)"oszu_rteap:textures/rtea_overlay.png");

            public ResourceLocation getStillTexture() {
                return STILL_TEXTURE;
            }

            public ResourceLocation getFlowingTexture() {
                return FLOWING_TEXTURE;
            }

            public ResourceLocation getRenderOverlayTexture(Minecraft minecraft) {
                return RENDER_OVERLAY_TEXTURE;
            }

            public Vector4f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector4f fluidFogColor) {
                return new Vector4f(0.10980392f, 0.078431375f, 0.0f, fluidFogColor.w);
            }

            public void modifyFogRender(Camera camera, @Nullable FogEnvironment environment, float renderDistance, float partialTick, FogData fogData) {
                float nearDistance = fogData.environmentalStart;
                float farDistance = fogData.environmentalEnd;
                Entity entity = camera.getEntity();
                Level world = entity.level();
                fogData.environmentalStart = 0.0f;
                fogData.environmentalEnd = 1.0f;
            }
        }, new FluidType[]{(FluidType)OszuRteapModFluidTypes.R_TEA_TYPE.get()});
    }
}

