/*
 * Decompiled with CFR 0.152.
 */
package net.oszurteap.configuration;

import net.neoforged.neoforge.common.ModConfigSpec;

public class RtpconfigConfiguration {
    public static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    public static final ModConfigSpec SPEC;
    public static final ModConfigSpec.ConfigValue<Boolean> APPLY_COOLDOWN_IN_CREATIVE;
    public static final ModConfigSpec.ConfigValue<Boolean> CONSUME_BUCKET_IN_CREATIVE;
    public static final ModConfigSpec.ConfigValue<Boolean> GLOBAL_COOLDOWN;
    public static final ModConfigSpec.ConfigValue<Boolean> RTP_WHEN_IN_FLUID;
    public static final ModConfigSpec.ConfigValue<Double> FLUID_RTP_TIMER;
    public static final ModConfigSpec.ConfigValue<Double> FLUID_RTP_DISTANCE;
    public static final ModConfigSpec.ConfigValue<Double> BUCKET_RTP_COOLDOWN;
    public static final ModConfigSpec.ConfigValue<Double> BUCKET_RTP_DISTANCE;
    public static final ModConfigSpec.ConfigValue<Double> BOTTLE_RTP_COOLDOWN;
    public static final ModConfigSpec.ConfigValue<Double> BOTTLE_RTP_DISTANCE;

    static {
        BUILDER.push("misc");
        APPLY_COOLDOWN_IN_CREATIVE = BUILDER.comment("Apply item cooldown when consumed in creative mode (Default: false)").define("apply_cooldown_in_creative", false);
        CONSUME_BUCKET_IN_CREATIVE = BUILDER.comment("Consume the Bukka rteap when consumed in creative mode (Default: false)").define("consume_bucket_in_creative", false);
        GLOBAL_COOLDOWN = BUILDER.comment("Trigger item cooldowns for both Buckets and bottles when either are consumed (Default: true)").define("global_cooldown", true);
        BUILDER.pop();
        BUILDER.push("rtea_fluid");
        RTP_WHEN_IN_FLUID = BUILDER.comment("RTP the player when they are within the fluid for the set duration (Default: true)").define("rtp_when_in_fluid", true);
        FLUID_RTP_TIMER = BUILDER.comment("Time in ticks to count before the RTP of the player (Default: 100)").define("fluid_rtp_timer", (Object)100.0);
        FLUID_RTP_DISTANCE = BUILDER.comment("Distance to RTP the player when fluid RTP ticks down (Default: 16)").define("fluid_rtp_distance", (Object)16.0);
        BUILDER.pop();
        BUILDER.push("rtea_bucket");
        BUCKET_RTP_COOLDOWN = BUILDER.comment("Cooldown for using RTP bucket (Default: 6000)").define("bucket_rtp_cooldown", (Object)6000.0);
        BUCKET_RTP_DISTANCE = BUILDER.comment("Distance to RTP the player when drinking from RTP Bucket (Default: 29999900)").define("bucket_rtp_distance", (Object)2.99999E7);
        BUILDER.pop();
        BUILDER.push("rtea_bottle");
        BOTTLE_RTP_COOLDOWN = BUILDER.comment("Cooldown for using RTP bottle (Default: 1200)").define("bottle_rtp_cooldown", (Object)1200.0);
        BOTTLE_RTP_DISTANCE = BUILDER.comment("Distance to RTP the player when drinking from RTP bottle (Default: 1000)").define("bottle_rtp_distance", (Object)1000.0);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

