/*
 * Decompiled with CFR 0.152.
 */
package net.oszurteap.fluid;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;
import net.oszurteap.init.OszuRteapModBlocks;
import net.oszurteap.init.OszuRteapModFluidTypes;
import net.oszurteap.init.OszuRteapModFluids;
import net.oszurteap.init.OszuRteapModItems;

public abstract class RTeaFluid
extends BaseFlowingFluid {
    public static final BaseFlowingFluid.Properties PROPERTIES = new BaseFlowingFluid.Properties(() -> (FluidType)OszuRteapModFluidTypes.R_TEA_TYPE.get(), () -> (Fluid)OszuRteapModFluids.R_TEA.get(), () -> (Fluid)OszuRteapModFluids.FLOWING_R_TEA.get()).explosionResistance(100.0f).bucket(() -> (Item)OszuRteapModItems.R_TEA_BUCKET.get()).block(() -> (LiquidBlock)OszuRteapModBlocks.R_TEA.get());

    private RTeaFluid() {
        super(PROPERTIES);
    }

    public ParticleOptions getDripParticle() {
        return ParticleTypes.FALLING_WATER;
    }

    public static class Flowing
    extends RTeaFluid {
        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }

        public int getAmount(FluidState state) {
            return (Integer)state.getValue((Property)LEVEL);
        }

        public boolean isSource(FluidState state) {
            return false;
        }
    }

    public static class Source
    extends RTeaFluid {
        public int getAmount(FluidState state) {
            return 8;
        }

        public boolean isSource(FluidState state) {
            return true;
        }
    }
}

